package software.amazon.awscdk;

/**
 * Base class for creating a custom resource provider.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.070Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResourceProviderBase")
public abstract class CustomResourceProviderBase extends software.constructs.Construct {

    protected CustomResourceProviderBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomResourceProviderBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CustomResourceProviderBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CustomResourceProviderBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an IAM policy statement to the inline policy of the provider's lambda function's role.
     * <p>
     * <strong>Please note</strong>: this is a direct IAM JSON policy blob, <em>not</em> a <code>iam.PolicyStatement</code>
     * object like you will see in the rest of the CDK.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CustomResourceProvider myProvider;
     * myProvider.addToRolePolicy(Map.of(
     *         "Effect", "Allow",
     *         "Action", "s3:GetObject",
     *         "Resource", "*"));
     * </pre></blockquote>
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull java.lang.Object statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { statement });
    }

    /**
     * The hash of the lambda code backing this provider.
     * <p>
     * Can be used to trigger updates
     * on code changes, even when the properties of a custom resource remain unchanged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCodeHash() {
        return software.amazon.jsii.Kernel.get(this, "codeHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the provider's AWS Lambda function role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the provider's AWS Lambda function which should be used as the <code>serviceToken</code> when defining a custom resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceToken() {
        return software.amazon.jsii.Kernel.get(this, "serviceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.CustomResourceProviderBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
