package software.amazon.awscdk;

/**
 * Fragments of a concatenated string containing stringified Tokens.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * TokenizedStringFragments tokenizedStringFragments = new TokenizedStringFragments();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.186Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.TokenizedStringFragments")
public class TokenizedStringFragments extends software.amazon.jsii.JsiiObject {

    protected TokenizedStringFragments(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TokenizedStringFragments(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TokenizedStringFragments() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIntrinsic(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addIntrinsic", software.amazon.jsii.NativeType.VOID, new Object[] { value });
    }

    /**
     * @param lit This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLiteral(final @org.jetbrains.annotations.NotNull java.lang.Object lit) {
        software.amazon.jsii.Kernel.call(this, "addLiteral", software.amazon.jsii.NativeType.VOID, new Object[] { lit });
    }

    /**
     * @param token This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToken(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable token) {
        software.amazon.jsii.Kernel.call(this, "addToken", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(token, "token is required") });
    }

    /**
     * Combine the string fragments using the given joiner.
     * <p>
     * If there are any
     * <p>
     * @param concat This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object join(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IFragmentConcatenator concat) {
        return software.amazon.jsii.Kernel.call(this, "join", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(concat, "concat is required") });
    }

    /**
     * Apply a transformation function to all tokens in the string.
     * <p>
     * @param mapper This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TokenizedStringFragments mapTokens(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ITokenMapper mapper) {
        return software.amazon.jsii.Kernel.call(this, "mapTokens", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TokenizedStringFragments.class), new Object[] { java.util.Objects.requireNonNull(mapper, "mapper is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFirstValue() {
        return software.amazon.jsii.Kernel.get(this, "firstValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getLength() {
        return software.amazon.jsii.Kernel.get(this, "length", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return all Tokens from this string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.IResolvable> getTokens() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "tokens", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable getFirstToken() {
        return software.amazon.jsii.Kernel.get(this, "firstToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }
}
