package software.amazon.awscdk.services.appconfig;

/**
 * Properties for DeploymentStrategy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DeploymentStrategy.Builder.create(this, "MyDeploymentStrategy")
 *         .rolloutStrategy(RolloutStrategy.linear(RolloutStrategyProps.builder()
 *                 .growthFactor(20)
 *                 .deploymentDuration(Duration.minutes(30))
 *                 .finalBakeTime(Duration.minutes(30))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.DeploymentStrategyProps")
@software.amazon.jsii.Jsii.Proxy(DeploymentStrategyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentStrategyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The rollout strategy for the deployment strategy.
     * <p>
     * You can use predefined deployment
     * strategies, such as RolloutStrategy.ALL_AT_ONCE, RolloutStrategy.LINEAR_50_PERCENT_EVERY_30_SECONDS,
     * or RolloutStrategy.CANARY_10_PERCENT_20_MINUTES.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.RolloutStrategy getRolloutStrategy();

    /**
     * A name for the deployment strategy.
     * <p>
     * Default: - A name is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentStrategyName() {
        return null;
    }

    /**
     * A description of the deployment strategy.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentStrategyProps> {
        software.amazon.awscdk.services.appconfig.RolloutStrategy rolloutStrategy;
        java.lang.String deploymentStrategyName;
        java.lang.String description;

        /**
         * Sets the value of {@link DeploymentStrategyProps#getRolloutStrategy}
         * @param rolloutStrategy The rollout strategy for the deployment strategy. This parameter is required.
         *                        You can use predefined deployment
         *                        strategies, such as RolloutStrategy.ALL_AT_ONCE, RolloutStrategy.LINEAR_50_PERCENT_EVERY_30_SECONDS,
         *                        or RolloutStrategy.CANARY_10_PERCENT_20_MINUTES.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rolloutStrategy(software.amazon.awscdk.services.appconfig.RolloutStrategy rolloutStrategy) {
            this.rolloutStrategy = rolloutStrategy;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentStrategyProps#getDeploymentStrategyName}
         * @param deploymentStrategyName A name for the deployment strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStrategyName(java.lang.String deploymentStrategyName) {
            this.deploymentStrategyName = deploymentStrategyName;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentStrategyProps#getDescription}
         * @param description A description of the deployment strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentStrategyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentStrategyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentStrategyProps {
        private final software.amazon.awscdk.services.appconfig.RolloutStrategy rolloutStrategy;
        private final java.lang.String deploymentStrategyName;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rolloutStrategy = software.amazon.jsii.Kernel.get(this, "rolloutStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class));
            this.deploymentStrategyName = software.amazon.jsii.Kernel.get(this, "deploymentStrategyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rolloutStrategy = java.util.Objects.requireNonNull(builder.rolloutStrategy, "rolloutStrategy is required");
            this.deploymentStrategyName = builder.deploymentStrategyName;
            this.description = builder.description;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.RolloutStrategy getRolloutStrategy() {
            return this.rolloutStrategy;
        }

        @Override
        public final java.lang.String getDeploymentStrategyName() {
            return this.deploymentStrategyName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rolloutStrategy", om.valueToTree(this.getRolloutStrategy()));
            if (this.getDeploymentStrategyName() != null) {
                data.set("deploymentStrategyName", om.valueToTree(this.getDeploymentStrategyName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.DeploymentStrategyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentStrategyProps.Jsii$Proxy that = (DeploymentStrategyProps.Jsii$Proxy) o;

            if (!rolloutStrategy.equals(that.rolloutStrategy)) return false;
            if (this.deploymentStrategyName != null ? !this.deploymentStrategyName.equals(that.deploymentStrategyName) : that.deploymentStrategyName != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rolloutStrategy.hashCode();
            result = 31 * result + (this.deploymentStrategyName != null ? this.deploymentStrategyName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
