package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for defining a <code>CfnScalableTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * CfnScalableTargetProps cfnScalableTargetProps = CfnScalableTargetProps.builder()
 *         .maxCapacity(123)
 *         .minCapacity(123)
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .serviceNamespace("serviceNamespace")
 *         // the properties below are optional
 *         .roleArn("roleArn")
 *         .scheduledActions(List.of(ScheduledActionProperty.builder()
 *                 .schedule("schedule")
 *                 .scheduledActionName("scheduledActionName")
 *                 // the properties below are optional
 *                 .endTime(new Date())
 *                 .scalableTargetAction(ScalableTargetActionProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .build())
 *                 .startTime(new Date())
 *                 .timezone("timezone")
 *                 .build()))
 *         .suspendedState(SuspendedStateProperty.builder()
 *                 .dynamicScalingInSuspended(false)
 *                 .dynamicScalingOutSuspended(false)
 *                 .scheduledScalingSuspended(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.980Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalableTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnScalableTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScalableTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum value that you plan to scale out to.
     * <p>
     * When a scaling policy is in effect, Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

    /**
     * The minimum value that you plan to scale in to.
     * <p>
     * When a scaling policy is in effect, Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing demand.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

    /**
     * The identifier of the resource associated with the scalable target.
     * <p>
     * This string consists of the resource type and unique identifier.
     * <p>
     * <ul>
     * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
     * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
     * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
     * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
     * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
     * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
     * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
     * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
     * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
     * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
     * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
     * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
     * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
     * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
     * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
     * <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The scalable dimension associated with the scalable target.
     * <p>
     * This string consists of the service namespace, resource type, and scaling property.
     * <p>
     * <ul>
     * <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
     * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
     * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
     * <li><code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</li>
     * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
     * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
     * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
     * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
     * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
     * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
     * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
     * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
     * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
     * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
     * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
     * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
     * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
     * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
     * <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
     * <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension();

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceNamespace();

    /**
     * Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf.
     * <p>
     * This can be either an IAM service role that Application Auto Scaling can assume to make calls to other AWS resources on your behalf, or a service-linked role for the specified service. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html">How Application Auto Scaling works with IAM</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * To automatically create a service-linked role (recommended), specify the full ARN of the service-linked role in your stack template. To find the exact ARN of the service-linked role for your AWS or custom resource, see the <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-service-linked-roles.html">Service-linked roles</a> topic in the <em>Application Auto Scaling User Guide</em> . Look for the ARN in the table at the bottom of the page.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * The scheduled actions for the scalable target.
     * <p>
     * Duplicates aren't allowed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScheduledActions() {
        return null;
    }

    /**
     * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
     * <p>
     * Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
     * <p>
     * <em>Suspension Outcomes</em>
     * <p>
     * <ul>
     * <li>For <code>DynamicScalingInSuspended</code> , while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended.</li>
     * <li>For <code>DynamicScalingOutSuspended</code> , while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended.</li>
     * <li>For <code>ScheduledScalingSuspended</code> , while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSuspendedState() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScalableTargetProps> {
        java.lang.Number maxCapacity;
        java.lang.Number minCapacity;
        java.lang.String resourceId;
        java.lang.String scalableDimension;
        java.lang.String serviceNamespace;
        java.lang.String roleArn;
        java.lang.Object scheduledActions;
        java.lang.Object suspendedState;

        /**
         * Sets the value of {@link CfnScalableTargetProps#getMaxCapacity}
         * @param maxCapacity The maximum value that you plan to scale out to. This parameter is required.
         *                    When a scaling policy is in effect, Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getMinCapacity}
         * @param minCapacity The minimum value that you plan to scale in to. This parameter is required.
         *                    When a scaling policy is in effect, Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing demand.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getResourceId}
         * @param resourceId The identifier of the resource associated with the scalable target. This parameter is required.
         *                   This string consists of the resource type and unique identifier.
         *                   <p>
         *                   <ul>
         *                   <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
         *                   <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         *                   <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
         *                   <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
         *                   <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
         *                   <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
         *                   <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         *                   <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         *                   <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
         *                   <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
         *                   <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
         *                   <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
         *                   <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
         *                   <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
         *                   <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
         *                   <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
         *                   <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         *                   <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getScalableDimension}
         * @param scalableDimension The scalable dimension associated with the scalable target. This parameter is required.
         *                          This string consists of the service namespace, resource type, and scaling property.
         *                          <p>
         *                          <ul>
         *                          <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
         *                          <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
         *                          <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
         *                          <li><code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.</li>
         *                          <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         *                          <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         *                          <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         *                          <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         *                          <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         *                          <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
         *                          <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
         *                          <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
         *                          <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
         *                          <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
         *                          <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
         *                          <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
         *                          <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
         *                          <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
         *                          <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
         *                          <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
         *                          <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
         *                          <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(java.lang.String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getServiceNamespace}
         * @param serviceNamespace The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(java.lang.String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getRoleArn}
         * @param roleArn Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf.
         *                This can be either an IAM service role that Application Auto Scaling can assume to make calls to other AWS resources on your behalf, or a service-linked role for the specified service. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html">How Application Auto Scaling works with IAM</a> in the <em>Application Auto Scaling User Guide</em> .
         *                <p>
         *                To automatically create a service-linked role (recommended), specify the full ARN of the service-linked role in your stack template. To find the exact ARN of the service-linked role for your AWS or custom resource, see the <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-service-linked-roles.html">Service-linked roles</a> topic in the <em>Application Auto Scaling User Guide</em> . Look for the ARN in the table at the bottom of the page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getScheduledActions}
         * @param scheduledActions The scheduled actions for the scalable target.
         *                         Duplicates aren't allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(software.amazon.awscdk.IResolvable scheduledActions) {
            this.scheduledActions = scheduledActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getScheduledActions}
         * @param scheduledActions The scheduled actions for the scalable target.
         *                         Duplicates aren't allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(java.util.List<? extends java.lang.Object> scheduledActions) {
            this.scheduledActions = scheduledActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getSuspendedState}
         * @param suspendedState An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
         *                       Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         *                       <p>
         *                       <em>Suspension Outcomes</em>
         *                       <p>
         *                       <ul>
         *                       <li>For <code>DynamicScalingInSuspended</code> , while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended.</li>
         *                       <li>For <code>DynamicScalingOutSuspended</code> , while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended.</li>
         *                       <li>For <code>ScheduledScalingSuspended</code> , while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(software.amazon.awscdk.IResolvable suspendedState) {
            this.suspendedState = suspendedState;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalableTargetProps#getSuspendedState}
         * @param suspendedState An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
         *                       Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         *                       <p>
         *                       <em>Suspension Outcomes</em>
         *                       <p>
         *                       <ul>
         *                       <li>For <code>DynamicScalingInSuspended</code> , while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended.</li>
         *                       <li>For <code>DynamicScalingOutSuspended</code> , while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended.</li>
         *                       <li>For <code>ScheduledScalingSuspended</code> , while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty suspendedState) {
            this.suspendedState = suspendedState;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScalableTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScalableTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScalableTargetProps {
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;
        private final java.lang.String resourceId;
        private final java.lang.String scalableDimension;
        private final java.lang.String serviceNamespace;
        private final java.lang.String roleArn;
        private final java.lang.Object scheduledActions;
        private final java.lang.Object suspendedState;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalableDimension = software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNamespace = software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduledActions = software.amazon.jsii.Kernel.get(this, "scheduledActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.suspendedState = software.amazon.jsii.Kernel.get(this, "suspendedState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
            this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.scalableDimension = java.util.Objects.requireNonNull(builder.scalableDimension, "scalableDimension is required");
            this.serviceNamespace = java.util.Objects.requireNonNull(builder.serviceNamespace, "serviceNamespace is required");
            this.roleArn = builder.roleArn;
            this.scheduledActions = builder.scheduledActions;
            this.suspendedState = builder.suspendedState;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final java.lang.String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getScheduledActions() {
            return this.scheduledActions;
        }

        @Override
        public final java.lang.Object getSuspendedState() {
            return this.suspendedState;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
            data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getScheduledActions() != null) {
                data.set("scheduledActions", om.valueToTree(this.getScheduledActions()));
            }
            if (this.getSuspendedState() != null) {
                data.set("suspendedState", om.valueToTree(this.getSuspendedState()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalableTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScalableTargetProps.Jsii$Proxy that = (CfnScalableTargetProps.Jsii$Proxy) o;

            if (!maxCapacity.equals(that.maxCapacity)) return false;
            if (!minCapacity.equals(that.minCapacity)) return false;
            if (!resourceId.equals(that.resourceId)) return false;
            if (!scalableDimension.equals(that.scalableDimension)) return false;
            if (!serviceNamespace.equals(that.serviceNamespace)) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.scheduledActions != null ? !this.scheduledActions.equals(that.scheduledActions) : that.scheduledActions != null) return false;
            return this.suspendedState != null ? this.suspendedState.equals(that.suspendedState) : that.suspendedState == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxCapacity.hashCode();
            result = 31 * result + (this.minCapacity.hashCode());
            result = 31 * result + (this.resourceId.hashCode());
            result = 31 * result + (this.scalableDimension.hashCode());
            result = 31 * result + (this.serviceNamespace.hashCode());
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.scheduledActions != null ? this.scheduledActions.hashCode() : 0);
            result = 31 * result + (this.suspendedState != null ? this.suspendedState.hashCode() : 0);
            return result;
        }
    }
}
