package software.amazon.awscdk.services.appmesh;

/**
 * Properties to define new Routes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * Mesh mesh;
 * RouteSpec routeSpec;
 * VirtualRouter virtualRouter;
 * RouteProps routeProps = RouteProps.builder()
 *         .mesh(mesh)
 *         .routeSpec(routeSpec)
 *         .virtualRouter(virtualRouter)
 *         // the properties below are optional
 *         .routeName("routeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.225Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.RouteProps")
@software.amazon.jsii.Jsii.Proxy(RouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appmesh.RouteBaseProps {

    /**
     * The service mesh to define the route in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * The VirtualRouter the Route belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter getVirtualRouter();

    /**
     * @return a {@link Builder} of {@link RouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteProps> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter;
        software.amazon.awscdk.services.appmesh.RouteSpec routeSpec;
        java.lang.String routeName;

        /**
         * Sets the value of {@link RouteProps#getMesh}
         * @param mesh The service mesh to define the route in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link RouteProps#getVirtualRouter}
         * @param virtualRouter The VirtualRouter the Route belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouter(software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        /**
         * Sets the value of {@link RouteProps#getRouteSpec}
         * @param routeSpec Protocol specific spec. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSpec(software.amazon.awscdk.services.appmesh.RouteSpec routeSpec) {
            this.routeSpec = routeSpec;
            return this;
        }

        /**
         * Sets the value of {@link RouteProps#getRouteName}
         * @param routeName The name of the route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeName(java.lang.String routeName) {
            this.routeName = routeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteProps {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter;
        private final software.amazon.awscdk.services.appmesh.RouteSpec routeSpec;
        private final java.lang.String routeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualRouter = software.amazon.jsii.Kernel.get(this, "virtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualRouter.class));
            this.routeSpec = software.amazon.jsii.Kernel.get(this, "routeSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpec.class));
            this.routeName = software.amazon.jsii.Kernel.get(this, "routeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualRouter = java.util.Objects.requireNonNull(builder.virtualRouter, "virtualRouter is required");
            this.routeSpec = java.util.Objects.requireNonNull(builder.routeSpec, "routeSpec is required");
            this.routeName = builder.routeName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IVirtualRouter getVirtualRouter() {
            return this.virtualRouter;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.RouteSpec getRouteSpec() {
            return this.routeSpec;
        }

        @Override
        public final java.lang.String getRouteName() {
            return this.routeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            data.set("virtualRouter", om.valueToTree(this.getVirtualRouter()));
            data.set("routeSpec", om.valueToTree(this.getRouteSpec()));
            if (this.getRouteName() != null) {
                data.set("routeName", om.valueToTree(this.getRouteName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.RouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteProps.Jsii$Proxy that = (RouteProps.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            if (!virtualRouter.equals(that.virtualRouter)) return false;
            if (!routeSpec.equals(that.routeSpec)) return false;
            return this.routeName != null ? this.routeName.equals(that.routeName) : that.routeName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualRouter.hashCode());
            result = 31 * result + (this.routeSpec.hashCode());
            result = 31 * result + (this.routeName != null ? this.routeName.hashCode() : 0);
            return result;
        }
    }
}
