package software.amazon.awscdk.services.autoscaling.hooktargets;

/**
 * Use an SQS queue as a hook target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.hooktargets.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Queue queue;
 * QueueHook queueHook = new QueueHook(queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling_hooktargets.QueueHook")
public class QueueHook extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget {

    protected QueueHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueueHook(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * If an <code>IRole</code> is found in <code>options</code>, grant it access to send messages.
     * <p>
     * Otherwise, create a new <code>IRole</code> and grant it access to send messages.
     * <p>
     * @return the <code>IRole</code> with access to send messages and the ARN of the queue it has access to send messages to.
     * @param _scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BindHookTargetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
