package software.amazon.awscdk.services.batch;

/**
 * Props to configure an EksContainerDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksContainerDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(EksContainerDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EksContainerDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The image that this container will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * An array of arguments to the entrypoint.
     * <p>
     * If this isn't specified, the CMD of the container image is used.
     * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
     * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
     * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
     * <p>
     * Default: - no args
     * <p>
     * @see <a href="https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * The entrypoint for the container.
     * <p>
     * This isn't run within a shell.
     * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
     * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
     * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
     * <p>
     * The entrypoint can't be updated.
     * <p>
     * Default: - no command
     * <p>
     * @see <a href="https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     * <p>
     * Default: - No CPU limit
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuLimit() {
        return null;
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     * <p>
     * Default: - No CPUs reserved
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuReservation() {
        return null;
    }

    /**
     * The environment variables to pass to this container.
     * <p>
     * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
     * This naming convention is reserved for variables that AWS Batch sets.
     * <p>
     * Default: - no environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * The hard limit of GPUs to present to this container.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     * <p>
     * Default: - No GPU limit
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuLimit() {
        return null;
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     * <p>
     * Default: - No GPUs reserved
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuReservation() {
        return null;
    }

    /**
     * The image pull policy for this container.
     * <p>
     * Default: - `ALWAYS` if the `:latest` tag is specified, `IF_NOT_PRESENT` otherwise
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#updating-images">https://kubernetes.io/docs/concepts/containers/images/#updating-images</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
        return null;
    }

    /**
     * The amount (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed the allocated memory, it will be terminated.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     * <p>
     * Default: - No memory limit
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryLimit() {
        return null;
    }

    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * <p>
     * Your container will be given at least this much memory, but may consume more.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * When system memory is under heavy contention, Docker attempts to keep the
     * container memory to this soft limit. However, your container can consume more
     * memory when it needs to, up to either the hard limit specified with the memory
     * parameter (if applicable), or all of the available memory on the container
     * instance, whichever comes first.
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
     * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     * <p>
     * Default: - No memory reserved
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryReservation() {
        return null;
    }

    /**
     * The name of this container.
     * <p>
     * Default: : `'Default'`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * If specified, gives this container elevated permissions on the host container instance.
     * <p>
     * The level of permissions are similar to the root user permissions.
     * <p>
     * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * If specified, gives this container readonly access to its root file system.
     * <p>
     * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
        return null;
    }

    /**
     * If specified, the container is run as the specified group ID (<code>gid</code>).
     * <p>
     * If this parameter isn't specified, the default is the group that's specified in the image metadata.
     * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
        return null;
    }

    /**
     * If specified, the container is run as a user with a <code>uid</code> other than 0.
     * <p>
     * Otherwise, no such rule is enforced.
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: - the container is *not* required to run as a non-root user
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRunAsRoot() {
        return null;
    }

    /**
     * If specified, this container is run as the specified user ID (<code>uid</code>).
     * <p>
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: - the user that is specified in the image metadata.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
        return null;
    }

    /**
     * The Volumes to mount to this container.
     * <p>
     * Automatically added to the Pod.
     * <p>
     * Default: - no volumes
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/">https://kubernetes.io/docs/concepts/storage/volumes/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EksContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EksContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EksContainerDefinitionProps> {
        software.amazon.awscdk.services.ecs.ContainerImage image;
        java.util.List<java.lang.String> args;
        java.util.List<java.lang.String> command;
        java.lang.Number cpuLimit;
        java.lang.Number cpuReservation;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.lang.Number gpuLimit;
        java.lang.Number gpuReservation;
        software.amazon.awscdk.services.batch.ImagePullPolicy imagePullPolicy;
        software.amazon.awscdk.Size memoryLimit;
        software.amazon.awscdk.Size memoryReservation;
        java.lang.String name;
        java.lang.Boolean privileged;
        java.lang.Boolean readonlyRootFilesystem;
        java.lang.Number runAsGroup;
        java.lang.Boolean runAsRoot;
        java.lang.Number runAsUser;
        java.util.List<software.amazon.awscdk.services.batch.EksVolume> volumes;

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getImage}
         * @param image The image that this container will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getArgs}
         * @param args An array of arguments to the entrypoint.
         *             If this isn't specified, the CMD of the container image is used.
         *             This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
         *             Environment variable references are expanded using the container's environment.
         *             If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         *             For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
         *             the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
         *             or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(java.util.List<java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getCommand}
         * @param command The entrypoint for the container.
         *                This isn't run within a shell.
         *                If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
         *                Environment variable references are expanded using the container's environment.
         *                If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         *                For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
         *                the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
         *                For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
         *                <p>
         *                The entrypoint can't be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getCpuLimit}
         * @param cpuLimit The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
         *                 If your container attempts to exceed this limit, it will be terminated.
         *                 <p>
         *                 At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         *                 If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuLimit(java.lang.Number cpuLimit) {
            this.cpuLimit = cpuLimit;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getCpuReservation}
         * @param cpuReservation The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         *                       The container will given at least this many CPUs, but may consume more.
         *                       <p>
         *                       At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         *                       If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuReservation(java.lang.Number cpuReservation) {
            this.cpuReservation = cpuReservation;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getEnv}
         * @param env The environment variables to pass to this container.
         *            <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
         *            This naming convention is reserved for variables that AWS Batch sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getGpuLimit}
         * @param gpuLimit The hard limit of GPUs to present to this container.
         *                 If your container attempts to exceed this limit, it will be terminated.
         *                 <p>
         *                 If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuLimit(java.lang.Number gpuLimit) {
            this.gpuLimit = gpuLimit;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getGpuReservation}
         * @param gpuReservation The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         *                       The container will given at least this many CPUs, but may consume more.
         *                       <p>
         *                       If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuReservation(java.lang.Number gpuReservation) {
            this.gpuReservation = gpuReservation;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getImagePullPolicy}
         * @param imagePullPolicy The image pull policy for this container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imagePullPolicy(software.amazon.awscdk.services.batch.ImagePullPolicy imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getMemoryLimit}
         * @param memoryLimit The amount (in MiB) of memory to present to the container.
         *                    If your container attempts to exceed the allocated memory, it will be terminated.
         *                    <p>
         *                    Must be larger that 4 MiB
         *                    <p>
         *                    At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
         *                    <p>
         *                    <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         *                    for the specific instance type that you are using.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(software.amazon.awscdk.Size memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getMemoryReservation}
         * @param memoryReservation The soft limit (in MiB) of memory to reserve for the container.
         *                          Your container will be given at least this much memory, but may consume more.
         *                          <p>
         *                          Must be larger that 4 MiB
         *                          <p>
         *                          When system memory is under heavy contention, Docker attempts to keep the
         *                          container memory to this soft limit. However, your container can consume more
         *                          memory when it needs to, up to either the hard limit specified with the memory
         *                          parameter (if applicable), or all of the available memory on the container
         *                          instance, whichever comes first.
         *                          <p>
         *                          At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
         *                          If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
         *                          <p>
         *                          <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         *                          for the specific instance type that you are using.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservation(software.amazon.awscdk.Size memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getName}
         * @param name The name of this container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getPrivileged}
         * @param privileged If specified, gives this container elevated permissions on the host container instance.
         *                   The level of permissions are similar to the root user permissions.
         *                   <p>
         *                   This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
         *                   <p>
         *                   <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getReadonlyRootFilesystem}
         * @param readonlyRootFilesystem If specified, gives this container readonly access to its root file system.
         *                               This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
         *                               <p>
         *                               <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getRunAsGroup}
         * @param runAsGroup If specified, the container is run as the specified group ID (<code>gid</code>).
         *                   If this parameter isn't specified, the default is the group that's specified in the image metadata.
         *                   This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         *                   <p>
         *                   <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsGroup(java.lang.Number runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getRunAsRoot}
         * @param runAsRoot If specified, the container is run as a user with a <code>uid</code> other than 0.
         *                  Otherwise, no such rule is enforced.
         *                  This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         *                  <p>
         *                  <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsRoot(java.lang.Boolean runAsRoot) {
            this.runAsRoot = runAsRoot;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getRunAsUser}
         * @param runAsUser If specified, this container is run as the specified user ID (<code>uid</code>).
         *                  This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         *                  <p>
         *                  <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsUser(java.lang.Number runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        /**
         * Sets the value of {@link EksContainerDefinitionProps#getVolumes}
         * @param volumes The Volumes to mount to this container.
         *                Automatically added to the Pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.batch.EksVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EksVolume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EksContainerDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EksContainerDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EksContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerDefinitionProps {
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> args;
        private final java.util.List<java.lang.String> command;
        private final java.lang.Number cpuLimit;
        private final java.lang.Number cpuReservation;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.lang.Number gpuLimit;
        private final java.lang.Number gpuReservation;
        private final software.amazon.awscdk.services.batch.ImagePullPolicy imagePullPolicy;
        private final software.amazon.awscdk.Size memoryLimit;
        private final software.amazon.awscdk.Size memoryReservation;
        private final java.lang.String name;
        private final java.lang.Boolean privileged;
        private final java.lang.Boolean readonlyRootFilesystem;
        private final java.lang.Number runAsGroup;
        private final java.lang.Boolean runAsRoot;
        private final java.lang.Number runAsUser;
        private final java.util.List<software.amazon.awscdk.services.batch.EksVolume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cpuLimit = software.amazon.jsii.Kernel.get(this, "cpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.cpuReservation = software.amazon.jsii.Kernel.get(this, "cpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuLimit = software.amazon.jsii.Kernel.get(this, "gpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.gpuReservation = software.amazon.jsii.Kernel.get(this, "gpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.imagePullPolicy = software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ImagePullPolicy.class));
            this.memoryLimit = software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.memoryReservation = software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.runAsGroup = software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.runAsRoot = software.amazon.jsii.Kernel.get(this, "runAsRoot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.runAsUser = software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksVolume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.args = builder.args;
            this.command = builder.command;
            this.cpuLimit = builder.cpuLimit;
            this.cpuReservation = builder.cpuReservation;
            this.env = builder.env;
            this.gpuLimit = builder.gpuLimit;
            this.gpuReservation = builder.gpuReservation;
            this.imagePullPolicy = builder.imagePullPolicy;
            this.memoryLimit = builder.memoryLimit;
            this.memoryReservation = builder.memoryReservation;
            this.name = builder.name;
            this.privileged = builder.privileged;
            this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
            this.runAsGroup = builder.runAsGroup;
            this.runAsRoot = builder.runAsRoot;
            this.runAsUser = builder.runAsUser;
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EksVolume>)builder.volumes;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.Number getCpuLimit() {
            return this.cpuLimit;
        }

        @Override
        public final java.lang.Number getCpuReservation() {
            return this.cpuReservation;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.Number getGpuLimit() {
            return this.gpuLimit;
        }

        @Override
        public final java.lang.Number getGpuReservation() {
            return this.gpuReservation;
        }

        @Override
        public final software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
            return this.imagePullPolicy;
        }

        @Override
        public final software.amazon.awscdk.Size getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public final software.amazon.awscdk.Size getMemoryReservation() {
            return this.memoryReservation;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final java.lang.Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final java.lang.Number getRunAsGroup() {
            return this.runAsGroup;
        }

        @Override
        public final java.lang.Boolean getRunAsRoot() {
            return this.runAsRoot;
        }

        @Override
        public final java.lang.Number getRunAsUser() {
            return this.runAsUser;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getCpuLimit() != null) {
                data.set("cpuLimit", om.valueToTree(this.getCpuLimit()));
            }
            if (this.getCpuReservation() != null) {
                data.set("cpuReservation", om.valueToTree(this.getCpuReservation()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getGpuLimit() != null) {
                data.set("gpuLimit", om.valueToTree(this.getGpuLimit()));
            }
            if (this.getGpuReservation() != null) {
                data.set("gpuReservation", om.valueToTree(this.getGpuReservation()));
            }
            if (this.getImagePullPolicy() != null) {
                data.set("imagePullPolicy", om.valueToTree(this.getImagePullPolicy()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getMemoryReservation() != null) {
                data.set("memoryReservation", om.valueToTree(this.getMemoryReservation()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getReadonlyRootFilesystem() != null) {
                data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
            }
            if (this.getRunAsGroup() != null) {
                data.set("runAsGroup", om.valueToTree(this.getRunAsGroup()));
            }
            if (this.getRunAsRoot() != null) {
                data.set("runAsRoot", om.valueToTree(this.getRunAsRoot()));
            }
            if (this.getRunAsUser() != null) {
                data.set("runAsUser", om.valueToTree(this.getRunAsUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EksContainerDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EksContainerDefinitionProps.Jsii$Proxy that = (EksContainerDefinitionProps.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.cpuLimit != null ? !this.cpuLimit.equals(that.cpuLimit) : that.cpuLimit != null) return false;
            if (this.cpuReservation != null ? !this.cpuReservation.equals(that.cpuReservation) : that.cpuReservation != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.gpuLimit != null ? !this.gpuLimit.equals(that.gpuLimit) : that.gpuLimit != null) return false;
            if (this.gpuReservation != null ? !this.gpuReservation.equals(that.gpuReservation) : that.gpuReservation != null) return false;
            if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            if (this.memoryReservation != null ? !this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
            if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) return false;
            if (this.runAsRoot != null ? !this.runAsRoot.equals(that.runAsRoot) : that.runAsRoot != null) return false;
            if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.cpuLimit != null ? this.cpuLimit.hashCode() : 0);
            result = 31 * result + (this.cpuReservation != null ? this.cpuReservation.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.gpuLimit != null ? this.gpuLimit.hashCode() : 0);
            result = 31 * result + (this.gpuReservation != null ? this.gpuReservation.hashCode() : 0);
            result = 31 * result + (this.imagePullPolicy != null ? this.imagePullPolicy.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.memoryReservation != null ? this.memoryReservation.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
            result = 31 * result + (this.runAsGroup != null ? this.runAsGroup.hashCode() : 0);
            result = 31 * result + (this.runAsRoot != null ? this.runAsRoot.hashCode() : 0);
            result = 31 * result + (this.runAsUser != null ? this.runAsUser.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
