package software.amazon.awscdk.services.cloudfront;

/**
 * Attributes of an existing CloudFront Function to import it.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * FunctionAttributes functionAttributes = FunctionAttributes.builder()
 *         .functionArn("functionArn")
 *         .functionName("functionName")
 *         // the properties below are optional
 *         .functionRuntime("functionRuntime")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.306Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionAttributes")
@software.amazon.jsii.Jsii.Proxy(FunctionAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

    /**
     * The name of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * The Runtime of the function.
     * <p>
     * Default: FunctionRuntime.JS_1_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionAttributes> {
        java.lang.String functionArn;
        java.lang.String functionName;
        java.lang.String functionRuntime;

        /**
         * Sets the value of {@link FunctionAttributes#getFunctionArn}
         * @param functionArn The ARN of the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionArn(java.lang.String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        /**
         * Sets the value of {@link FunctionAttributes#getFunctionName}
         * @param functionName The name of the function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link FunctionAttributes#getFunctionRuntime}
         * @param functionRuntime The Runtime of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionRuntime(java.lang.String functionRuntime) {
            this.functionRuntime = functionRuntime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionAttributes {
        private final java.lang.String functionArn;
        private final java.lang.String functionName;
        private final java.lang.String functionRuntime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionRuntime = software.amazon.jsii.Kernel.get(this, "functionRuntime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.functionRuntime = builder.functionRuntime;
        }

        @Override
        public final java.lang.String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getFunctionRuntime() {
            return this.functionRuntime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionArn", om.valueToTree(this.getFunctionArn()));
            data.set("functionName", om.valueToTree(this.getFunctionName()));
            if (this.getFunctionRuntime() != null) {
                data.set("functionRuntime", om.valueToTree(this.getFunctionRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.FunctionAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionAttributes.Jsii$Proxy that = (FunctionAttributes.Jsii$Proxy) o;

            if (!functionArn.equals(that.functionArn)) return false;
            if (!functionName.equals(that.functionName)) return false;
            return this.functionRuntime != null ? this.functionRuntime.equals(that.functionRuntime) : that.functionRuntime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionArn.hashCode();
            result = 31 * result + (this.functionName.hashCode());
            result = 31 * result + (this.functionRuntime != null ? this.functionRuntime.hashCode() : 0);
            return result;
        }
    }
}
