package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running Windows.
 * <p>
 * This class has a bunch of public constants that represent the most popular images.
 * <p>
 * You can also specify a custom image using one of the static methods:
 * <p>
 * <ul>
 * <li>WindowsBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }, imageType])</li>
 * <li>WindowsBuildImage.fromEcrRepository(repo[, tag, imageType])</li>
 * <li>WindowsBuildImage.fromAsset(parent, id, props, [, imageType])</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository ecrRepository;
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", WindowsImageType.SERVER_2019))
 *                 // optional certificate to include in the build image
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(Bucket.fromBucketName(this, "Bucket", "my-bucket"))
 *                         .objectKey("path/to/cert.pem")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.675Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.WindowsBuildImage")
public class WindowsBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected WindowsBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WindowsBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        WIN_SERVER_CORE_2019_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WIN_SERVER_CORE_2019_BASE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        WIN_SERVER_CORE_2019_BASE_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WIN_SERVER_CORE_2019_BASE_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        WINDOWS_BASE_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WINDOWS_BASE_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
    }

    /**
     * Uses an Docker image asset as a Windows build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), imageType });
    }

    /**
     * Uses an Docker image asset as a Windows build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options, imageType });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @return A Windows build image from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     * @param tagOrDigest Image tag or digest (default "latest", digests must start with <code>sha256:</code>).
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest, imageType });
    }

    /**
     * @return A Windows build image from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     * @param tagOrDigest Image tag or digest (default "latest", digests must start with <code>sha256:</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest });
    }

    /**
     * @return A Windows build image from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param buildEnvironment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
    }

    /**
     * The standard CodeBuild image <code>aws/codebuild/windows-base:2019-1.0</code>, which is based off Windows Server Core 2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WIN_SERVER_CORE_2019_BASE;

    /**
     * The standard CodeBuild image <code>aws/codebuild/windows-base:2019-2.0</code>, which is based off Windows Server Core 2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WIN_SERVER_CORE_2019_BASE_2_0;

    /**
     * (deprecated) The standard CodeBuild image <code>aws/codebuild/windows-base:2.0</code>, which is based off Windows Server Core 2016.
     * <p>
     * @deprecated <code>WindowsBuildImage.WIN_SERVER_CORE_2019_BASE_2_0</code> should be used instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WINDOWS_BASE_2_0;

    /**
     * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
    }

    /**
     * An optional ECR repository that the image is hosted in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }
}
