package software.amazon.awscdk.services.codedeploy;

/**
 * Represents the configuration specific to canary traffic shifting.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * CanaryTrafficRoutingConfig canaryTrafficRoutingConfig = CanaryTrafficRoutingConfig.builder()
 *         .canaryInterval(123)
 *         .canaryPercentage(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.713Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.CanaryTrafficRoutingConfig")
@software.amazon.jsii.Jsii.Proxy(CanaryTrafficRoutingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CanaryTrafficRoutingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getCanaryInterval();

    /**
     * The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getCanaryPercentage();

    /**
     * @return a {@link Builder} of {@link CanaryTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CanaryTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CanaryTrafficRoutingConfig> {
        java.lang.Number canaryInterval;
        java.lang.Number canaryPercentage;

        /**
         * Sets the value of {@link CanaryTrafficRoutingConfig#getCanaryInterval}
         * @param canaryInterval The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canaryInterval(java.lang.Number canaryInterval) {
            this.canaryInterval = canaryInterval;
            return this;
        }

        /**
         * Sets the value of {@link CanaryTrafficRoutingConfig#getCanaryPercentage}
         * @param canaryPercentage The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canaryPercentage(java.lang.Number canaryPercentage) {
            this.canaryPercentage = canaryPercentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CanaryTrafficRoutingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CanaryTrafficRoutingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CanaryTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanaryTrafficRoutingConfig {
        private final java.lang.Number canaryInterval;
        private final java.lang.Number canaryPercentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.canaryInterval = software.amazon.jsii.Kernel.get(this, "canaryInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.canaryPercentage = software.amazon.jsii.Kernel.get(this, "canaryPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.canaryInterval = java.util.Objects.requireNonNull(builder.canaryInterval, "canaryInterval is required");
            this.canaryPercentage = java.util.Objects.requireNonNull(builder.canaryPercentage, "canaryPercentage is required");
        }

        @Override
        public final java.lang.Number getCanaryInterval() {
            return this.canaryInterval;
        }

        @Override
        public final java.lang.Number getCanaryPercentage() {
            return this.canaryPercentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("canaryInterval", om.valueToTree(this.getCanaryInterval()));
            data.set("canaryPercentage", om.valueToTree(this.getCanaryPercentage()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.CanaryTrafficRoutingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CanaryTrafficRoutingConfig.Jsii$Proxy that = (CanaryTrafficRoutingConfig.Jsii$Proxy) o;

            if (!canaryInterval.equals(that.canaryInterval)) return false;
            return this.canaryPercentage.equals(that.canaryPercentage);
        }

        @Override
        public final int hashCode() {
            int result = this.canaryInterval.hashCode();
            result = 31 * result + (this.canaryPercentage.hashCode());
            return result;
        }
    }
}
