package software.amazon.awscdk.services.codepipeline;

/**
 * The resource representing registering a custom Action with CodePipeline.
 * <p>
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the <code>actionProperties</code> as properly typed, construction properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Make a custom CodePipeline Action
 * // Make a custom CodePipeline Action
 * CustomActionRegistration.Builder.create(this, "GenericGitSourceProviderResource")
 *         .category(ActionCategory.SOURCE)
 *         .artifactBounds(ActionArtifactBounds.builder().minInputs(0).maxInputs(0).minOutputs(1).maxOutputs(1).build())
 *         .provider("GenericGitSource")
 *         .version("1")
 *         .entityUrl("https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html")
 *         .executionUrl("https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html")
 *         .actionProperties(List.of(CustomActionProperty.builder()
 *                 .name("Branch")
 *                 .required(true)
 *                 .key(false)
 *                 .secret(false)
 *                 .queryable(false)
 *                 .description("Git branch to pull")
 *                 .type("String")
 *                 .build(), CustomActionProperty.builder()
 *                 .name("GitUrl")
 *                 .required(true)
 *                 .key(false)
 *                 .secret(false)
 *                 .queryable(false)
 *                 .description("SSH git clone URL")
 *                 .type("String")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.841Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CustomActionRegistration")
public class CustomActionRegistration extends software.constructs.Construct {

    protected CustomActionRegistration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomActionRegistration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomActionRegistration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CustomActionRegistrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CustomActionRegistration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CustomActionRegistration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CustomActionRegistrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CustomActionRegistrationProps.Builder();
        }

        /**
         * The artifact bounds of the Action.
         * <p>
         * @return {@code this}
         * @param artifactBounds The artifact bounds of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBounds(final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds) {
            this.props.artifactBounds(artifactBounds);
            return this;
        }

        /**
         * The category of the Action.
         * <p>
         * @return {@code this}
         * @param category The category of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(final software.amazon.awscdk.services.codepipeline.ActionCategory category) {
            this.props.category(category);
            return this;
        }

        /**
         * The provider of the Action.
         * <p>
         * For example, <code>'MyCustomActionProvider'</code>
         * <p>
         * @return {@code this}
         * @param provider The provider of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(final java.lang.String provider) {
            this.props.provider(provider);
            return this;
        }

        /**
         * The properties used for customizing the instance of your Action.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param actionProperties The properties used for customizing the instance of your Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionProperties(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.CustomActionProperty> actionProperties) {
            this.props.actionProperties(actionProperties);
            return this;
        }

        /**
         * The URL shown for the entire Action in the Pipeline UI.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param entityUrl The URL shown for the entire Action in the Pipeline UI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityUrl(final java.lang.String entityUrl) {
            this.props.entityUrl(entityUrl);
            return this;
        }

        /**
         * The URL shown for a particular execution of an Action in the Pipeline UI.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param executionUrl The URL shown for a particular execution of an Action in the Pipeline UI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionUrl(final java.lang.String executionUrl) {
            this.props.executionUrl(executionUrl);
            return this;
        }

        /**
         * The version of your Action.
         * <p>
         * Default: '1'
         * <p>
         * @return {@code this}
         * @param version The version of your Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CustomActionRegistration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CustomActionRegistration build() {
            return new software.amazon.awscdk.services.codepipeline.CustomActionRegistration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
