package software.amazon.awscdk.services.config;

/**
 * Managed rules that are supported by AWS Config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * ManagedRule.Builder.create(this, "AccessKeysRotated")
 *         .identifier(ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED)
 *         .inputParameters(Map.of(
 *                 "maxAccessKeyAge", 60))
 *         // default is 24 hours
 *         .maximumExecutionFrequency(MaximumExecutionFrequency.TWELVE_HOURS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:30.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.ManagedRuleIdentifiers")
public class ManagedRuleIdentifiers extends software.amazon.jsii.JsiiObject {

    protected ManagedRuleIdentifiers(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedRuleIdentifiers(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACCESS_KEYS_ROTATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACCESS_KEYS_ROTATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ACCOUNT_PART_OF_ORGANIZATIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACCOUNT_PART_OF_ORGANIZATIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ACM_CERTIFICATE_EXPIRATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACM_CERTIFICATE_EXPIRATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_DESYNC_MODE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_DESYNC_MODE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_HTTP_DROP_INVALID_HEADER_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_HTTP_DROP_INVALID_HEADER_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_WAF_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_WAF_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_ASSOCIATED_WITH_WAF = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_ASSOCIATED_WITH_WAF", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_CACHE_ENABLED_AND_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_CACHE_ENABLED_AND_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_ENDPOINT_TYPE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_ENDPOINT_TYPE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_EXECUTION_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_EXECUTION_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_SSL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_SSL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_XRAY_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_XRAY_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GWV2_ACCESS_LOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GWV2_ACCESS_LOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GWV2_AUTHORIZATION_TYPE_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GWV2_AUTHORIZATION_TYPE_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        APPROVED_AMIS_BY_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "APPROVED_AMIS_BY_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        APPROVED_AMIS_BY_TAG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "APPROVED_AMIS_BY_TAG", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AURORA_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AURORA_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AURORA_MYSQL_BACKTRACKING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AURORA_MYSQL_BACKTRACKING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AURORA_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AURORA_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_CAPACITY_REBALANCING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_CAPACITY_REBALANCING", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_LAUNCH_CONFIG_HOP_LIMIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_LAUNCH_CONFIG_HOP_LIMIT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_LAUNCH_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_LAUNCH_TEMPLATE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_LAUNCHCONFIG_REQUIRES_IMDSV2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_LAUNCHCONFIG_REQUIRES_IMDSV2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_MULTIPLE_AZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_MULTIPLE_AZ", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_MULTIPLE_INSTANCE_TYPES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_MULTIPLE_INSTANCE_TYPES", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BACKUP_RECOVERY_POINT_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "BACKUP_RECOVERY_POINT_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BEANSTALK_ENHANCED_HEALTH_REPORTING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "BEANSTALK_ENHANCED_HEALTH_REPORTING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLB_DESYNC_MODE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLB_DESYNC_MODE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLB_MULTIPLE_AZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLB_MULTIPLE_AZ", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFORMATION_STACK_NOTIFICATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFORMATION_STACK_NOTIFICATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ACCESSLOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ACCESSLOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ASSOCIATED_WITH_WAF = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ASSOCIATED_WITH_WAF", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_CUSTOM_SSL_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_CUSTOM_SSL_CERTIFICATE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_NO_DEPRECATED_SSL_PROTOCOLS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_NO_DEPRECATED_SSL_PROTOCOLS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ORIGIN_FAILOVER_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ORIGIN_FAILOVER_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_SECURITY_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_SECURITY_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_SNI_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_SNI_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_TRAFFIC_TO_ORIGIN_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_TRAFFIC_TO_ORIGIN_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_VIEWER_POLICY_HTTPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_VIEWER_POLICY_HTTPS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_MULTI_REGION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_MULTI_REGION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_S3_DATAEVENTS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_S3_DATAEVENTS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_SECURITY_TRAIL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_SECURITY_TRAIL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_ACTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_ACTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_ACTION_ENABLED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_ACTION_ENABLED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_RESOURCE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_RESOURCE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_LOG_GROUP_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_LOG_GROUP_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CMK_BACKING_KEY_ROTATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CMK_BACKING_KEY_ROTATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_ARTIFACT_ENCRYPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_ARTIFACT_ENCRYPTION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_ENVIRONMENT_PRIVILEGED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_ENVIRONMENT_PRIVILEGED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_S3_LOGS_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_S3_LOGS_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEDEPLOY_AUTO_ROLLBACK_MONITOR_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEDEPLOY_AUTO_ROLLBACK_MONITOR_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEDEPLOY_EC2_MINIMUM_HEALTHY_HOSTS_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEDEPLOY_EC2_MINIMUM_HEALTHY_HOSTS_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEDEPLOY_LAMBDA_ALLATONCE_TRAFFIC_SHIFT_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEDEPLOY_LAMBDA_ALLATONCE_TRAFFIC_SHIFT_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEPIPELINE_DEPLOYMENT_COUNT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEPIPELINE_DEPLOYMENT_COUNT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEPIPELINE_REGION_FANOUT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEPIPELINE_REGION_FANOUT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CW_LOGGROUP_RETENTION_PERIOD_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CW_LOGGROUP_RETENTION_PERIOD_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DAX_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DAX_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DMS_REPLICATION_NOT_PUBLIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DMS_REPLICATION_NOT_PUBLIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_AUTOSCALING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_AUTOSCALING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_PITR_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_PITR_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_TABLE_ENCRYPTED_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_TABLE_ENCRYPTED_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_TABLE_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_TABLE_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_THROUGHPUT_LIMIT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_THROUGHPUT_LIMIT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_ENCRYPTED_VOLUMES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_ENCRYPTED_VOLUMES", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_OPTIMIZED_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_OPTIMIZED_INSTANCE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_DESIRED_INSTANCE_TENANCY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_DESIRED_INSTANCE_TENANCY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_DESIRED_INSTANCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_DESIRED_INSTANCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_EBS_ENCRYPTION_BY_DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_EBS_ENCRYPTION_BY_DEFAULT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_IMDSV2_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_IMDSV2_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_DETAILED_MONITORING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_DETAILED_MONITORING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_MANAGED_BY_SSM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_MANAGED_BY_SSM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_MULTIPLE_ENI_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_MULTIPLE_ENI_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_NO_PUBLIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_NO_PUBLIC_IP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_PROFILE_ATTACHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_PROFILE_ATTACHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCES_IN_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCES_IN_VPC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_PLATFORM_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_PLATFORM_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_NO_AMAZON_KEY_PAIR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_NO_AMAZON_KEY_PAIR", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_PARAVIRTUAL_INSTANCE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_PARAVIRTUAL_INSTANCE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUP_ATTACHED_TO_ENI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUP_ATTACHED_TO_ENI", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUP_ATTACHED_TO_ENI_PERIODIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUP_ATTACHED_TO_ENI_PERIODIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_STOPPED_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_STOPPED_INSTANCE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_TOKEN_HOP_LIMIT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_TOKEN_HOP_LIMIT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_TRANSIT_GATEWAY_AUTO_VPC_ATTACH_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_TRANSIT_GATEWAY_AUTO_VPC_ATTACH_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_VOLUME_IECS_TASK_DEFINITION_USER_FOR_HOST_MODE_CHECKNUSE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_VOLUME_IECS_TASK_DEFINITION_USER_FOR_HOST_MODE_CHECKNUSE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_VOLUME_INUSE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_VOLUME_INUSE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECR_PRIVATE_IMAGE_SCANNING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECR_PRIVATE_IMAGE_SCANNING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECR_PRIVATE_LIFECYCLE_POLICY_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECR_PRIVATE_LIFECYCLE_POLICY_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECR_PRIVATE_TAG_IMMUTABILITY_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECR_PRIVATE_TAG_IMMUTABILITY_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_AWSVPC_NETWORKING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_AWSVPC_NETWORKING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_CONTAINER_INSIGHTS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_CONTAINER_INSIGHTS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_CONTAINERS_NONPRIVILEGED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_CONTAINERS_NONPRIVILEGED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_CONTAINERS_READONLY_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_CONTAINERS_READONLY_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_FARGATE_LATEST_PLATFORM_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_FARGATE_LATEST_PLATFORM_VERSION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_NO_ENVIRONMENT_SECRETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_NO_ENVIRONMENT_SECRETS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_TASK_DEFINITION_LOG_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_TASK_DEFINITION_LOG_CONFIGURATION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_TASK_DEFINITION_MEMORY_HARD_LIMIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_TASK_DEFINITION_MEMORY_HARD_LIMIT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_TASK_DEFINITION_NONROOT_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_TASK_DEFINITION_NONROOT_USER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ECS_TASK_DEFINITION_PID_MODE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ECS_TASK_DEFINITION_PID_MODE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_ACCESS_POINT_ENFORCE_ROOT_DIRECTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_ACCESS_POINT_ENFORCE_ROOT_DIRECTORY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_ACCESS_POINT_ENFORCE_USER_IDENTITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_ACCESS_POINT_ENFORCE_USER_IDENTITY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_ENCRYPTED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_ENCRYPTED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EIP_ATTACHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EIP_ATTACHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_CLUSTER_OLDEST_SUPPORTED_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_CLUSTER_OLDEST_SUPPORTED_VERSION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_CLUSTER_SUPPORTED_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_CLUSTER_SUPPORTED_VERSION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_ENDPOINT_NO_PUBLIC_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_ENDPOINT_NO_PUBLIC_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_SECRETS_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_SECRETS_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTIC_BEANSTALK_MANAGED_UPDATES_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTIC_BEANSTALK_MANAGED_UPDATES_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_ENCRYPTED_AT_REST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_ENCRYPTED_AT_REST", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_IN_VPC_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_IN_VPC_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_ACM_CERTIFICATE_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_ACM_CERTIFICATE_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_TLS_HTTPS_LISTENERS_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_TLS_HTTPS_LISTENERS_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELBV2_ACM_CERTIFICATE_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELBV2_ACM_CERTIFICATE_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELBV2_MULTIPLE_AZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELBV2_MULTIPLE_AZ", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EMR_KERBEROS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EMR_KERBEROS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EMR_MASTER_NO_PUBLIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EMR_MASTER_NO_PUBLIC_IP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_CONTENT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_CONTENT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SHIELD_RESOURCE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SHIELD_RESOURCE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_WEBACL_RESOURCE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_WEBACL_RESOURCE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FSX_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FSX_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FSX_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FSX_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        GUARDDUTY_ENABLED_CENTRALIZED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "GUARDDUTY_ENABLED_CENTRALIZED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        GUARDDUTY_NON_ARCHIVED_FINDINGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "GUARDDUTY_NON_ARCHIVED_FINDINGS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_GROUP_HAS_USERS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_GROUP_HAS_USERS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_NO_INLINE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_NO_INLINE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_PASSWORD_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_PASSWORD_POLICY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_BLOCKED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_BLOCKED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_IN_USE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_IN_USE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_NO_STATEMENTS_WITH_FULL_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_NO_STATEMENTS_WITH_FULL_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_ROLE_MANAGED_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_ROLE_MANAGED_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_ROOT_ACCESS_KEY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_ROOT_ACCESS_KEY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_GROUP_MEMBERSHIP_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_GROUP_MEMBERSHIP_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_NO_POLICIES_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_NO_POLICIES_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_UNUSED_CREDENTIALS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_UNUSED_CREDENTIALS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        KINESIS_STREAM_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "KINESIS_STREAM_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        KMS_CMK_NOT_SCHEDULED_FOR_DELETION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "KMS_CMK_NOT_SCHEDULED_FOR_DELETION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_CONCURRENCY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_CONCURRENCY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_DLQ_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_DLQ_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_FUNCTION_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_FUNCTION_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_INSIDE_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_INSIDE_VPC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_VPC_MULTI_AZ_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_VPC_MULTI_AZ_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NACL_NO_UNRESTRICTED_SSH_RDP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NACL_NO_UNRESTRICTED_SSH_RDP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NETFW_POLICY_DEFAULT_ACTION_FRAGMENT_PACKETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NETFW_POLICY_DEFAULT_ACTION_FRAGMENT_PACKETS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NETFW_POLICY_DEFAULT_ACTION_FULL_PACKETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NETFW_POLICY_DEFAULT_ACTION_FULL_PACKETS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NETFW_POLICY_RULE_GROUP_ASSOCIATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NETFW_POLICY_RULE_GROUP_ASSOCIATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NETFW_STATELESS_RULE_GROUP_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NETFW_STATELESS_RULE_GROUP_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NLB_CROSS_ZONE_LOAD_BALANCING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "NLB_CROSS_ZONE_LOAD_BALANCING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_ACCESS_CONTROL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_ACCESS_CONTROL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_AUDIT_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_AUDIT_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_DATA_NODE_FAULT_TOLERANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_DATA_NODE_FAULT_TOLERANCE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_ENCRYPTED_AT_REST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_ENCRYPTED_AT_REST", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_HTTPS_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_HTTPS_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_IN_VPC_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_IN_VPC_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_LOGS_TO_CLOUDWATCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_LOGS_TO_CLOUDWATCH", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        OPENSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "OPENSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_AUTOMATIC_MINOR_VERSION_UPGRADE_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_AUTOMATIC_MINOR_VERSION_UPGRADE_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_CLUSTER_DEFAULT_ADMIN_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_CLUSTER_DEFAULT_ADMIN_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_CLUSTER_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_CLUSTER_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_CLUSTER_IAM_AUTHENTICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_CLUSTER_IAM_AUTHENTICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_CLUSTER_MULTI_AZ_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_CLUSTER_MULTI_AZ_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_DB_INSTANCE_BACKUP_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_DB_INSTANCE_BACKUP_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_DB_SECURITY_GROUP_NOT_ALLOWED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_DB_SECURITY_GROUP_NOT_ALLOWED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_ENHANCED_MONITORING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_ENHANCED_MONITORING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_DEFAULT_ADMIN_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_DEFAULT_ADMIN_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_PUBLIC_ACCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_PUBLIC_ACCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_MULTI_AZ_SUPPORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_MULTI_AZ_SUPPORT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_SNAPSHOT_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_SNAPSHOT_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_SNAPSHOTS_PUBLIC_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_SNAPSHOTS_PUBLIC_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_STORAGE_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_STORAGE_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_AUDIT_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_AUDIT_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_BACKUP_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_BACKUP_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_CONFIGURATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_CONFIGURATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_KMS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_KMS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_DEFAULT_ADMIN_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_DEFAULT_ADMIN_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_DEFAULT_DB_NAME_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_DEFAULT_DB_NAME_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_ENHANCED_VPC_ROUTING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_ENHANCED_VPC_ROUTING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_REQUIRE_TLS_SSL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_REQUIRE_TLS_SSL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TAGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REQUIRED_TAGS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ROOT_ACCOUNT_HARDWARE_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ROOT_ACCOUNT_HARDWARE_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ROOT_ACCOUNT_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ROOT_ACCOUNT_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS_PERIODIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS_PERIODIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_ACL_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_ACL_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_DEFAULT_LOCK_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_DEFAULT_LOCK_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_POLICY_GRANTEE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_POLICY_GRANTEE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_PUBLIC_READ_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_PUBLIC_READ_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_PUBLIC_WRITE_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_PUBLIC_WRITE_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_REPLICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_REPLICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_SSL_REQUESTS_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_SSL_REQUESTS_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_VERSIONING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_VERSIONING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_DEFAULT_ENCRYPTION_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_DEFAULT_ENCRYPTION_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_EVENT_NOTIFICATIONS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_EVENT_NOTIFICATIONS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_LIFECYCLE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_LIFECYCLE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_VERSION_LIFECYCLE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_VERSION_LIFECYCLE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_ROTATION_ENABLED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_ROTATION_ENABLED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_SECRET_PERIODIC_ROTATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_SECRET_PERIODIC_ROTATION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_SECRET_UNUSED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_SECRET_UNUSED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_USING_CMK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_USING_CMK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECURITYHUB_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECURITYHUB_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SERVICE_VPC_ENDPOINT_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SERVICE_VPC_ENDPOINT_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SHIELD_ADVANCED_ENABLED_AUTO_RENEW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SHIELD_ADVANCED_ENABLED_AUTO_RENEW", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SHIELD_DRT_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SHIELD_DRT_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SNS_ENCRYPTED_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SNS_ENCRYPTED_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SNS_TOPIC_MESSAGE_DELIVERY_NOTIFICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SNS_TOPIC_MESSAGE_DELIVERY_NOTIFICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SSM_DOCUMENT_NOT_PUBLIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SSM_DOCUMENT_NOT_PUBLIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        STORAGEGATEWAY_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "STORAGEGATEWAY_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SUBNET_AUTO_ASSIGN_PUBLIC_IP_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SUBNET_AUTO_ASSIGN_PUBLIC_IP_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VIRTUALMACHINE_LAST_BACKUP_RECOVERY_POINT_CREATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VIRTUALMACHINE_LAST_BACKUP_RECOVERY_POINT_CREATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VIRTUALMACHINE_RESOURCES_PROTECTED_BY_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VIRTUALMACHINE_RESOURCES_PROTECTED_BY_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_DEFAULT_SECURITY_GROUP_CLOSED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_DEFAULT_SECURITY_GROUP_CLOSED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_FLOW_LOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_FLOW_LOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_NETWORK_ACL_UNUSED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_NETWORK_ACL_UNUSED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_PEERING_DNS_RESOLUTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_PEERING_DNS_RESOLUTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_VPN_2_TUNNELS_UP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_VPN_2_TUNNELS_UP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_CLASSIC_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_CLASSIC_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_GLOBAL_RULE_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_GLOBAL_RULE_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_GLOBAL_RULEGROUP_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_GLOBAL_RULEGROUP_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_GLOBAL_WEBACL_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_GLOBAL_WEBACL_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_REGIONAL_RULE_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_REGIONAL_RULE_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_REGIONAL_RULEGROUP_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_REGIONAL_RULEGROUP_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_REGIONAL_WEBACL_NOT_EMPTY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_REGIONAL_WEBACL_NOT_EMPTY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAFV2_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAFV2_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Checks whether the active access keys are rotated within the number of days specified in maxAccessKeyAge.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html">https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ACCESS_KEYS_ROTATED;

    /**
     * Checks whether AWS account is part of AWS Organizations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html">https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ACCOUNT_PART_OF_ORGANIZATIONS;

    /**
     * Checks whether ACM Certificates in your account are marked for expiration within the specified number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html">https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ACM_CERTIFICATE_EXPIRATION_CHECK;

    /**
     * Checks if an Application Load Balancer (ALB) is configured with a user defined desync mitigation mode.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-desync-mode-check.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-desync-mode-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALB_DESYNC_MODE_CHECK;

    /**
     * Checks if rule evaluates Application Load Balancers (ALBs) to ensure they are configured to drop http headers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALB_HTTP_DROP_INVALID_HEADER_ENABLED;

    /**
     * Checks whether HTTP to HTTPS redirection is configured on all HTTP listeners of Application Load Balancer.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK;

    /**
     * Checks if Web Application Firewall (WAF) is enabled on Application Load Balancers (ALBs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALB_WAF_ENABLED;

    /**
     * Checks if an Amazon API Gateway API stage is using an AWS WAF Web ACL.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-associated-with-waf.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-associated-with-waf.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_ASSOCIATED_WITH_WAF;

    /**
     * Checks that all methods in Amazon API Gateway stages have caching enabled and encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_CACHE_ENABLED_AND_ENCRYPTED;

    /**
     * Checks that Amazon API Gateway APIs are of the type specified in the rule parameter endpointConfigurationType.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_ENDPOINT_TYPE_CHECK;

    /**
     * Checks that all methods in Amazon API Gateway stage has logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_EXECUTION_LOGGING_ENABLED;

    /**
     * Checks if a REST API stage uses an Secure Sockets Layer (SSL) certificate.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-ssl-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-ssl-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_SSL_ENABLED;

    /**
     * Checks if AWS X-Ray tracing is enabled on Amazon API Gateway REST APIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-xray-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-xray-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GW_XRAY_ENABLED;

    /**
     * Checks if Amazon API Gateway V2 stages have access logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gwv2-access-logs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gwv2-access-logs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GWV2_ACCESS_LOGS_ENABLED;

    /**
     * Checks if Amazon API Gatewayv2 API routes have an authorization type set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gwv2-authorization-type-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gwv2-authorization-type-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String API_GWV2_AUTHORIZATION_TYPE_CONFIGURED;

    /**
     * Checks whether running instances are using specified AMIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html">https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String APPROVED_AMIS_BY_ID;

    /**
     * Checks whether running instances are using specified AMIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html">https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String APPROVED_AMIS_BY_TAG;

    /**
     * Checks if a recovery point was created for Amazon Aurora DB clusters.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/aurora-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/aurora-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AURORA_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks if an Amazon Aurora MySQL cluster has backtracking enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/aurora-mysql-backtracking-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/aurora-mysql-backtracking-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AURORA_MYSQL_BACKTRACKING_ENABLED;

    /**
     * Checks if Amazon Aurora DB clusters are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/aurora-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/aurora-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AURORA_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks if Capacity Rebalancing is enabled for Amazon EC2 Auto Scaling groups that use multiple instance types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-capacity-rebalancing.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-capacity-rebalancing.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_CAPACITY_REBALANCING;

    /**
     * Checks whether your Auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED;

    /**
     * Checks the number of network hops that the metadata token can travel.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-config-hop-limit.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-config-hop-limit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_LAUNCH_CONFIG_HOP_LIMIT;

    /**
     * Checks if Amazon EC2 Auto Scaling groups have public IP addresses enabled through Launch Configurations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-config-public-ip-disabled.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-config-public-ip-disabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED;

    /**
     * Checks if an Amazon Elastic Compute Cloud (EC2) Auto Scaling group is created from an EC2 launch template.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-template.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launch-template.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_LAUNCH_TEMPLATE;

    /**
     * Checks whether only IMDSv2 is enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launchconfig-requires-imdsv2.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-launchconfig-requires-imdsv2.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_LAUNCHCONFIG_REQUIRES_IMDSV2;

    /**
     * Checks if the Auto Scaling group spans multiple Availability Zones.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-multiple-az.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-multiple-az.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_MULTIPLE_AZ;

    /**
     * Checks if an Amazon Elastic Compute Cloud (Amazon EC2) Auto Scaling group uses multiple instance types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-multiple-instance-types.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-multiple-instance-types.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AUTOSCALING_MULTIPLE_INSTANCE_TYPES;

    /**
     * Checks if a backup plan has a backup rule that satisfies the required frequency and retention period.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/backup-plan-min-frequency-and-min-retention-check.html">https://docs.aws.amazon.com/config/latest/developerguide/backup-plan-min-frequency-and-min-retention-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK;

    /**
     * Checks if a recovery point is encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BACKUP_RECOVERY_POINT_ENCRYPTED;

    /**
     * Checks if a backup vault has an attached resource-based policy which prevents deletion of recovery points.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-manual-deletion-disabled.html">https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-manual-deletion-disabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED;

    /**
     * Checks if a recovery point expires no earlier than after the specified period.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-minimum-retention-check.html">https://docs.aws.amazon.com/config/latest/developerguide/backup-recovery-point-minimum-retention-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK;

    /**
     * Checks if an AWS Elastic Beanstalk environment is configured for enhanced health reporting.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/beanstalk-enhanced-health-reporting-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/beanstalk-enhanced-health-reporting-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BEANSTALK_ENHANCED_HEALTH_REPORTING_ENABLED;

    /**
     * Checks if Classic Load Balancers (CLB) are configured with a user defined Desync mitigation mode.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/clb-desync-mode-check.html">https://docs.aws.amazon.com/config/latest/developerguide/clb-desync-mode-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLB_DESYNC_MODE_CHECK;

    /**
     * Checks if a Classic Load Balancer spans multiple Availability Zones (AZs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/clb-multiple-az.html">https://docs.aws.amazon.com/config/latest/developerguide/clb-multiple-az.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLB_MULTIPLE_AZ;

    /**
     * Checks whether AWS CloudTrail trails are configured to send logs to Amazon CloudWatch Logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED;

    /**
     * Checks whether AWS CloudTrail is enabled in your AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUD_TRAIL_ENABLED;

    /**
     * Checks whether AWS CloudTrail is configured to use the server side encryption (SSE) AWS Key Management Service (AWS KMS) customer master key (CMK) encryption.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUD_TRAIL_ENCRYPTION_ENABLED;

    /**
     * Checks whether AWS CloudTrail creates a signed digest file with logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED;

    /**
     * Checks whether an AWS CloudFormation stack's actual configuration differs, or has drifted, from it's expected configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK;

    /**
     * Checks whether your CloudFormation stacks are sending event notifications to an SNS topic.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFORMATION_STACK_NOTIFICATION_CHECK;

    /**
     * Checks if Amazon CloudFront distributions are configured to capture information from Amazon Simple Storage Service (Amazon S3) server access logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-accesslogs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-accesslogs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_ACCESSLOGS_ENABLED;

    /**
     * Checks if Amazon CloudFront distributions are associated with either WAF or WAFv2 web access control lists (ACLs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-associated-with-waf.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-associated-with-waf.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_ASSOCIATED_WITH_WAF;

    /**
     * Checks if the certificate associated with an Amazon CloudFront distribution is the default Secure Sockets Layer (SSL) certificate.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-custom-ssl-certificate.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-custom-ssl-certificate.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_CUSTOM_SSL_CERTIFICATE;

    /**
     * Checks if an Amazon CloudFront distribution is configured to return a specific object that is the default root object.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED;

    /**
     * Checks if CloudFront distributions are using deprecated SSL protocols for HTTPS communication between CloudFront edge locations and custom origins.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-no-deprecated-ssl-protocols.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-no-deprecated-ssl-protocols.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_NO_DEPRECATED_SSL_PROTOCOLS;

    /**
     * Checks that Amazon CloudFront distribution with Amazon S3 Origin type has Origin Access Identity (OAI) configured.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED;

    /**
     * Checks whether an origin group is configured for the distribution of at least 2 origins in the origin group for Amazon CloudFront.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_ORIGIN_FAILOVER_ENABLED;

    /**
     * Checks if Amazon CloudFront distributions are using a minimum security policy and cipher suite of TLSv1.2 or greater for viewer connections.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-security-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-security-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_SECURITY_POLICY_CHECK;

    /**
     * Checks if Amazon CloudFront distributions are using a custom SSL certificate and are configured to use SNI to serve HTTPS requests.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_SNI_ENABLED;

    /**
     * Checks if Amazon CloudFront distributions are encrypting traffic to custom origins.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-traffic-to-origin-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-traffic-to-origin-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_TRAFFIC_TO_ORIGIN_ENCRYPTED;

    /**
     * Checks whether your Amazon CloudFront distributions use HTTPS (directly or via a redirection).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDFRONT_VIEWER_POLICY_HTTPS;

    /**
     * Checks that there is at least one multi-region AWS CloudTrail.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDTRAIL_MULTI_REGION_ENABLED;

    /**
     * Checks whether at least one AWS CloudTrail trail is logging Amazon S3 data events for all S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDTRAIL_S3_DATAEVENTS_ENABLED;

    /**
     * Checks that there is at least one AWS CloudTrail trail defined with security best practices.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDTRAIL_SECURITY_TRAIL_ENABLED;

    /**
     * Checks whether CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDWATCH_ALARM_ACTION_CHECK;

    /**
     * Checks if Amazon CloudWatch alarms actions are in enabled state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-enabled-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-enabled-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDWATCH_ALARM_ACTION_ENABLED_CHECK;

    /**
     * Checks whether the specified resource type has a CloudWatch alarm for the specified metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDWATCH_ALARM_RESOURCE_CHECK;

    /**
     * Checks whether CloudWatch alarms with the given metric name have the specified settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDWATCH_ALARM_SETTINGS_CHECK;

    /**
     * Checks whether a log group in Amazon CloudWatch Logs is encrypted with a AWS Key Management Service (KMS) managed Customer Master Keys (CMK).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CLOUDWATCH_LOG_GROUP_ENCRYPTED;

    /**
     * Checks that key rotation is enabled for each key and matches to the key ID of the customer created customer master key (CMK).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CMK_BACKING_KEY_ROTATION_ENABLED;

    /**
     * Checks if an AWS CodeBuild project has encryption enabled for all of its artifacts.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-artifact-encryption.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-artifact-encryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_ARTIFACT_ENCRYPTION;

    /**
     * Checks if an AWS CodeBuild project environment has privileged mode enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-environment-privileged-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-environment-privileged-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_ENVIRONMENT_PRIVILEGED_CHECK;

    /**
     * Checks whether the project contains environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK;

    /**
     * Checks if an AWS CodeBuild project environment has at least one log option enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_LOGGING_ENABLED;

    /**
     * Checks if a AWS CodeBuild project configured with Amazon S3 Logs has encryption enabled for its logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-s3-logs-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-s3-logs-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_S3_LOGS_ENCRYPTED;

    /**
     * Checks whether the GitHub or Bitbucket source repository URL contains either personal access tokens or user name and password.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK;

    /**
     * Checks if the deployment group is configured with automatic deployment rollback and deployment monitoring with alarms attached.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-auto-rollback-monitor-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-auto-rollback-monitor-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEDEPLOY_AUTO_ROLLBACK_MONITOR_ENABLED;

    /**
     * Checks if the deployment group for EC2/On-Premises Compute Platform is configured with a minimum healthy hosts fleet percentage or host count greater than or equal to the input threshold.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-ec2-minimum-healthy-hosts-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-ec2-minimum-healthy-hosts-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEDEPLOY_EC2_MINIMUM_HEALTHY_HOSTS_CONFIGURED;

    /**
     * Checks if the deployment group for Lambda Compute Platform is not using the default deployment configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-lambda-allatonce-traffic-shift-disabled.html">https://docs.aws.amazon.com/config/latest/developerguide/codedeploy-lambda-allatonce-traffic-shift-disabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEDEPLOY_LAMBDA_ALLATONCE_TRAFFIC_SHIFT_DISABLED;

    /**
     * Checks whether the first deployment stage of the AWS CodePipeline performs more than one deployment.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEPIPELINE_DEPLOYMENT_COUNT_CHECK;

    /**
     * Checks whether each stage in the AWS CodePipeline deploys to more than N times the number of the regions the AWS CodePipeline has deployed in all the previous combined stages, where N is the region fanout number.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CODEPIPELINE_REGION_FANOUT_CHECK;

    /**
     * Checks whether Amazon CloudWatch LogGroup retention period is set to specific number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CW_LOGGROUP_RETENTION_PERIOD_CHECK;

    /**
     * Checks that DynamoDB Accelerator (DAX) clusters are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DAX_ENCRYPTION_ENABLED;

    /**
     * Checks whether AWS Database Migration Service replication instances are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html">https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DMS_REPLICATION_NOT_PUBLIC;

    /**
     * Checks whether Auto Scaling or On-Demand is enabled on your DynamoDB tables and/or global secondary indexes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_AUTOSCALING_ENABLED;

    /**
     * Checks whether Amazon DynamoDB table is present in AWS Backup plans.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_IN_BACKUP_PLAN;

    /**
     * Checks if a recovery point was created for Amazon DynamoDB Tables within the specified period.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks that point in time recovery (PITR) is enabled for Amazon DynamoDB tables.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_PITR_ENABLED;

    /**
     * Checks if Amazon DynamoDB tables are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks whether Amazon DynamoDB table is encrypted with AWS Key Management Service (KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_TABLE_ENCRYPTED_KMS;

    /**
     * Checks whether the Amazon DynamoDB tables are encrypted and checks their status.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_TABLE_ENCRYPTION_ENABLED;

    /**
     * Checks whether provisioned DynamoDB throughput is approaching the maximum limit for your account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DYNAMODB_THROUGHPUT_LIMIT_CHECK;

    /**
     * Checks whether the EBS volumes that are in an attached state are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html">https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EBS_ENCRYPTED_VOLUMES;

    /**
     * Checks if Amazon Elastic Block Store (Amazon EBS) volumes are added in backup plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EBS_IN_BACKUP_PLAN;

    /**
     * Checks whether EBS optimization is enabled for your EC2 instances that can be EBS-optimized.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EBS_OPTIMIZED_INSTANCE;

    /**
     * Checks if Amazon Elastic Block Store (Amazon EBS) volumes are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EBS_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks whether Amazon Elastic Block Store snapshots are not publicly restorable.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK;

    /**
     * Checks instances for specified tenancy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html">https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_DESIRED_INSTANCE_TENANCY;

    /**
     * Checks whether your EC2 instances are of the specified instance types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html">https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_DESIRED_INSTANCE_TYPE;

    /**
     * Check that Amazon Elastic Block Store (EBS) encryption is enabled by default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_EBS_ENCRYPTION_BY_DEFAULT;

    /**
     * Checks whether your Amazon Elastic Compute Cloud (Amazon EC2) instance metadata version is configured with Instance Metadata Service Version 2 (IMDSv2).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_IMDSV2_CHECK;

    /**
     * Checks whether detailed monitoring is enabled for EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCE_DETAILED_MONITORING_ENABLED;

    /**
     * Checks whether the Amazon EC2 instances in your account are managed by AWS Systems Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCE_MANAGED_BY_SSM;

    /**
     * Checks if Amazon Elastic Compute Cloud (Amazon EC2) uses multiple ENIs (Elastic Network Interfaces) or Elastic Fabric Adapters (EFAs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-multiple-eni-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-multiple-eni-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCE_MULTIPLE_ENI_CHECK;

    /**
     * Checks whether Amazon Elastic Compute Cloud (Amazon EC2) instances have a public IP association.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCE_NO_PUBLIC_IP;

    /**
     * Checks if an Amazon Elastic Compute Cloud (Amazon EC2) instance has an Identity and Access Management (IAM) profile attached to it.
     * <p>
     * This rule is NON_COMPLIANT if no IAM profile is
     * attached to the Amazon EC2 instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-profile-attached.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-profile-attached.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCE_PROFILE_ATTACHED;

    /**
     * Checks whether your EC2 instances belong to a virtual private cloud (VPC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_INSTANCES_IN_VPC;

    /**
     * Checks if a recovery point was created for Amazon Elastic Compute Cloud (Amazon EC2) instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks that none of the specified applications are installed on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED;

    /**
     * Checks whether all of the specified applications are installed on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED;

    /**
     * Checks whether the compliance status of AWS Systems Manager association compliance is COMPLIANT or NON_COMPLIANT after the association execution on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK;

    /**
     * Checks whether instances managed by AWS Systems Manager are configured to collect blocked inventory types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED;

    /**
     * Checks whether the compliance status of the Amazon EC2 Systems Manager patch compliance is COMPLIANT or NON_COMPLIANT after the patch installation on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK;

    /**
     * Checks whether EC2 managed instances have the desired configurations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_MANAGED_INSTANCE_PLATFORM_CHECK;

    /**
     * Checks if running Amazon Elastic Compute Cloud (EC2) instances are launched using amazon key pairs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-no-amazon-key-pair.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-no-amazon-key-pair.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_NO_AMAZON_KEY_PAIR;

    /**
     * Checks if the virtualization type of an EC2 instance is paravirtual.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-paravirtual-instance-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-paravirtual-instance-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_PARAVIRTUAL_INSTANCE_CHECK;

    /**
     * Checks if Amazon Elastic Compute Cloud (Amazon EC2) instances are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks that security groups are attached to Amazon Elastic Compute Cloud (Amazon EC2) instances or to an elastic network interface.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_SECURITY_GROUP_ATTACHED_TO_ENI;

    /**
     * Checks if non-default security groups are attached to Elastic network interfaces (ENIs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni-periodic.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni-periodic.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_SECURITY_GROUP_ATTACHED_TO_ENI_PERIODIC;

    /**
     * Checks whether the incoming SSH traffic for the security groups is accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html">https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED;

    /**
     * Checks whether the security groups in use do not allow unrestricted incoming TCP traffic to the specified ports.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html">https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC;

    /**
     * Checks whether there are instances stopped for more than the allowed number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_STOPPED_INSTANCE;

    /**
     * Checks if an Amazon Elastic Compute Cloud (EC2) instance metadata has a specified token hop limit that is below the desired limit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-token-hop-limit-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-token-hop-limit-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_TOKEN_HOP_LIMIT_CHECK;

    /**
     * Checks if Amazon Elastic Compute Cloud (Amazon EC2) Transit Gateways have 'AutoAcceptSharedAttachments' enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-transit-gateway-auto-vpc-attach-disabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-transit-gateway-auto-vpc-attach-disabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_TRANSIT_GATEWAY_AUTO_VPC_ATTACH_DISABLED;

    /**
     * Checks if an Amazon Elastic Container Service (Amazon ECS) task definition with host networking mode has 'privileged' or 'user' container definitions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_VOLUME_IECS_TASK_DEFINITION_USER_FOR_HOST_MODE_CHECKNUSE_CHECK;

    /**
     * Checks whether EBS volumes are attached to EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EC2_VOLUME_INUSE_CHECK;

    /**
     * Checks if a private Amazon Elastic Container Registry (ECR) repository has image scanning enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-image-scanning-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-image-scanning-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECR_PRIVATE_IMAGE_SCANNING_ENABLED;

    /**
     * Checks if a private Amazon Elastic Container Registry (ECR) repository has at least one lifecycle policy configured.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-lifecycle-policy-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-lifecycle-policy-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECR_PRIVATE_LIFECYCLE_POLICY_CONFIGURED;

    /**
     * Checks if a private Amazon Elastic Container Registry (ECR) repository has tag immutability enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-tag-immutability-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ecr-private-tag-immutability-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECR_PRIVATE_TAG_IMMUTABILITY_ENABLED;

    /**
     * Checks if the networking mode for active ECSTaskDefinitions is set to ‘awsvpc’.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-awsvpc-networking-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-awsvpc-networking-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_AWSVPC_NETWORKING_ENABLED;

    /**
     * Checks if Amazon Elastic Container Service clusters have container insights enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-container-insights-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-container-insights-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_CONTAINER_INSIGHTS_ENABLED;

    /**
     * Checks if the privileged parameter in the container definition of ECSTaskDefinitions is set to ‘true’.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_CONTAINERS_NONPRIVILEGED;

    /**
     * Checks if Amazon Elastic Container Service (Amazon ECS) Containers only have read-only access to its root filesystems.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-containers-readonly-access.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-containers-readonly-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_CONTAINERS_READONLY_ACCESS;

    /**
     * Checks if Amazon Elastic Container Service (ECS) Fargate Services is running on the latest Fargate platform version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-fargate-latest-platform-version.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-fargate-latest-platform-version.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_FARGATE_LATEST_PLATFORM_VERSION;

    /**
     * Checks if secrets are passed as container environment variables.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-no-environment-secrets.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-no-environment-secrets.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_NO_ENVIRONMENT_SECRETS;

    /**
     * Checks if logConfiguration is set on active ECS Task Definitions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-log-configuration.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-log-configuration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_TASK_DEFINITION_LOG_CONFIGURATION;

    /**
     * Checks if Amazon Elastic Container Service (ECS) task definitions have a set memory limit for its container definitions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-memory-hard-limit.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-memory-hard-limit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_TASK_DEFINITION_MEMORY_HARD_LIMIT;

    /**
     * Checks if ECSTaskDefinitions specify a user for Amazon Elastic Container Service (Amazon ECS) EC2 launch type containers to run on.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-nonroot-user.html">https://docs.aws.amazon.com/config/latest/developerguide/ecs-task-definition-nonroot-user.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_TASK_DEFINITION_NONROOT_USER;

    /**
     * Checks if ECSTaskDefinitions are configured to share a host’s process namespace with its Amazon Elastic Container Service (Amazon ECS) containers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ECS_TASK_DEFINITION_PID_MODE_CHECK;

    /**
     * Checks if Amazon Elastic File System (Amazon EFS) access points are configured to enforce a root directory.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-access-point-enforce-root-directory.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-access-point-enforce-root-directory.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_ACCESS_POINT_ENFORCE_ROOT_DIRECTORY;

    /**
     * Checks if Amazon Elastic File System (Amazon EFS) access points are configured to enforce a user identity.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_ACCESS_POINT_ENFORCE_USER_IDENTITY;

    /**
     * hecks whether Amazon Elastic File System (Amazon EFS) is configured to encrypt the file data using AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_ENCRYPTED_CHECK;

    /**
     * Checks whether Amazon Elastic File System (Amazon EFS) file systems are added in the backup plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_IN_BACKUP_PLAN;

    /**
     * Checks if a recovery point was created for Amazon Elastic File System (Amazon EFS) File Systems.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks if Amazon Elastic File System (Amazon EFS) File Systems are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EFS_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks whether all Elastic IP addresses that are allocated to a VPC are attached to EC2 instances or in-use elastic network interfaces (ENIs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html">https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EIP_ATTACHED;

    /**
     * Checks if an Amazon Elastic Kubernetes Service (EKS) cluster is running the oldest supported version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-cluster-oldest-supported-version.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-cluster-oldest-supported-version.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EKS_CLUSTER_OLDEST_SUPPORTED_VERSION;

    /**
     * Checks if an Amazon Elastic Kubernetes Service (EKS) cluster is running a supported Kubernetes version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-cluster-supported-version.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-cluster-supported-version.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EKS_CLUSTER_SUPPORTED_VERSION;

    /**
     * Checks whether Amazon Elastic Kubernetes Service (Amazon EKS) endpoint is not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EKS_ENDPOINT_NO_PUBLIC_ACCESS;

    /**
     * Checks whether Amazon Elastic Kubernetes Service clusters are configured to have Kubernetes secrets encrypted using AWS Key Management Service (KMS) keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EKS_SECRETS_ENCRYPTED;

    /**
     * Checks if managed platform updates in an AWS Elastic Beanstalk environment is enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elastic-beanstalk-managed-updates-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elastic-beanstalk-managed-updates-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELASTIC_BEANSTALK_MANAGED_UPDATES_ENABLED;

    /**
     * Check if the Amazon ElastiCache Redis clusters have automatic backup turned on.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK;

    /**
     * Checks whether Amazon Elasticsearch Service (Amazon ES) domains have encryption at rest configuration enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELASTICSEARCH_ENCRYPTED_AT_REST;

    /**
     * Checks whether Amazon Elasticsearch Service (Amazon ES) domains are in Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELASTICSEARCH_IN_VPC_ONLY;

    /**
     * Check that Amazon ElasticSearch Service nodes are encrypted end to end.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK;

    /**
     * Checks whether the Classic Load Balancers use SSL certificates provided by AWS Certificate Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_ACM_CERTIFICATE_REQUIRED;

    /**
     * Checks if cross-zone load balancing is enabled for the Classic Load Balancers (CLBs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED;

    /**
     * Checks whether your Classic Load Balancer SSL listeners are using a custom policy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK;

    /**
     * Checks whether Elastic Load Balancing has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_DELETION_PROTECTION_ENABLED;

    /**
     * Checks whether the Application Load Balancer and the Classic Load Balancer have logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_LOGGING_ENABLED;

    /**
     * Checks whether your Classic Load Balancer SSL listeners are using a predefined policy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK;

    /**
     * Checks whether your Classic Load Balancer is configured with SSL or HTTPS listeners.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELB_TLS_HTTPS_LISTENERS_ONLY;

    /**
     * Checks if Application Load Balancers and Network Load Balancers have listeners that are configured to use certificates from AWS Certificate Manager (ACM).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elbv2-acm-certificate-required.html">https://docs.aws.amazon.com/config/latest/developerguide/elbv2-acm-certificate-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELBV2_ACM_CERTIFICATE_REQUIRED;

    /**
     * Checks if an Elastic Load Balancer V2 (Application, Network, or Gateway Load Balancer) has registered instances from multiple Availability Zones (AZ's).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elbv2-multiple-az.html">https://docs.aws.amazon.com/config/latest/developerguide/elbv2-multiple-az.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ELBV2_MULTIPLE_AZ;

    /**
     * Checks that Amazon EMR clusters have Kerberos enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EMR_KERBEROS_ENABLED;

    /**
     * Checks whether Amazon Elastic MapReduce (EMR) clusters' master nodes have public IPs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html">https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String EMR_MASTER_NO_PUBLIC_IP;

    /**
     * (deprecated) Checks whether the security groups associated inScope resources are compliant with the master security groups at each rule level based on allowSecurityGroup and denySecurityGroup flag.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html</a>
     * @deprecated Inactive managed rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static java.lang.String FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK;

    /**
     * (deprecated) Checks whether AWS Firewall Manager created security groups content is the same as the master security groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html</a>
     * @deprecated Inactive managed rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static java.lang.String FMS_SECURITY_GROUP_CONTENT_CHECK;

    /**
     * (deprecated) Checks whether Amazon EC2 or an elastic network interface is associated with AWS Firewall Manager security groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html</a>
     * @deprecated Inactive managed rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static java.lang.String FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK;

    /**
     * Checks whether an Application Load Balancer, Amazon CloudFront distributions, Elastic Load Balancer or Elastic IP has AWS Shield protection.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String FMS_SHIELD_RESOURCE_POLICY_CHECK;

    /**
     * Checks whether the web ACL is associated with an Application Load Balancer, API Gateway stage, or Amazon CloudFront distributions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String FMS_WEBACL_RESOURCE_POLICY_CHECK;

    /**
     * Checks that the rule groups associate with the web ACL at the correct priority.
     * <p>
     * The correct priority is decided by the rank of the rule groups in the ruleGroups parameter.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK;

    /**
     * Checks if a recovery point was created for Amazon FSx File Systems.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fsx-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/fsx-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String FSX_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks if Amazon FSx File Systems are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fsx-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/fsx-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String FSX_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks whether Amazon GuardDuty is enabled in your AWS account and region.
     * <p>
     * If you provide an AWS account for centralization,
     * the rule evaluates the Amazon GuardDuty results in the centralized account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html">https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String GUARDDUTY_ENABLED_CENTRALIZED;

    /**
     * Checks whether the Amazon GuardDuty has findings that are non archived.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html">https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String GUARDDUTY_NON_ARCHIVED_FINDINGS;

    /**
     * Checks that the managed AWS Identity and Access Management policies that you create do not allow blocked actions on all AWS AWS KMS keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS;

    /**
     * Checks whether IAM groups have at least one IAM user.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_GROUP_HAS_USERS_CHECK;

    /**
     * Checks that the inline policies attached to your AWS Identity and Access Management users, roles, and groups do not allow blocked actions on all AWS Key Management Service keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS;

    /**
     * Checks that inline policy feature is not in use.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_NO_INLINE_POLICY_CHECK;

    /**
     * Checks whether the account password policy for IAM users meets the specified requirements indicated in the parameters.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_PASSWORD_POLICY;

    /**
     * Checks whether for each IAM resource, a policy ARN in the input parameter is attached to the IAM resource.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_POLICY_BLOCKED_CHECK;

    /**
     * Checks whether the IAM policy ARN is attached to an IAM user, or an IAM group with one or more IAM users, or an IAM role with one or more trusted entity.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_POLICY_IN_USE;

    /**
     * Checks the IAM policies that you create for Allow statements that grant permissions to all actions on all resources.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS;

    /**
     * Checks if AWS Identity and Access Management (IAM) policies that you create grant permissions to all actions on individual AWS resources.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-full-access.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-full-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_POLICY_NO_STATEMENTS_WITH_FULL_ACCESS;

    /**
     * Checks that AWS Identity and Access Management (IAM) policies in a list of policies are attached to all AWS roles.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_ROLE_MANAGED_POLICY_CHECK;

    /**
     * Checks whether the root user access key is available.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_ROOT_ACCESS_KEY_CHECK;

    /**
     * Checks whether IAM users are members of at least one IAM group.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_USER_GROUP_MEMBERSHIP_CHECK;

    /**
     * Checks whether the AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_USER_MFA_ENABLED;

    /**
     * Checks that none of your IAM users have policies attached.
     * <p>
     * IAM users must inherit permissions from IAM groups or roles.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_USER_NO_POLICIES_CHECK;

    /**
     * Checks whether your AWS Identity and Access Management (IAM) users have passwords or active access keys that have not been used within the specified number of days you provided.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IAM_USER_UNUSED_CREDENTIALS_CHECK;

    /**
     * Checks that Internet gateways (IGWs) are only attached to an authorized Amazon Virtual Private Cloud (VPCs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html">https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY;

    /**
     * Checks if Amazon Kinesis streams are encrypted at rest with server-side encryption.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/kinesis-stream-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/kinesis-stream-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String KINESIS_STREAM_ENCRYPTED;

    /**
     * Checks whether customer master keys (CMKs) are not scheduled for deletion in AWS Key Management Service (KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html">https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String KMS_CMK_NOT_SCHEDULED_FOR_DELETION;

    /**
     * Checks whether the AWS Lambda function is configured with function-level concurrent execution limit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_CONCURRENCY_CHECK;

    /**
     * Checks whether an AWS Lambda function is configured with a dead-letter queue.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_DLQ_CHECK;

    /**
     * Checks whether the AWS Lambda function policy attached to the Lambda resource prohibits public access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED;

    /**
     * Checks that the lambda function settings for runtime, role, timeout, and memory size match the expected values.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_FUNCTION_SETTINGS_CHECK;

    /**
     * Checks whether an AWS Lambda function is in an Amazon Virtual Private Cloud.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_INSIDE_VPC;

    /**
     * Checks if Lambda has more than 1 availability zone associated.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-vpc-multi-az-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-vpc-multi-az-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String LAMBDA_VPC_MULTI_AZ_CHECK;

    /**
     * Checks whether AWS Multi-Factor Authentication (MFA) is enabled for all IAM users that use a console password.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html">https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS;

    /**
     * Checks if default ports for SSH/RDP ingress traffic for network access control lists (NACLs) is unrestricted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/nacl-no-unrestricted-ssh-rdp.html">https://docs.aws.amazon.com/config/latest/developerguide/nacl-no-unrestricted-ssh-rdp.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NACL_NO_UNRESTRICTED_SSH_RDP;

    /**
     * Checks if an AWS Network Firewall policy is configured with a user defined stateless default action for fragmented packets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-default-action-fragment-packets.html">https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-default-action-fragment-packets.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NETFW_POLICY_DEFAULT_ACTION_FRAGMENT_PACKETS;

    /**
     * Checks if an AWS Network Firewall policy is configured with a user defined default stateless action for full packets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-default-action-full-packets.html">https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-default-action-full-packets.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NETFW_POLICY_DEFAULT_ACTION_FULL_PACKETS;

    /**
     * Check AWS Network Firewall policy is associated with stateful OR stateless rule groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-rule-group-associated.html">https://docs.aws.amazon.com/config/latest/developerguide/netfw-policy-rule-group-associated.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NETFW_POLICY_RULE_GROUP_ASSOCIATED;

    /**
     * Checks if a Stateless Network Firewall Rule Group contains rules.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/netfw-stateless-rule-group-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/netfw-stateless-rule-group-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NETFW_STATELESS_RULE_GROUP_NOT_EMPTY;

    /**
     * Checks if cross-zone load balancing is enabled on Network Load Balancers (NLBs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/nlb-cross-zone-load-balancing-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/nlb-cross-zone-load-balancing-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NLB_CROSS_ZONE_LOAD_BALANCING_ENABLED;

    /**
     * Checks if Amazon OpenSearch Service domains have fine-grained access control enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-access-control-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-access-control-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_ACCESS_CONTROL_ENABLED;

    /**
     * Checks if Amazon OpenSearch Service domains have audit logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-audit-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-audit-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_AUDIT_LOGGING_ENABLED;

    /**
     * Checks if Amazon OpenSearch Service domains are configured with at least three data nodes and zoneAwarenessEnabled is true.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-data-node-fault-tolerance.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-data-node-fault-tolerance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_DATA_NODE_FAULT_TOLERANCE;

    /**
     * Checks if Amazon OpenSearch Service domains have encryption at rest configuration enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-encrypted-at-rest.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-encrypted-at-rest.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_ENCRYPTED_AT_REST;

    /**
     * Checks whether connections to OpenSearch domains are using HTTPS.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-https-required.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-https-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_HTTPS_REQUIRED;

    /**
     * Checks if Amazon OpenSearch Service domains are in an Amazon Virtual Private Cloud (VPC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-in-vpc-only.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-in-vpc-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_IN_VPC_ONLY;

    /**
     * Checks if Amazon OpenSearch Service domains are configured to send logs to Amazon CloudWatch Logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-logs-to-cloudwatch.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-logs-to-cloudwatch.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_LOGS_TO_CLOUDWATCH;

    /**
     * Check if Amazon OpenSearch Service nodes are encrypted end to end.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/opensearch-node-to-node-encryption-check.html">https://docs.aws.amazon.com/config/latest/developerguide/opensearch-node-to-node-encryption-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String OPENSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK;

    /**
     * Checks if Amazon Relational Database Service (RDS) database instances are configured for automatic minor version upgrades.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-automatic-minor-version-upgrade-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-automatic-minor-version-upgrade-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_AUTOMATIC_MINOR_VERSION_UPGRADE_ENABLED;

    /**
     * Checks if an Amazon Relational Database Service (Amazon RDS) database cluster has changed the admin username from its default value.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-default-admin-check.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-default-admin-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_CLUSTER_DEFAULT_ADMIN_CHECK;

    /**
     * Checks if an Amazon Relational Database Service (Amazon RDS) cluster has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_CLUSTER_DELETION_PROTECTION_ENABLED;

    /**
     * Checks if an Amazon RDS Cluster has AWS Identity and Access Management (IAM) authentication enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-iam-authentication-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-iam-authentication-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_CLUSTER_IAM_AUTHENTICATION_ENABLED;

    /**
     * Checks if Multi-AZ replication is enabled on Amazon Aurora and Hermes clusters managed by Amazon Relational Database Service (Amazon RDS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-multi-az-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-multi-az-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_CLUSTER_MULTI_AZ_ENABLED;

    /**
     * Checks whether RDS DB instances have backups enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_DB_INSTANCE_BACKUP_ENABLED;

    /**
     * Checks if there are any Amazon Relational Database Service (RDS) DB security groups that are not the default DB security group.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-db-security-group-not-allowed.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-db-security-group-not-allowed.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_DB_SECURITY_GROUP_NOT_ALLOWED;

    /**
     * Checks whether enhanced monitoring is enabled for Amazon Relational Database Service (Amazon RDS) instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_ENHANCED_MONITORING_ENABLED;

    /**
     * Checks whether Amazon RDS database is present in back plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_IN_BACKUP_PLAN;

    /**
     * Checks if an Amazon Relational Database Service (Amazon RDS) database has changed the admin username from its default value.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-default-admin-check.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-default-admin-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_INSTANCE_DEFAULT_ADMIN_CHECK;

    /**
     * Checks if an Amazon Relational Database Service (Amazon RDS) instance has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_INSTANCE_DELETION_PROTECTION_ENABLED;

    /**
     * Checks if an Amazon RDS instance has AWS Identity and Access Management (IAM) authentication enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED;

    /**
     * Check whether the Amazon Relational Database Service instances are not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_INSTANCE_PUBLIC_ACCESS_CHECK;

    /**
     * Checks if a recovery point was created for Amazon Relational Database Service (Amazon RDS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_LOGGING_ENABLED;

    /**
     * Checks whether high availability is enabled for your RDS DB instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_MULTI_AZ_SUPPORT;

    /**
     * Checks if Amazon Relational Database Service (Amazon RDS) instances are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks whether Amazon Relational Database Service (Amazon RDS) DB snapshots are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_SNAPSHOT_ENCRYPTED;

    /**
     * Checks if Amazon Relational Database Service (Amazon RDS) snapshots are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_SNAPSHOTS_PUBLIC_PROHIBITED;

    /**
     * Checks whether storage encryption is enabled for your RDS DB instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RDS_STORAGE_ENCRYPTED;

    /**
     * Checks if Amazon Redshift clusters are logging audits to a specific bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-audit-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-audit-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_AUDIT_LOGGING_ENABLED;

    /**
     * Checks that Amazon Redshift automated snapshots are enabled for clusters.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_BACKUP_ENABLED;

    /**
     * Checks whether Amazon Redshift clusters have the specified settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_CLUSTER_CONFIGURATION_CHECK;

    /**
     * Checks if Amazon Redshift clusters are using a specified AWS Key Management Service (AWS KMS) key for encryption.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-kms-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-kms-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_CLUSTER_KMS_ENABLED;

    /**
     * Checks whether Amazon Redshift clusters have the specified maintenance settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK;

    /**
     * Checks whether Amazon Redshift clusters are not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK;

    /**
     * Checks if an Amazon Redshift cluster has changed the admin username from its default value.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-default-admin-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-default-admin-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_DEFAULT_ADMIN_CHECK;

    /**
     * Checks if a Redshift cluster has changed its database name from the default value.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-default-db-name-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-default-db-name-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_DEFAULT_DB_NAME_CHECK;

    /**
     * Checks if Amazon Redshift cluster has 'enhancedVpcRouting' enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-enhanced-vpc-routing-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-enhanced-vpc-routing-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_ENHANCED_VPC_ROUTING_ENABLED;

    /**
     * Checks whether Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REDSHIFT_REQUIRE_TLS_SSL;

    /**
     * Checks whether your resources have the tags that you specify.
     * <p>
     * For example, you can check whether your Amazon EC2 instances have the CostCenter tag.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html">https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REQUIRED_TAGS;

    /**
     * Checks whether your AWS account is enabled to use multi-factor authentication (MFA) hardware device to sign in with root credentials.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ROOT_ACCOUNT_HARDWARE_MFA_ENABLED;

    /**
     * Checks whether users of your AWS account require a multi-factor authentication (MFA) device to sign in with root credentials.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ROOT_ACCOUNT_MFA_ENABLED;

    /**
     * Checks whether the required public access block settings are configured from account level.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS;

    /**
     * Checks if the required public access block settings are configured from account level.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks-periodic.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks-periodic.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS_PERIODIC;

    /**
     * Checks if Amazon Simple Storage Service (Amazon S3) Buckets allow user permissions through access control lists (ACLs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-acl-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-acl-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_ACL_PROHIBITED;

    /**
     * Checks if the Amazon Simple Storage Service bucket policy does not allow blacklisted bucket-level and object-level actions on resources in the bucket for principals from other AWS accounts.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED;

    /**
     * Checks whether Amazon Simple Storage Service (Amazon S3) bucket has lock enabled, by default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_DEFAULT_LOCK_ENABLED;

    /**
     * Checks if Amazon Simple Storage Service (Amazon S3) buckets are publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-level-public-access-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-level-public-access-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED;

    /**
     * Checks whether logging is enabled for your S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_LOGGING_ENABLED;

    /**
     * Checks that the access granted by the Amazon S3 bucket is restricted by any of the AWS principals, federated users, service principals, IP addresses, or VPCs that you provide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_POLICY_GRANTEE_CHECK;

    /**
     * Checks if your Amazon Simple Storage Service bucket policies do not allow other inter-account permissions than the control Amazon S3 bucket policy that you provide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE;

    /**
     * Checks if your Amazon S3 buckets do not allow public read access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_PUBLIC_READ_PROHIBITED;

    /**
     * Checks that your Amazon S3 buckets do not allow public write access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_PUBLIC_WRITE_PROHIBITED;

    /**
     * Checks whether S3 buckets have cross-region replication enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_REPLICATION_ENABLED;

    /**
     * Checks that your Amazon S3 bucket either has Amazon S3 default encryption enabled or that the S3 bucket policy explicitly denies put-object requests without server side encryption that uses AES-256 or AWS Key Management Service.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED;

    /**
     * Checks whether S3 buckets have policies that require requests to use Secure Socket Layer (SSL).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_SSL_REQUESTS_ONLY;

    /**
     * Checks whether versioning is enabled for your S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_BUCKET_VERSIONING_ENABLED;

    /**
     * Checks whether the Amazon Simple Storage Service (Amazon S3) buckets are encrypted with AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_DEFAULT_ENCRYPTION_KMS;

    /**
     * Checks if Amazon S3 Events Notifications are enabled on an S3 bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-event-notifications-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-event-notifications-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_EVENT_NOTIFICATIONS_ENABLED;

    /**
     * Checks if a recovery point was created for Amazon Simple Storage Service (Amazon S3).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks if a lifecycle rule is configured for an Amazon Simple Storage Service (Amazon S3) bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-lifecycle-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-lifecycle-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_LIFECYCLE_POLICY_CHECK;

    /**
     * Checks if Amazon Simple Storage Service (Amazon S3) buckets are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks if Amazon Simple Storage Service (Amazon S3) version enabled buckets have lifecycle policy configured.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-version-lifecycle-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-version-lifecycle-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String S3_VERSION_LIFECYCLE_POLICY_CHECK;

    /**
     * Checks whether AWS Key Management Service (KMS) key is configured for an Amazon SageMaker endpoint configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED;

    /**
     * Check whether an AWS Key Management Service (KMS) key is configured for SageMaker notebook instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED;

    /**
     * Checks whether direct internet access is disabled for an Amazon SageMaker notebook instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS;

    /**
     * Checks whether AWS Secrets Manager secret has rotation enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECRETSMANAGER_ROTATION_ENABLED_CHECK;

    /**
     * Checks whether AWS Secrets Manager secret rotation has rotated successfully as per the rotation schedule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK;

    /**
     * Checks if AWS Secrets Manager secrets have been rotated in the past specified number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-secret-periodic-rotation.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-secret-periodic-rotation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECRETSMANAGER_SECRET_PERIODIC_ROTATION;

    /**
     * Checks if AWS Secrets Manager secrets have been accessed within a specified number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-secret-unused.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-secret-unused.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECRETSMANAGER_SECRET_UNUSED;

    /**
     * Checks if all secrets in AWS Secrets Manager are encrypted using the AWS managed key (aws/secretsmanager) or a customer managed key that was created in AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-using-cmk.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-using-cmk.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECRETSMANAGER_USING_CMK;

    /**
     * Checks that AWS Security Hub is enabled for an AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SECURITYHUB_ENABLED;

    /**
     * Checks whether Service Endpoint for the service provided in rule parameter is created for each Amazon VPC.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SERVICE_VPC_ENDPOINT_ENABLED;

    /**
     * Checks whether EBS volumes are attached to EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html">https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SHIELD_ADVANCED_ENABLED_AUTO_RENEW;

    /**
     * Verify that DDoS response team (DRT) can access AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html">https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SHIELD_DRT_ACCESS;

    /**
     * Checks whether Amazon SNS topic is encrypted with AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SNS_ENCRYPTED_KMS;

    /**
     * Checks if Amazon Simple Notification Service (SNS) logging is enabled for the delivery status of notification messages sent to a topic for the endpoints.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-message-delivery-notification-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-message-delivery-notification-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SNS_TOPIC_MESSAGE_DELIVERY_NOTIFICATION_ENABLED;

    /**
     * Checks if AWS Systems Manager documents owned by the account are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ssm-document-not-public.html">https://docs.aws.amazon.com/config/latest/developerguide/ssm-document-not-public.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SSM_DOCUMENT_NOT_PUBLIC;

    /**
     * Checks if a recovery point was created for AWS Storage Gateway volumes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/storagegateway-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/storagegateway-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String STORAGEGATEWAY_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * hecks if Amazon Virtual Private Cloud (Amazon VPC) subnets are assigned a public IP address.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/subnet-auto-assign-public-ip-disabled.html">https://docs.aws.amazon.com/config/latest/developerguide/subnet-auto-assign-public-ip-disabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SUBNET_AUTO_ASSIGN_PUBLIC_IP_DISABLED;

    /**
     * Checks if a recovery point was created for AWS Backup-Gateway VirtualMachines.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/virtualmachine-last-backup-recovery-point-created.html">https://docs.aws.amazon.com/config/latest/developerguide/virtualmachine-last-backup-recovery-point-created.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VIRTUALMACHINE_LAST_BACKUP_RECOVERY_POINT_CREATED;

    /**
     * Checks if AWS Backup-Gateway VirtualMachines are protected by a backup plan.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/virtualmachine-resources-protected-by-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/virtualmachine-resources-protected-by-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VIRTUALMACHINE_RESOURCES_PROTECTED_BY_BACKUP_PLAN;

    /**
     * Checks that the default security group of any Amazon Virtual Private Cloud (VPC) does not allow inbound or outbound traffic.
     * <p>
     * The rule returns NOT_APPLICABLE if the security group
     * is not default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_DEFAULT_SECURITY_GROUP_CLOSED;

    /**
     * Checks whether Amazon Virtual Private Cloud flow logs are found and enabled for Amazon VPC.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_FLOW_LOGS_ENABLED;

    /**
     * Checks if there are unused network access control lists (network ACLs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-network-acl-unused-check.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-network-acl-unused-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_NETWORK_ACL_UNUSED_CHECK;

    /**
     * Checks if DNS resolution from accepter/requester VPC to private IP is enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-peering-dns-resolution-check.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-peering-dns-resolution-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_PEERING_DNS_RESOLUTION_CHECK;

    /**
     * Checks whether the security group with 0.0.0.0/0 of any Amazon Virtual Private Cloud (Amazon VPC) allows only specific inbound TCP or UDP traffic.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS;

    /**
     * Checks that both AWS Virtual Private Network tunnels provided by AWS Site-to-Site VPN are in UP status.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VPC_VPN_2_TUNNELS_UP;

    /**
     * Checks if logging is enabled on AWS Web Application Firewall (WAF) classic global web ACLs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_CLASSIC_LOGGING_ENABLED;

    /**
     * Checks if an AWS WAF global rule contains any conditions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-global-rule-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-global-rule-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_GLOBAL_RULE_NOT_EMPTY;

    /**
     * Checks if an AWS WAF Classic rule group contains any rules.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-global-rulegroup-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-global-rulegroup-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_GLOBAL_RULEGROUP_NOT_EMPTY;

    /**
     * Checks whether a WAF Global Web ACL contains any WAF rules or rule groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-global-webacl-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-global-webacl-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_GLOBAL_WEBACL_NOT_EMPTY;

    /**
     * Checks whether WAF regional rule contains conditions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-rule-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-rule-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_REGIONAL_RULE_NOT_EMPTY;

    /**
     * Checks if WAF Regional rule groups contain any rules.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-rulegroup-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-rulegroup-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_REGIONAL_RULEGROUP_NOT_EMPTY;

    /**
     * Checks if a WAF regional Web ACL contains any WAF rules or rule groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-webacl-not-empty.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-regional-webacl-not-empty.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAF_REGIONAL_WEBACL_NOT_EMPTY;

    /**
     * Checks whether logging is enabled on AWS Web Application Firewall (WAFV2) regional and global web access control list (ACLs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String WAFV2_LOGGING_ENABLED;
}
