package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnDataSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .name("name")
 *         .projectIdentifier("projectIdentifier")
 *         .type("type")
 *         // the properties below are optional
 *         .assetFormsInput(List.of(FormInputProperty.builder()
 *                 .formName("formName")
 *                 // the properties below are optional
 *                 .content("content")
 *                 .typeIdentifier("typeIdentifier")
 *                 .typeRevision("typeRevision")
 *                 .build()))
 *         .configuration(DataSourceConfigurationInputProperty.builder()
 *                 .glueRunConfiguration(GlueRunConfigurationInputProperty.builder()
 *                         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 // the properties below are optional
 *                                 .filterExpressions(List.of(FilterExpressionProperty.builder()
 *                                         .expression("expression")
 *                                         .type("type")
 *                                         .build()))
 *                                 .schemaName("schemaName")
 *                                 .build()))
 *                         // the properties below are optional
 *                         .dataAccessRole("dataAccessRole")
 *                         .build())
 *                 .redshiftRunConfiguration(RedshiftRunConfigurationInputProperty.builder()
 *                         .redshiftCredentialConfiguration(RedshiftCredentialConfigurationProperty.builder()
 *                                 .secretManagerArn("secretManagerArn")
 *                                 .build())
 *                         .redshiftStorage(RedshiftStorageProperty.builder()
 *                                 .redshiftClusterSource(RedshiftClusterStorageProperty.builder()
 *                                         .clusterName("clusterName")
 *                                         .build())
 *                                 .redshiftServerlessSource(RedshiftServerlessStorageProperty.builder()
 *                                         .workgroupName("workgroupName")
 *                                         .build())
 *                                 .build())
 *                         .relationalFilterConfigurations(List.of(RelationalFilterConfigurationProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 // the properties below are optional
 *                                 .filterExpressions(List.of(FilterExpressionProperty.builder()
 *                                         .expression("expression")
 *                                         .type("type")
 *                                         .build()))
 *                                 .schemaName("schemaName")
 *                                 .build()))
 *                         // the properties below are optional
 *                         .dataAccessRole("dataAccessRole")
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .enableSetting("enableSetting")
 *         .publishOnImport(false)
 *         .recommendation(RecommendationConfigurationProperty.builder()
 *                 .enableBusinessNameGeneration(false)
 *                 .build())
 *         .schedule(ScheduleConfigurationProperty.builder()
 *                 .schedule("schedule")
 *                 .timezone("timezone")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:30.561Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Amazon DataZone domain where the data source is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-environmentidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * The name of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The identifier of the Amazon DataZone project in which you want to add this data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-projectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier();

    /**
     * The type of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The metadata forms attached to the assets that the data source works with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-assetformsinput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetFormsInput() {
        return null;
    }

    /**
     * The configuration of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * The description of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether the data source is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-enablesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-enablesetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnableSetting() {
        return null;
    }

    /**
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-publishonimport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublishOnImport() {
        return null;
    }

    /**
     * Specifies whether the business name generation is to be enabled for this data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-recommendation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecommendation() {
        return null;
    }

    /**
     * The schedule of the data source runs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-datasource.html#cfn-datazone-datasource-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.String domainIdentifier;
        java.lang.String environmentIdentifier;
        java.lang.String name;
        java.lang.String projectIdentifier;
        java.lang.String type;
        java.lang.Object assetFormsInput;
        java.lang.Object configuration;
        java.lang.String description;
        java.lang.String enableSetting;
        java.lang.Object publishOnImport;
        java.lang.Object recommendation;
        java.lang.Object schedule;

        /**
         * Sets the value of {@link CfnDataSourceProps#getDomainIdentifier}
         * @param domainIdentifier The ID of the Amazon DataZone domain where the data source is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The unique identifier of the Amazon DataZone environment to which the data source publishes assets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getName}
         * @param name The name of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getProjectIdentifier}
         * @param projectIdentifier The identifier of the Amazon DataZone project in which you want to add this data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(java.lang.String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getType}
         * @param type The type of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getAssetFormsInput}
         * @param assetFormsInput The metadata forms attached to the assets that the data source works with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetFormsInput(software.amazon.awscdk.IResolvable assetFormsInput) {
            this.assetFormsInput = assetFormsInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getAssetFormsInput}
         * @param assetFormsInput The metadata forms attached to the assets that the data source works with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetFormsInput(java.util.List<? extends java.lang.Object> assetFormsInput) {
            this.assetFormsInput = assetFormsInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getConfiguration}
         * @param configuration The configuration of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getConfiguration}
         * @param configuration The configuration of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.datazone.CfnDataSource.DataSourceConfigurationInputProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDescription}
         * @param description The description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getEnableSetting}
         * @param enableSetting Specifies whether the data source is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSetting(java.lang.String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getPublishOnImport}
         * @param publishOnImport Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishOnImport(java.lang.Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getPublishOnImport}
         * @param publishOnImport Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishOnImport(software.amazon.awscdk.IResolvable publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRecommendation}
         * @param recommendation Specifies whether the business name generation is to be enabled for this data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recommendation(software.amazon.awscdk.IResolvable recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRecommendation}
         * @param recommendation Specifies whether the business name generation is to be enabled for this data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recommendation(software.amazon.awscdk.services.datazone.CfnDataSource.RecommendationConfigurationProperty recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSchedule}
         * @param schedule The schedule of the data source runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSchedule}
         * @param schedule The schedule of the data source runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.datazone.CfnDataSource.ScheduleConfigurationProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.String domainIdentifier;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String name;
        private final java.lang.String projectIdentifier;
        private final java.lang.String type;
        private final java.lang.Object assetFormsInput;
        private final java.lang.Object configuration;
        private final java.lang.String description;
        private final java.lang.String enableSetting;
        private final java.lang.Object publishOnImport;
        private final java.lang.Object recommendation;
        private final java.lang.Object schedule;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetFormsInput = software.amazon.jsii.Kernel.get(this, "assetFormsInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableSetting = software.amazon.jsii.Kernel.get(this, "enableSetting", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishOnImport = software.amazon.jsii.Kernel.get(this, "publishOnImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.recommendation = software.amazon.jsii.Kernel.get(this, "recommendation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.projectIdentifier = java.util.Objects.requireNonNull(builder.projectIdentifier, "projectIdentifier is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.assetFormsInput = builder.assetFormsInput;
            this.configuration = builder.configuration;
            this.description = builder.description;
            this.enableSetting = builder.enableSetting;
            this.publishOnImport = builder.publishOnImport;
            this.recommendation = builder.recommendation;
            this.schedule = builder.schedule;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAssetFormsInput() {
            return this.assetFormsInput;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEnableSetting() {
            return this.enableSetting;
        }

        @Override
        public final java.lang.Object getPublishOnImport() {
            return this.publishOnImport;
        }

        @Override
        public final java.lang.Object getRecommendation() {
            return this.recommendation;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAssetFormsInput() != null) {
                data.set("assetFormsInput", om.valueToTree(this.getAssetFormsInput()));
            }
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableSetting() != null) {
                data.set("enableSetting", om.valueToTree(this.getEnableSetting()));
            }
            if (this.getPublishOnImport() != null) {
                data.set("publishOnImport", om.valueToTree(this.getPublishOnImport()));
            }
            if (this.getRecommendation() != null) {
                data.set("recommendation", om.valueToTree(this.getRecommendation()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!projectIdentifier.equals(that.projectIdentifier)) return false;
            if (!type.equals(that.type)) return false;
            if (this.assetFormsInput != null ? !this.assetFormsInput.equals(that.assetFormsInput) : that.assetFormsInput != null) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableSetting != null ? !this.enableSetting.equals(that.enableSetting) : that.enableSetting != null) return false;
            if (this.publishOnImport != null ? !this.publishOnImport.equals(that.publishOnImport) : that.publishOnImport != null) return false;
            if (this.recommendation != null ? !this.recommendation.equals(that.recommendation) : that.recommendation != null) return false;
            return this.schedule != null ? this.schedule.equals(that.schedule) : that.schedule == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.projectIdentifier.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.assetFormsInput != null ? this.assetFormsInput.hashCode() : 0);
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableSetting != null ? this.enableSetting.hashCode() : 0);
            result = 31 * result + (this.publishOnImport != null ? this.publishOnImport.hashCode() : 0);
            result = 31 * result + (this.recommendation != null ? this.recommendation.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return result;
        }
    }
}
