package software.amazon.awscdk.services.ec2;

/**
 * Construct a Windows machine image from an AMI map.
 * <p>
 * Allows you to create a generic Windows EC2 , manually specify an AMI map.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * GenericWindowsImage genericWindowsImage = GenericWindowsImage.Builder.create(Map.of(
 *         "amiMapKey", "amiMap"))
 * .userData(userData)
 * .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.432Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.GenericWindowsImage")
public class GenericWindowsImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected GenericWindowsImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericWindowsImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param amiMap This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericWindowsImage(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericWindowsImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * @param amiMap This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericWindowsImage(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.GenericWindowsImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.GenericWindowsImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param amiMap This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            return new Builder(amiMap);
        }

        private final java.util.Map<java.lang.String, java.lang.String> amiMap;
        private software.amazon.awscdk.services.ec2.GenericWindowsImageProps.Builder props;

        private Builder(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            this.amiMap = amiMap;
        }

        /**
         * Initial user data.
         * <p>
         * Default: - Empty UserData for Windows machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.GenericWindowsImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.GenericWindowsImage build() {
            return new software.amazon.awscdk.services.ec2.GenericWindowsImage(
                this.amiMap,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.GenericWindowsImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.GenericWindowsImageProps.Builder();
            }
            return this.props;
        }
    }
}
