package software.amazon.awscdk.services.ec2;

/**
 * An AWS service for an interface VPC endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.494Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService")
public class InterfaceVpcEndpointAwsService extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService {

    protected InterfaceVpcEndpointAwsService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InterfaceVpcEndpointAwsService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACCESS_ANALYZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ACCESS_ANALYZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ACCOUNT_MANAGEMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ACCOUNT_MANAGEMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AIRFLOW_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AIRFLOW_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AIRFLOW_ENV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AIRFLOW_ENV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AIRFLOW_OPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AIRFLOW_OPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APIGATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APIGATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APP_MESH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APP_MESH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APP_RUNNER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APP_RUNNER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APP_RUNNER_REQUESTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APP_RUNNER_REQUESTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APP_SYNC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APP_SYNC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APPLICATION_AUTOSCALING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APPLICATION_AUTOSCALING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APPLICATION_MIGRATION_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APPLICATION_MIGRATION_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APPSTREAM_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APPSTREAM_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        APPSTREAM_STREAMING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APPSTREAM_STREAMING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ATHENA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ATHENA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AUDIT_MANAGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AUDIT_MANAGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AUTOSCALING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AUTOSCALING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        AUTOSCALING_PLANS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "AUTOSCALING_PLANS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        BACKUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "BACKUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        BACKUP_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "BACKUP_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        BATCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "BATCH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        BILLING_CONDUCTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "BILLING_CONDUCTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        BRAKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "BRAKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUD_CONTROL_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUD_CONTROL_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUD_CONTROL_API_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUD_CONTROL_API_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUD_DIRECTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUD_DIRECTORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDFORMATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDFORMATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDHSM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDHSM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDTRAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDTRAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_EVENTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_EVENTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_EVIDENTLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_EVIDENTLY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_EVIDENTLY_DATAPLANE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_EVIDENTLY_DATAPLANE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_LOGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_LOGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_MONITORING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_MONITORING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_RUM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_RUM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_RUM_DATAPLANE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_RUM_DATAPLANE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_SYNTHETICS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_SYNTHETICS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEARTIFACT_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEARTIFACT_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEARTIFACT_REPOSITORIES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEARTIFACT_REPOSITORIES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEBUILD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEBUILD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEBUILD_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEBUILD_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_GIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_GIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_GIT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_GIT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEDEPLOY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEDEPLOY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEDEPLOY_COMMANDS_SECURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEDEPLOY_COMMANDS_SECURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEGURU_PROFILER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEGURU_PROFILER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEGURU_REVIEWER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEGURU_REVIEWER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEPIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEPIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODESTAR_CONNECTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODESTAR_CONNECTIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        COMPREHEND = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "COMPREHEND", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        COMPREHEND_MEDICAL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "COMPREHEND_MEDICAL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_APP_INTEGRATIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_APP_INTEGRATIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_CASES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_CASES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_CONNECT_CAMPAIGNS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_CONNECT_CAMPAIGNS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_VOICEID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_VOICEID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONNECT_WISDOM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONNECT_WISDOM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        DATA_EXCHANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "DATA_EXCHANGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        DATABASE_MIGRATION_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "DATABASE_MIGRATION_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        DATABASE_MIGRATION_SERVICE_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "DATABASE_MIGRATION_SERVICE_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        DATASYNC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "DATASYNC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        DEVOPS_GURU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "DEVOPS_GURU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EBS_DIRECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EBS_DIRECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EC2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EC2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EC2_MESSAGES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EC2_MESSAGES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECR_DOCKER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECR_DOCKER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS_AGENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS_AGENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS_TELEMETRY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS_TELEMETRY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EKS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EKS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_BEANSTALK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_BEANSTALK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_BEANSTALK_HEALTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_BEANSTALK_HEALTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_DISASTER_RECOVERY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_DISASTER_RECOVERY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_FILESYSTEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_FILESYSTEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_FILESYSTEM_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_FILESYSTEM_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_INFERENCE_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_INFERENCE_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_LOAD_BALANCING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_LOAD_BALANCING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTICACHE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTICACHE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTICACHE_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTICACHE_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EMAIL_SMTP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EMAIL_SMTP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EMR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EMR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EMR_EKS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EMR_EKS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EMR_SERVERLESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EMR_SERVERLESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EVENTBRIDGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EVENTBRIDGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FAULT_INJECTION_SIMULATOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FAULT_INJECTION_SIMULATOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FINSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FINSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FINSPACE_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FINSPACE_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FORECAST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FORECAST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FORECAST_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FORECAST_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FORECAST_QUERY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FORECAST_QUERY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FORECAST_QUERY_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FORECAST_QUERY_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FRAUD_DETECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FRAUD_DETECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FSX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FSX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        FSX_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "FSX_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GLUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GLUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GLUE_DATABREW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GLUE_DATABREW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GRAFANA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GRAFANA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GRAFANA_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GRAFANA_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GROUNDSTATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GROUNDSTATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        HEALTHLAKE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "HEALTHLAKE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IAM_IDENTITY_CENTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IAM_IDENTITY_CENTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IAM_ROLES_ANYWHERE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IAM_ROLES_ANYWHERE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IMAGE_BUILDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IMAGE_BUILDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        INSPECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "INSPECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_CORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_CORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_CORE_DEVICE_ADVISOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_CORE_DEVICE_ADVISOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_CORE_FOR_LORAWAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_CORE_FOR_LORAWAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_GREENGRASS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_GREENGRASS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_LORAWAN_CUPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_LORAWAN_CUPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_LORAWAN_LNS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_LORAWAN_LNS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_ROBORUNNER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_ROBORUNNER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_SITEWISE_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_SITEWISE_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_SITEWISE_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_SITEWISE_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_TWINMAKER_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_TWINMAKER_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        IOT_TWINMAKER_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "IOT_TWINMAKER_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KENDRA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KENDRA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KENDRA_RANKING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KENDRA_RANKING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KEYSPACES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KEYSPACES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KEYSPACES_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KEYSPACES_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KINESIS_FIREHOSE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KINESIS_FIREHOSE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KINESIS_STREAMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KINESIS_STREAMS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KMS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KMS_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KMS_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LAKE_FORMATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LAKE_FORMATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LAMBDA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LAMBDA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LEX_MODELS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LEX_MODELS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LEX_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LEX_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LICENSE_MANAGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LICENSE_MANAGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LICENSE_MANAGER_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LICENSE_MANAGER_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LOOKOUT_EQUIPMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LOOKOUT_EQUIPMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LOOKOUT_METRICS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LOOKOUT_METRICS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LOOKOUT_VISION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LOOKOUT_VISION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MACIE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MACIE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MAINFRAME_MODERNIZATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MAINFRAME_MODERNIZATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MEMORY_DB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MEMORY_DB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MEMORY_DB_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MEMORY_DB_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MIGRATIONHUB_ORCHESTRATOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MIGRATIONHUB_ORCHESTRATOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MIGRATIONHUB_REFACTOR_SPACES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MIGRATIONHUB_REFACTOR_SPACES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        MIGRATIONHUB_STRATEGY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "MIGRATIONHUB_STRATEGY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        NIMBLE_STUDIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "NIMBLE_STUDIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        OMICS_ANALYTICS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "OMICS_ANALYTICS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        OMICS_CONTROL_STORAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "OMICS_CONTROL_STORAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        OMICS_STORAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "OMICS_STORAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        OMICS_TAGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "OMICS_TAGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        OMICS_WORKFLOWS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "OMICS_WORKFLOWS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PANORAMA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PANORAMA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PINPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PINPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        POLLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "POLLY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PRIVATE_5_G = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PRIVATE_5G", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PRIVATE_CERTIFICATE_AUTHORITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PRIVATE_CERTIFICATE_AUTHORITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PROMETHEUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PROMETHEUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PROMETHEUS_WORKSPACES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PROMETHEUS_WORKSPACES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        PROTON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "PROTON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        QLDB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "QLDB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        RDS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "RDS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        RDS_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "RDS_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REDSHIFT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REDSHIFT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REDSHIFT_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REDSHIFT_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REDSHIFT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REDSHIFT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REKOGNITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REKOGNITION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REKOGNITION_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REKOGNITION_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ROBOMAKER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ROBOMAKER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        S3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "S3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        S3_MULTI_REGION_ACCESS_POINTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "S3_MULTI_REGION_ACCESS_POINTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        S3_OUTPOSTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "S3_OUTPOSTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_FEATURESTORE_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_FEATURESTORE_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_METRICS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_METRICS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_NOTEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_NOTEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_RUNTIME_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_RUNTIME_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_STUDIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_STUDIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SECRETS_MANAGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SECRETS_MANAGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SECURITYHUB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SECURITYHUB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVER_MIGRATION_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVER_MIGRATION_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVER_MIGRATION_SERVICE_AWSCONNECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVER_MIGRATION_SERVICE_AWSCONNECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVER_MIGRATION_SERVICE_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVER_MIGRATION_SERVICE_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVICE_CATALOG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVICE_CATALOG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVICE_CATALOG_APPREGISTRY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVICE_CATALOG_APPREGISTRY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SNOW_DEVICE_MANAGEMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SNOW_DEVICE_MANAGEMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SNS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SNS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SQS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SQS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM_CONTACTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM_CONTACTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM_INCIDENTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM_INCIDENTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM_MESSAGES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM_MESSAGES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STEP_FUNCTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STEP_FUNCTIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STEP_FUNCTIONS_SYNC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STEP_FUNCTIONS_SYNC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STORAGE_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STORAGE_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TEXTRACT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TEXTRACT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TEXTRACT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TEXTRACT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSCRIBE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSCRIBE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSCRIBE_STREAMING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSCRIBE_STREAMING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSFER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSFER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSFER_SERVER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSFER_SERVER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        VERIFIED_PERMISSIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "VERIFIED_PERMISSIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        WORKSPACES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "WORKSPACES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        XRAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "XRAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
    }

    /**
     * @param name The name of the service. This parameter is required.
     * @param prefix
     * @param port The port of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String prefix, final @org.jetbrains.annotations.Nullable java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), prefix, port });
    }

    /**
     * @param name The name of the service. This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), prefix });
    }

    /**
     * @param name The name of the service. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ACCESS_ANALYZER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ACCOUNT_MANAGEMENT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AIRFLOW_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AIRFLOW_ENV;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AIRFLOW_OPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APIGATEWAY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APP_MESH;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APP_RUNNER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APP_RUNNER_REQUESTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APP_SYNC;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APPLICATION_AUTOSCALING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APPLICATION_MIGRATION_SERVICE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APPSTREAM_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APPSTREAM_STREAMING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ATHENA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AUDIT_MANAGER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AUTOSCALING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService AUTOSCALING_PLANS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService BACKUP;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService BACKUP_GATEWAY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService BATCH;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService BILLING_CONDUCTOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService BRAKET;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUD_CONTROL_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUD_CONTROL_API_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUD_DIRECTORY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDFORMATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDHSM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDTRAIL;

    /**
     * @deprecated <ul>
     * <li>Use InterfaceVpcEndpointAwsService.CLOUDWATCH_MONITORING instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH;

    /**
     * @deprecated <ul>
     * <li>Use InterfaceVpcEndpointAwsService.EVENTBRIDGE instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_EVENTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_EVIDENTLY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_EVIDENTLY_DATAPLANE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_LOGS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_MONITORING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_RUM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_RUM_DATAPLANE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_SYNTHETICS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEARTIFACT_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEARTIFACT_REPOSITORIES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEBUILD;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEBUILD_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_GIT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_GIT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEDEPLOY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEDEPLOY_COMMANDS_SECURE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEGURU_PROFILER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEGURU_REVIEWER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEPIPELINE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODESTAR_CONNECTIONS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService COMPREHEND;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService COMPREHEND_MEDICAL;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONFIG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_APP_INTEGRATIONS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_CASES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_CONNECT_CAMPAIGNS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_PROFILE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_VOICEID;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONNECT_WISDOM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService DATA_EXCHANGE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService DATABASE_MIGRATION_SERVICE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService DATABASE_MIGRATION_SERVICE_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService DATASYNC;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService DEVOPS_GURU;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EBS_DIRECT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EC2;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EC2_MESSAGES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECR_DOCKER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS_AGENT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS_TELEMETRY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EKS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_BEANSTALK;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_BEANSTALK_HEALTH;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_DISASTER_RECOVERY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_FILESYSTEM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_FILESYSTEM_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_INFERENCE_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_LOAD_BALANCING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTICACHE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTICACHE_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EMAIL_SMTP;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EMR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EMR_EKS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EMR_SERVERLESS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EVENTBRIDGE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FAULT_INJECTION_SIMULATOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FINSPACE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FINSPACE_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FORECAST;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FORECAST_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FORECAST_QUERY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FORECAST_QUERY_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FRAUD_DETECTOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FSX;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService FSX_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GLUE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GLUE_DATABREW;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GRAFANA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GRAFANA_WORKSPACE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GROUNDSTATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService HEALTHLAKE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IAM_IDENTITY_CENTER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IAM_ROLES_ANYWHERE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IMAGE_BUILDER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService INSPECTOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_CORE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_CORE_DEVICE_ADVISOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_CORE_FOR_LORAWAN;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_GREENGRASS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_LORAWAN_CUPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_LORAWAN_LNS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_ROBORUNNER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_SITEWISE_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_SITEWISE_DATA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_TWINMAKER_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService IOT_TWINMAKER_DATA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KENDRA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KENDRA_RANKING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KEYSPACES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KEYSPACES_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KINESIS_FIREHOSE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KINESIS_STREAMS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KMS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KMS_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LAKE_FORMATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LAMBDA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LEX_MODELS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LEX_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LICENSE_MANAGER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LICENSE_MANAGER_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LOOKOUT_EQUIPMENT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LOOKOUT_METRICS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LOOKOUT_VISION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MACIE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MAINFRAME_MODERNIZATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MEMORY_DB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MEMORY_DB_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MIGRATIONHUB_ORCHESTRATOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MIGRATIONHUB_REFACTOR_SPACES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService MIGRATIONHUB_STRATEGY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService NIMBLE_STUDIO;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService OMICS_ANALYTICS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService OMICS_CONTROL_STORAGE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService OMICS_STORAGE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService OMICS_TAGS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService OMICS_WORKFLOWS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PANORAMA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PINPOINT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService POLLY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PRIVATE_5_G;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PRIVATE_CERTIFICATE_AUTHORITY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PROMETHEUS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PROMETHEUS_WORKSPACES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService PROTON;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService QLDB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService RDS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService RDS_DATA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REDSHIFT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REDSHIFT_DATA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REDSHIFT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REKOGNITION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REKOGNITION_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ROBOMAKER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService S3;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService S3_MULTI_REGION_ACCESS_POINTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService S3_OUTPOSTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_FEATURESTORE_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_METRICS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_NOTEBOOK;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_RUNTIME_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_STUDIO;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SECRETS_MANAGER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SECURITYHUB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVER_MIGRATION_SERVICE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVER_MIGRATION_SERVICE_AWSCONNECTOR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVER_MIGRATION_SERVICE_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVICE_CATALOG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVICE_CATALOG_APPREGISTRY;

    /**
     * @deprecated <ul>
     * <li>Use InterfaceVpcEndpointAwsService.EMAIL_SMTP instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SNOW_DEVICE_MANAGEMENT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SNS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SQS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM_CONTACTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM_INCIDENTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM_MESSAGES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STEP_FUNCTIONS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STEP_FUNCTIONS_SYNC;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STORAGE_GATEWAY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TEXTRACT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TEXTRACT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSCRIBE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSCRIBE_STREAMING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSFER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSFER_SERVER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSLATE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService VERIFIED_PERMISSIONS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService WORKSPACES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService XRAY;

    /**
     * The name of the service.
     * <p>
     * e.g. com.amazonaws.us-east-1.ecs
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The short name of the service.
     * <p>
     * e.g. ecs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getShortName() {
        return software.amazon.jsii.Kernel.get(this, "shortName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether Private DNS is supported by default.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivateDnsDefault() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsDefault", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
