package software.amazon.awscdk.services.ecs;

/**
 * An image that will be built from a local directory with a Dockerfile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.constructs.Construct;
 * import software.amazon.awscdk.App;
 * import software.amazon.awscdk.Stack;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.cxapi.*;
 * import path.*;
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         this.node.setContext(ECS_REMOVE_DEFAULT_DESIRED_COUNT, true);
 *         Vpc vpc = Vpc.Builder.create(this, "VPC")
 *                 .maxAzs(2)
 *                 .build();
 *         QueueProcessingFargateService.Builder.create(this, "QueueProcessingService")
 *                 .vpc(vpc)
 *                 .memoryLimitMiB(512)
 *                 .image(new AssetImage(join(__dirname, "..", "sqs-reader")))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.697Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AssetImage")
public class AssetImage extends software.amazon.awscdk.services.ecs.ContainerImage {

    protected AssetImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the AssetImage class.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AssetImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), props });
    }

    /**
     * Constructs a new instance of the AssetImage class.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Called when the image is used by a ContainerDefinition.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AssetImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AssetImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param directory The directory containing the Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String directory) {
            return new Builder(directory);
        }

        private final java.lang.String directory;
        private software.amazon.awscdk.services.ecs.AssetImageProps.Builder props;

        private Builder(final java.lang.String directory) {
            this.directory = directory;
        }

        /**
         * File paths matching the patterns will be excluded.
         * <p>
         * See <code>ignoreMode</code> to set the matching behavior.
         * Has no effect on Assets bundled using the <code>bundling</code> property.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude File paths matching the patterns will be excluded. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props().exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.props().followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for <code>exclude</code> patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.props().ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props().extraHash(extraHash);
            return this;
        }

        /**
         * Unique identifier of the docker image asset and its potential revisions.
         * <p>
         * Required if using AppScopedStagingSynthesizer.
         * <p>
         * Default: - no asset name
         * <p>
         * @return {@code this}
         * @param assetName Unique identifier of the docker image asset and its potential revisions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(final java.lang.String assetName) {
            this.props().assetName(assetName);
            return this;
        }

        /**
         * Build args to pass to the <code>docker build</code> command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props().buildArgs(buildArgs);
            return this;
        }

        /**
         * Build secrets.
         * <p>
         * Docker BuildKit must be enabled to use build secrets.
         * <p>
         * Default: - no build secrets
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * import software.amazon.awscdk.DockerBuildSecret;
         * Map&lt;String, String&gt; buildSecrets = Map.of(
         *         "MY_SECRET", DockerBuildSecret.fromSrc("file.txt"));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/buildkit/">https://docs.docker.com/build/buildkit/</a>
         * @param buildSecrets Build secrets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSecrets(final java.util.Map<java.lang.String, java.lang.String> buildSecrets) {
            this.props().buildSecrets(buildSecrets);
            return this;
        }

        /**
         * SSH agent socket or keys to pass to the <code>docker build</code> command.
         * <p>
         * Docker BuildKit must be enabled to use the ssh flag
         * <p>
         * Default: - no --ssh flag
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/buildkit/">https://docs.docker.com/build/buildkit/</a>
         * @param buildSsh SSH agent socket or keys to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSsh(final java.lang.String buildSsh) {
            this.props().buildSsh(buildSsh);
            return this;
        }

        /**
         * Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
         * <p>
         * Default: - cache is used
         * <p>
         * @return {@code this}
         * @param cacheDisabled Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDisabled(final java.lang.Boolean cacheDisabled) {
            this.props().cacheDisabled(cacheDisabled);
            return this;
        }

        /**
         * Cache from options to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no cache from options are passed to the build command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
         * @param cacheFrom Cache from options to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheFrom(final java.util.List<? extends software.amazon.awscdk.services.ecr.assets.DockerCacheOption> cacheFrom) {
            this.props().cacheFrom(cacheFrom);
            return this;
        }

        /**
         * Cache to options to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no cache to options are passed to the build command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
         * @param cacheTo Cache to options to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTo(final software.amazon.awscdk.services.ecr.assets.DockerCacheOption cacheTo) {
            this.props().cacheTo(cacheTo);
            return this;
        }

        /**
         * Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(final java.lang.String file) {
            this.props().file(file);
            return this;
        }

        /**
         * Options to control which parameters are used to invalidate the asset hash.
         * <p>
         * Default: - hash all parameters
         * <p>
         * @return {@code this}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invalidation(final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.props().invalidation(invalidation);
            return this;
        }

        /**
         * Networking mode for the RUN commands during build.
         * <p>
         * Support docker API 1.25+.
         * <p>
         * Default: - no networking mode specified (the default networking mode `NetworkMode.DEFAULT` will be used)
         * <p>
         * @return {@code this}
         * @param networkMode Networking mode for the RUN commands during build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * Outputs to pass to the <code>docker build</code> command.
         * <p>
         * Default: - no outputs are passed to the build command (default outputs are used)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs">https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs</a>
         * @param outputs Outputs to pass to the <code>docker build</code> command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<java.lang.String> outputs) {
            this.props().outputs(outputs);
            return this;
        }

        /**
         * Platform to build for.
         * <p>
         * <em>Requires Docker Buildx</em>.
         * <p>
         * Default: - no platform specified (the current machine architecture will be used)
         * <p>
         * @return {@code this}
         * @param platform Platform to build for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(final software.amazon.awscdk.services.ecr.assets.Platform platform) {
            this.props().platform(platform);
            return this;
        }

        /**
         * Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props().target(target);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.AssetImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AssetImage build() {
            return new software.amazon.awscdk.services.ecs.AssetImage(
                this.directory,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.AssetImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.AssetImageProps.Builder();
            }
            return this.props;
        }
    }
}
