package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Target Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer alb;
 * ApplicationListener listener = alb.addListener("Listener", BaseApplicationListenerProps.builder().port(80).build());
 * ApplicationTargetGroup targetGroup = listener.addTargets("Fleet", AddApplicationTargetsProps.builder().port(80).build());
 * ServerDeploymentGroup deploymentGroup = ServerDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .loadBalancer(LoadBalancer.application(targetGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:32.389Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup")
public class ApplicationTargetGroup extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup {

    protected ApplicationTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing target group.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup fromTargetGroupAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class, "fromTargetGroupAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a load balancing target to this target group.
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
        software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * Enable sticky routing via a cookie to members of this target group.
     * <p>
     * Note: If the <code>cookieName</code> parameter is set, application-based stickiness will be applied,
     * otherwise it defaults to duration-based stickiness attributes (<code>lb_cookie</code>).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html</a>
     * @param duration This parameter is required.
     * @param cookieName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableCookieStickiness(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration, final @org.jetbrains.annotations.Nullable java.lang.String cookieName) {
        software.amazon.jsii.Kernel.call(this, "enableCookieStickiness", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required"), cookieName });
    }

    /**
     * Enable sticky routing via a cookie to members of this target group.
     * <p>
     * Note: If the <code>cookieName</code> parameter is set, application-based stickiness will be applied,
     * otherwise it defaults to duration-based stickiness attributes (<code>lb_cookie</code>).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html</a>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableCookieStickiness(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        software.amazon.jsii.Kernel.call(this, "enableCookieStickiness", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group.
     * <p>
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group.
     * <p>
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (deprecated) The number of healthy hosts in the target group.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.healthyHostCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of healthy hosts in the target group.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.healthyHostCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.httpCodeTarget</code> instead
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * (deprecated) The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.httpCodeTarget</code> instead
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (deprecated) The number of IPv6 requests received by the target group.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.ipv6RequestCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of IPv6 requests received by the target group.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.ipv6RequestCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.requestCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.requestCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The average number of requests received by each target in a target group.
     * <p>
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.requestCountPerTarget</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCountPerTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The average number of requests received by each target in a target group.
     * <p>
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.requestCountPerTarget</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget() {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCountPerTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.targetConnectionErrorCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.targetConnectionErrorCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.targetResponseTime</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.targetResponseTime</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.tlsNegotiationErrorCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.tlsNegotiationErrorCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of unhealthy hosts in the target group.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.unhealthyHostCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricUnhealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of unhealthy hosts in the target group.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>ApplicationTargetGroup.metrics.unhealthyHostCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount() {
        return software.amazon.jsii.Kernel.call(this, "metricUnhealthyHostCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Register a connectable as a member of this target group.
     * <p>
     * Don't call this directly. It will be called by load balancing targets.
     * <p>
     * @param connectable This parameter is required.
     * @param portRange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), portRange });
    }

    /**
     * Register a connectable as a member of this target group.
     * <p>
     * Don't call this directly. It will be called by load balancing targets.
     * <p>
     * @param connectable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable) {
        software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required") });
    }

    /**
     * Register a listener that is load balancing to this target group.
     * <p>
     * Don't call this directly. It will be called by listeners.
     * <p>
     * @param listener This parameter is required.
     * @param associatingConstruct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.constructs.IConstruct associatingConstruct) {
        software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
    }

    /**
     * Register a listener that is load balancing to this target group.
     * <p>
     * Don't call this directly. It will be called by listeners.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
        software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateTargetGroup() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateTargetGroup", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Full name of first load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFirstLoadBalancerFullName() {
        return software.amazon.jsii.Kernel.get(this, "firstLoadBalancerFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * All metrics available for this target group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroupMetrics getMetrics() {
        return software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroupMetrics.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * <p>
         * The range is 0-3600 seconds.
         * <p>
         * Default: 300
         * <p>
         * @return {@code this}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(final software.amazon.awscdk.Duration deregistrationDelay) {
            this.props().deregistrationDelay(deregistrationDelay);
            return this;
        }

        /**
         * Health check configuration.
         * <p>
         * Default: - The default value for each property in this configuration varies depending on the target.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#aws-resource-elasticloadbalancingv2-targetgroup-properties">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#aws-resource-elasticloadbalancingv2-targetgroup-properties</a>
         * @param healthCheck Health check configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.props().healthCheck(healthCheck);
            return this;
        }

        /**
         * The name of the target group.
         * <p>
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * <p>
         * Default: - Automatically generated.
         * <p>
         * @return {@code this}
         * @param targetGroupName The name of the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(final java.lang.String targetGroupName) {
            this.props().targetGroupName(targetGroupName);
            return this;
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * <p>
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * <p>
         * Default: - Determined automatically.
         * <p>
         * @return {@code this}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.props().targetType(targetType);
            return this;
        }

        /**
         * The virtual private cloud (VPC).
         * <p>
         * only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param vpc The virtual private cloud (VPC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * The load balancing algorithm to select targets for routing requests.
         * <p>
         * Default: TargetGroupLoadBalancingAlgorithmType.ROUND_ROBIN
         * <p>
         * @return {@code this}
         * @param loadBalancingAlgorithmType The load balancing algorithm to select targets for routing requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancingAlgorithmType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupLoadBalancingAlgorithmType loadBalancingAlgorithmType) {
            this.props().loadBalancingAlgorithmType(loadBalancingAlgorithmType);
            return this;
        }

        /**
         * The port on which the target receives traffic.
         * <p>
         * This is not applicable for Lambda targets.
         * <p>
         * Default: - Determined from protocol if known
         * <p>
         * @return {@code this}
         * @param port The port on which the target receives traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props().port(port);
            return this;
        }

        /**
         * The protocol used for communication with the target.
         * <p>
         * This is not applicable for Lambda targets.
         * <p>
         * Default: - Determined from port if known
         * <p>
         * @return {@code this}
         * @param protocol The protocol used for communication with the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.props().protocol(protocol);
            return this;
        }

        /**
         * The protocol version to use.
         * <p>
         * Default: ApplicationProtocolVersion.HTTP1
         * <p>
         * @return {@code this}
         * @param protocolVersion The protocol version to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolVersion(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion protocolVersion) {
            this.props().protocolVersion(protocolVersion);
            return this;
        }

        /**
         * The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
         * <p>
         * The range is 30-900 seconds (15 minutes).
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param slowStart The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowStart(final software.amazon.awscdk.Duration slowStart) {
            this.props().slowStart(slowStart);
            return this;
        }

        /**
         * The stickiness cookie expiration period.
         * <p>
         * Setting this value enables load balancer stickiness.
         * <p>
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * <p>
         * Default: Duration.days(1)
         * <p>
         * @return {@code this}
         * @param stickinessCookieDuration The stickiness cookie expiration period. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stickinessCookieDuration(final software.amazon.awscdk.Duration stickinessCookieDuration) {
            this.props().stickinessCookieDuration(stickinessCookieDuration);
            return this;
        }

        /**
         * The name of an application-based stickiness cookie.
         * <p>
         * Names that start with the following prefixes are not allowed: AWSALB, AWSALBAPP,
         * and AWSALBTG; they're reserved for use by the load balancer.
         * <p>
         * Note: <code>stickinessCookieName</code> parameter depends on the presence of <code>stickinessCookieDuration</code> parameter.
         * If <code>stickinessCookieDuration</code> is not set, <code>stickinessCookieName</code> will be omitted.
         * <p>
         * Default: - If `stickinessCookieDuration` is set, a load-balancer generated cookie is used. Otherwise, no stickiness is defined.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/sticky-sessions.html</a>
         * @param stickinessCookieName The name of an application-based stickiness cookie. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stickinessCookieName(final java.lang.String stickinessCookieName) {
            this.props().stickinessCookieName(stickinessCookieName);
            return this;
        }

        /**
         * The targets to add to this target group.
         * <p>
         * Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
         * target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
         * target must be of the same type.
         * <p>
         * Default: - No targets.
         * <p>
         * @return {@code this}
         * @param targets The targets to add to this target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps.Builder();
            }
            return this.props;
        }
    }
}
