package software.amazon.awscdk.services.rds;

/**
 * Create a clustered database with a given number of instances.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:38.666Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.IDatabaseCluster")
@software.amazon.jsii.Jsii.Proxy(IDatabaseCluster.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IDatabaseCluster extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource, software.amazon.awscdk.services.ec2.IConnectable, software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget {

    /**
     * The endpoint to use for read/write operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint();

    /**
     * Identifier of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * Endpoint to use for load-balanced read-only operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint();

    /**
     * The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
     * <p>
     * This AWS Region-unique identifier is used in things like IAM authentication policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier();

    /**
     * Endpoints which address each individual replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.Endpoint> getInstanceEndpoints();

    /**
     * Identifiers of the replicas.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers();

    /**
     * The engine of this Cluster.
     * <p>
     * May be not known for imported Clusters if it wasn't provided explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
        return null;
    }

    /**
     * Add a new db proxy to this cluster.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxy addProxy(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyOptions options);

    /**
     * Grant the given identity connection access to the Cluster.
     * <p>
     * @param grantee the Principal to grant the permissions to. This parameter is required.
     * @param dbUser the name of the database user to allow connecting. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String dbUser);

    /**
     * Return the given named metric for this DBCluster.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Return the given named metric for this DBCluster.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * The percentage of CPU utilization.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The percentage of CPU utilization.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization();

    /**
     * The number of database connections in use.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDatabaseConnections(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of database connections in use.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDatabaseConnections();

    /**
     * The average number of deadlocks in the database per second.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDeadlocks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The average number of deadlocks in the database per second.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDeadlocks();

    /**
     * The amount of time that the instance has been running, in seconds.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricEngineUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of time that the instance has been running, in seconds.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricEngineUptime();

    /**
     * The amount of available random access memory, in bytes.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeableMemory(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of available random access memory, in bytes.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeableMemory();

    /**
     * The amount of local storage available, in bytes.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeLocalStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of local storage available, in bytes.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeLocalStorage();

    /**
     * The amount of network throughput received from clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkReceiveThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of network throughput received from clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkReceiveThroughput();

    /**
     * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkThroughput();

    /**
     * The amount of network throughput sent to clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkTransmitThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of network throughput sent to clients by each instance, in bytes per second.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkTransmitThroughput();

    /**
     * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSnapshotStorageUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSnapshotStorageUsed();

    /**
     * The total amount of backup storage in bytes for which you are billed.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalBackupStorageBilled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total amount of backup storage in bytes for which you are billed.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalBackupStorageBilled();

    /**
     * The amount of storage used by your Aurora DB instance, in bytes.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeBytesUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The amount of storage used by your Aurora DB instance, in bytes.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeBytesUsed();

    /**
     * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeReadIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeReadIOPs();

    /**
     * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeWriteIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeWriteIOPs();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.rds.IDatabaseCluster.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The endpoint to use for read/write operations.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
        }

        /**
         * Identifier of the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
            return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Endpoint to use for load-balanced read-only operations.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
        }

        /**
         * The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
         * <p>
         * This AWS Region-unique identifier is used in things like IAM authentication policies.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier() {
            return software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Endpoints which address each individual replica.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.Endpoint> getInstanceEndpoints() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class))));
        }

        /**
         * Identifiers of the replicas.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * The engine of this Cluster.
         * <p>
         * May be not known for imported Clusters if it wasn't provided explicitly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Renders the target specifications.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps asSecretAttachmentTarget() {
            return software.amazon.jsii.Kernel.call(this, "asSecretAttachmentTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps.class));
        }

        /**
         * Add a new db proxy to this cluster.
         * <p>
         * @param id This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxy addProxy(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addProxy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.DatabaseProxy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Grant the given identity connection access to the Cluster.
         * <p>
         * @param grantee the Principal to grant the permissions to. This parameter is required.
         * @param dbUser the name of the database user to allow connecting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String dbUser) {
            return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(dbUser, "dbUser is required") });
        }

        /**
         * Return the given named metric for this DBCluster.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Return the given named metric for this DBCluster.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * The percentage of CPU utilization.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The percentage of CPU utilization.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of database connections in use.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDatabaseConnections(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDatabaseConnections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of database connections in use.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDatabaseConnections() {
            return software.amazon.jsii.Kernel.call(this, "metricDatabaseConnections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The average number of deadlocks in the database per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDeadlocks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDeadlocks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The average number of deadlocks in the database per second.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDeadlocks() {
            return software.amazon.jsii.Kernel.call(this, "metricDeadlocks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of time that the instance has been running, in seconds.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricEngineUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricEngineUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of time that the instance has been running, in seconds.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricEngineUptime() {
            return software.amazon.jsii.Kernel.call(this, "metricEngineUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of available random access memory, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeableMemory(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeableMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of available random access memory, in bytes.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeableMemory() {
            return software.amazon.jsii.Kernel.call(this, "metricFreeableMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of local storage available, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeLocalStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeLocalStorage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of local storage available, in bytes.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeLocalStorage() {
            return software.amazon.jsii.Kernel.call(this, "metricFreeLocalStorage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of network throughput received from clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkReceiveThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkReceiveThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput received from clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkReceiveThroughput() {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkReceiveThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkThroughput() {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of network throughput sent to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkTransmitThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkTransmitThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput sent to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkTransmitThroughput() {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkTransmitThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSnapshotStorageUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSnapshotStorageUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSnapshotStorageUsed() {
            return software.amazon.jsii.Kernel.call(this, "metricSnapshotStorageUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total amount of backup storage in bytes for which you are billed.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalBackupStorageBilled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricTotalBackupStorageBilled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total amount of backup storage in bytes for which you are billed.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalBackupStorageBilled() {
            return software.amazon.jsii.Kernel.call(this, "metricTotalBackupStorageBilled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The amount of storage used by your Aurora DB instance, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeBytesUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeBytesUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of storage used by your Aurora DB instance, in bytes.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeBytesUsed() {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeBytesUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeReadIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeReadIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeReadIOPs() {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeReadIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeWriteIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeWriteIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeWriteIOPs() {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeWriteIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IDatabaseCluster}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IDatabaseCluster, software.amazon.awscdk.IResource.Jsii$Default, software.amazon.awscdk.services.ec2.IConnectable.Jsii$Default, software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The endpoint to use for read/write operations.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
        }

        /**
         * Identifier of the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
            return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Endpoint to use for load-balanced read-only operations.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
        }

        /**
         * The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
         * <p>
         * This AWS Region-unique identifier is used in things like IAM authentication policies.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier() {
            return software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Endpoints which address each individual replica.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.Endpoint> getInstanceEndpoints() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class))));
        }

        /**
         * Identifiers of the replicas.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * The engine of this Cluster.
         * <p>
         * May be not known for imported Clusters if it wasn't provided explicitly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Renders the target specifications.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps asSecretAttachmentTarget() {
            return software.amazon.jsii.Kernel.call(this, "asSecretAttachmentTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps.class));
        }

        /**
         * Add a new db proxy to this cluster.
         * <p>
         * @param id This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxy addProxy(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addProxy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.DatabaseProxy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Grant the given identity connection access to the Cluster.
         * <p>
         * @param grantee the Principal to grant the permissions to. This parameter is required.
         * @param dbUser the name of the database user to allow connecting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String dbUser) {
            return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(dbUser, "dbUser is required") });
        }

        /**
         * Return the given named metric for this DBCluster.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * The percentage of CPU utilization.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of database connections in use.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDatabaseConnections(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDatabaseConnections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The average number of deadlocks in the database per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDeadlocks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDeadlocks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of time that the instance has been running, in seconds.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricEngineUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricEngineUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of available random access memory, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeableMemory(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeableMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of local storage available, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeLocalStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeLocalStorage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput received from clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkReceiveThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkReceiveThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of network throughput sent to clients by each instance, in bytes per second.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNetworkTransmitThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNetworkTransmitThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSnapshotStorageUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSnapshotStorageUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total amount of backup storage in bytes for which you are billed.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalBackupStorageBilled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricTotalBackupStorageBilled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The amount of storage used by your Aurora DB instance, in bytes.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeBytesUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeBytesUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeReadIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeReadIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricVolumeWriteIOPs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricVolumeWriteIOPs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
