package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a user profile.
 * <p>
 * A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from IAM Identity Center , a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
 * <p>
 * <blockquote>
 * <p>
 * If you're using IAM Identity Center authentication, a user in IAM Identity Center , or a group in IAM Identity Center containing that user, must be assigned to the Amazon SageMaker Studio application from the IAM Identity Center Console to create a user profile. For more information about application assignment, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/assignuserstoapp.html">Assign user access</a> . After assignment is complete, a user profile can be created for that user in IAM Identity Center with AWS CloudFormation.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnUserProfile cfnUserProfile = CfnUserProfile.Builder.create(this, "MyCfnUserProfile")
 *         .domainId("domainId")
 *         .userProfileName("userProfileName")
 *         // the properties below are optional
 *         .singleSignOnUserIdentifier("singleSignOnUserIdentifier")
 *         .singleSignOnUserValue("singleSignOnUserValue")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userSettings(UserSettingsProperty.builder()
 *                 .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .defaultLandingUri("defaultLandingUri")
 *                 .executionRole("executionRole")
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
 *                         .accessStatus("accessStatus")
 *                         .userGroup("userGroup")
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .sharingSettings(SharingSettingsProperty.builder()
 *                         .notebookOutputOption("notebookOutputOption")
 *                         .s3KmsKeyId("s3KmsKeyId")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .studioWebPortal("studioWebPortal")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:39.723Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile")
public class CfnUserProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnUserProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnUserProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnUserProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the user profile, such as <code>arn:aws:sagemaker:region:account-id:user-profile/domain-id/user-profile-name</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUserProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrUserProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The domain ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainId() {
        return software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainId", java.util.Objects.requireNonNull(value, "domainId is required"));
    }

    /**
     * The user profile name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserProfileName() {
        return software.amazon.jsii.Kernel.get(this, "userProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user profile name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserProfileName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userProfileName", java.util.Objects.requireNonNull(value, "userProfileName is required"));
    }

    /**
     * A specifier for the type of value specified in SingleSignOnUserValue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSingleSignOnUserIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "singleSignOnUserIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A specifier for the type of value specified in SingleSignOnUserValue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSingleSignOnUserIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "singleSignOnUserIdentifier", value);
    }

    /**
     * The username of the associated AWS Single Sign-On User for this UserProfile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSingleSignOnUserValue() {
        return software.amazon.jsii.Kernel.get(this, "singleSignOnUserValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The username of the associated AWS Single Sign-On User for this UserProfile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSingleSignOnUserValue(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "singleSignOnUserValue", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserSettings() {
        return software.amazon.jsii.Kernel.get(this, "userSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userSettings", value);
    }

    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnUserProfile.UserSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "userSettings", value);
    }
    /**
     * The Code Editor application settings.
     * <p>
     * For more information about Code Editor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/code-editor.html">Get started with Code Editor in Amazon SageMaker</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CodeEditorAppSettingsProperty codeEditorAppSettingsProperty = CodeEditorAppSettingsProperty.builder()
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.CodeEditorAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeEditorAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeEditorAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html#cfn-sagemaker-userprofile-codeeditorappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html#cfn-sagemaker-userprofile-codeeditorappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html#cfn-sagemaker-userprofile-codeeditorappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-codeeditorappsettings.html#cfn-sagemaker-userprofile-codeeditorappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeEditorAppSettingsProperty> {
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnUserProfile.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeEditorAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeEditorAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeEditorAppSettingsProperty {
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.CodeEditorAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeEditorAppSettingsProperty.Jsii$Proxy that = (CodeEditorAppSettingsProperty.Jsii$Proxy) o;

                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0;
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A Git repository that SageMaker automatically displays to users for cloning in the JupyterServer application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CodeRepositoryProperty codeRepositoryProperty = CodeRepositoryProperty.builder()
     *         .repositoryUrl("repositoryUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-coderepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-coderepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the Git repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-coderepository.html#cfn-sagemaker-userprofile-coderepository-repositoryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-coderepository.html#cfn-sagemaker-userprofile-coderepository-repositoryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * @return a {@link Builder} of {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            java.lang.String repositoryUrl;

            /**
             * Sets the value of {@link CodeRepositoryProperty#getRepositoryUrl}
             * @param repositoryUrl The URL of the Git repository. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProperty {
            private final java.lang.String repositoryUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
            }

            @Override
            public final java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.CodeRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeRepositoryProperty.Jsii$Proxy that = (CodeRepositoryProperty.Jsii$Proxy) o;

                return this.repositoryUrl.equals(that.repositoryUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings for assigning a custom file system to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Permitted users can access this file system in Amazon SageMaker Studio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomFileSystemConfigProperty customFileSystemConfigProperty = CustomFileSystemConfigProperty.builder()
     *         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 // the properties below are optional
     *                 .fileSystemPath("fileSystemPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customfilesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customfilesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomFileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomFileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomFileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings for a custom Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customfilesystemconfig.html#cfn-sagemaker-userprofile-customfilesystemconfig-efsfilesystemconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customfilesystemconfig.html#cfn-sagemaker-userprofile-customfilesystemconfig-efsfilesystemconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsFileSystemConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomFileSystemConfigProperty> {
            java.lang.Object efsFileSystemConfig;

            /**
             * Sets the value of {@link CustomFileSystemConfigProperty#getEfsFileSystemConfig}
             * @param efsFileSystemConfig The settings for a custom Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystemConfig(software.amazon.awscdk.IResolvable efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomFileSystemConfigProperty#getEfsFileSystemConfig}
             * @param efsFileSystemConfig The settings for a custom Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystemConfig(software.amazon.awscdk.services.sagemaker.CfnUserProfile.EFSFileSystemConfigProperty efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomFileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomFileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomFileSystemConfigProperty {
            private final java.lang.Object efsFileSystemConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsFileSystemConfig = software.amazon.jsii.Kernel.get(this, "efsFileSystemConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsFileSystemConfig = builder.efsFileSystemConfig;
            }

            @Override
            public final java.lang.Object getEfsFileSystemConfig() {
                return this.efsFileSystemConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsFileSystemConfig() != null) {
                    data.set("efsFileSystemConfig", om.valueToTree(this.getEfsFileSystemConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomFileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomFileSystemConfigProperty.Jsii$Proxy that = (CustomFileSystemConfigProperty.Jsii$Proxy) o;

                return this.efsFileSystemConfig != null ? this.efsFileSystemConfig.equals(that.efsFileSystemConfig) : that.efsFileSystemConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsFileSystemConfig != null ? this.efsFileSystemConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A custom SageMaker image.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomImageProperty customImageProperty = CustomImageProperty.builder()
     *         .appImageConfigName("appImageConfigName")
     *         .imageName("imageName")
     *         // the properties below are optional
     *         .imageVersionNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomImageProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomImageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomImageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AppImageConfig.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-appimageconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-appimageconfigname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

        /**
         * The name of the CustomImage.
         * <p>
         * Must be unique to your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imagename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageName();

        /**
         * The version number of the CustomImage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imageversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imageversionnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImageVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomImageProperty> {
            java.lang.String appImageConfigName;
            java.lang.String imageName;
            java.lang.Number imageVersionNumber;

            /**
             * Sets the value of {@link CustomImageProperty#getAppImageConfigName}
             * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appImageConfigName(java.lang.String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageName}
             * @param imageName The name of the CustomImage. This parameter is required.
             *                  Must be unique to your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageName(java.lang.String imageName) {
                this.imageName = imageName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageVersionNumber}
             * @param imageVersionNumber The version number of the CustomImage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageVersionNumber(java.lang.Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomImageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomImageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomImageProperty {
            private final java.lang.String appImageConfigName;
            private final java.lang.String imageName;
            private final java.lang.Number imageVersionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageVersionNumber = software.amazon.jsii.Kernel.get(this, "imageVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
                this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
                this.imageVersionNumber = builder.imageVersionNumber;
            }

            @Override
            public final java.lang.String getAppImageConfigName() {
                return this.appImageConfigName;
            }

            @Override
            public final java.lang.String getImageName() {
                return this.imageName;
            }

            @Override
            public final java.lang.Number getImageVersionNumber() {
                return this.imageVersionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));
                data.set("imageName", om.valueToTree(this.getImageName()));
                if (this.getImageVersionNumber() != null) {
                    data.set("imageVersionNumber", om.valueToTree(this.getImageVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomImageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomImageProperty.Jsii$Proxy that = (CustomImageProperty.Jsii$Proxy) o;

                if (!appImageConfigName.equals(that.appImageConfigName)) return false;
                if (!imageName.equals(that.imageName)) return false;
                return this.imageVersionNumber != null ? this.imageVersionNumber.equals(that.imageVersionNumber) : that.imageVersionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appImageConfigName.hashCode();
                result = 31 * result + (this.imageName.hashCode());
                result = 31 * result + (this.imageVersionNumber != null ? this.imageVersionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about the POSIX identity that is used for file system operations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomPosixUserConfigProperty customPosixUserConfigProperty = CustomPosixUserConfigProperty.builder()
     *         .gid(123)
     *         .uid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomPosixUserConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPosixUserConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPosixUserConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The POSIX group ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html#cfn-sagemaker-userprofile-customposixuserconfig-gid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html#cfn-sagemaker-userprofile-customposixuserconfig-gid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getGid();

        /**
         * The POSIX user ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html#cfn-sagemaker-userprofile-customposixuserconfig-uid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customposixuserconfig.html#cfn-sagemaker-userprofile-customposixuserconfig-uid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getUid();

        /**
         * @return a {@link Builder} of {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPosixUserConfigProperty> {
            java.lang.Number gid;
            java.lang.Number uid;

            /**
             * Sets the value of {@link CustomPosixUserConfigProperty#getGid}
             * @param gid The POSIX group ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.Number gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link CustomPosixUserConfigProperty#getUid}
             * @param uid The POSIX user ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.Number uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPosixUserConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPosixUserConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPosixUserConfigProperty {
            private final java.lang.Number gid;
            private final java.lang.Number uid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gid = java.util.Objects.requireNonNull(builder.gid, "gid is required");
                this.uid = java.util.Objects.requireNonNull(builder.uid, "uid is required");
            }

            @Override
            public final java.lang.Number getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.Number getUid() {
                return this.uid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("gid", om.valueToTree(this.getGid()));
                data.set("uid", om.valueToTree(this.getUid()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.CustomPosixUserConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPosixUserConfigProperty.Jsii$Proxy that = (CustomPosixUserConfigProperty.Jsii$Proxy) o;

                if (!gid.equals(that.gid)) return false;
                return this.uid.equals(that.uid);
            }

            @Override
            public final int hashCode() {
                int result = this.gid.hashCode();
                result = 31 * result + (this.uid.hashCode());
                return result;
            }
        }
    }
    /**
     * A collection of default EBS storage settings that applies to private spaces created within a domain or user profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DefaultEbsStorageSettingsProperty defaultEbsStorageSettingsProperty = DefaultEbsStorageSettingsProperty.builder()
     *         .defaultEbsVolumeSizeInGb(123)
     *         .maximumEbsVolumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.DefaultEbsStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultEbsStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultEbsStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default size of the EBS storage volume for a private space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html#cfn-sagemaker-userprofile-defaultebsstoragesettings-defaultebsvolumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html#cfn-sagemaker-userprofile-defaultebsstoragesettings-defaultebsvolumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDefaultEbsVolumeSizeInGb();

        /**
         * The maximum size of the EBS storage volume for a private space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html#cfn-sagemaker-userprofile-defaultebsstoragesettings-maximumebsvolumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultebsstoragesettings.html#cfn-sagemaker-userprofile-defaultebsstoragesettings-maximumebsvolumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumEbsVolumeSizeInGb();

        /**
         * @return a {@link Builder} of {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultEbsStorageSettingsProperty> {
            java.lang.Number defaultEbsVolumeSizeInGb;
            java.lang.Number maximumEbsVolumeSizeInGb;

            /**
             * Sets the value of {@link DefaultEbsStorageSettingsProperty#getDefaultEbsVolumeSizeInGb}
             * @param defaultEbsVolumeSizeInGb The default size of the EBS storage volume for a private space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsVolumeSizeInGb(java.lang.Number defaultEbsVolumeSizeInGb) {
                this.defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link DefaultEbsStorageSettingsProperty#getMaximumEbsVolumeSizeInGb}
             * @param maximumEbsVolumeSizeInGb The maximum size of the EBS storage volume for a private space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEbsVolumeSizeInGb(java.lang.Number maximumEbsVolumeSizeInGb) {
                this.maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultEbsStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultEbsStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultEbsStorageSettingsProperty {
            private final java.lang.Number defaultEbsVolumeSizeInGb;
            private final java.lang.Number maximumEbsVolumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultEbsVolumeSizeInGb = software.amazon.jsii.Kernel.get(this, "defaultEbsVolumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumEbsVolumeSizeInGb = software.amazon.jsii.Kernel.get(this, "maximumEbsVolumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultEbsVolumeSizeInGb = java.util.Objects.requireNonNull(builder.defaultEbsVolumeSizeInGb, "defaultEbsVolumeSizeInGb is required");
                this.maximumEbsVolumeSizeInGb = java.util.Objects.requireNonNull(builder.maximumEbsVolumeSizeInGb, "maximumEbsVolumeSizeInGb is required");
            }

            @Override
            public final java.lang.Number getDefaultEbsVolumeSizeInGb() {
                return this.defaultEbsVolumeSizeInGb;
            }

            @Override
            public final java.lang.Number getMaximumEbsVolumeSizeInGb() {
                return this.maximumEbsVolumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultEbsVolumeSizeInGb", om.valueToTree(this.getDefaultEbsVolumeSizeInGb()));
                data.set("maximumEbsVolumeSizeInGb", om.valueToTree(this.getMaximumEbsVolumeSizeInGb()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.DefaultEbsStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultEbsStorageSettingsProperty.Jsii$Proxy that = (DefaultEbsStorageSettingsProperty.Jsii$Proxy) o;

                if (!defaultEbsVolumeSizeInGb.equals(that.defaultEbsVolumeSizeInGb)) return false;
                return this.maximumEbsVolumeSizeInGb.equals(that.maximumEbsVolumeSizeInGb);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultEbsVolumeSizeInGb.hashCode();
                result = 31 * result + (this.maximumEbsVolumeSizeInGb.hashCode());
                return result;
            }
        }
    }
    /**
     * The default storage settings for a private space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DefaultSpaceStorageSettingsProperty defaultSpaceStorageSettingsProperty = DefaultSpaceStorageSettingsProperty.builder()
     *         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
     *                 .defaultEbsVolumeSizeInGb(123)
     *                 .maximumEbsVolumeSizeInGb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultspacestoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultspacestoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.DefaultSpaceStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultSpaceStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultSpaceStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default EBS storage settings for a private space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultspacestoragesettings.html#cfn-sagemaker-userprofile-defaultspacestoragesettings-defaultebsstoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-defaultspacestoragesettings.html#cfn-sagemaker-userprofile-defaultspacestoragesettings-defaultebsstoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultEbsStorageSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultSpaceStorageSettingsProperty> {
            java.lang.Object defaultEbsStorageSettings;

            /**
             * Sets the value of {@link DefaultSpaceStorageSettingsProperty#getDefaultEbsStorageSettings}
             * @param defaultEbsStorageSettings The default EBS storage settings for a private space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsStorageSettings(software.amazon.awscdk.IResolvable defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceStorageSettingsProperty#getDefaultEbsStorageSettings}
             * @param defaultEbsStorageSettings The default EBS storage settings for a private space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsStorageSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.DefaultEbsStorageSettingsProperty defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultSpaceStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultSpaceStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultSpaceStorageSettingsProperty {
            private final java.lang.Object defaultEbsStorageSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultEbsStorageSettings = software.amazon.jsii.Kernel.get(this, "defaultEbsStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultEbsStorageSettings = builder.defaultEbsStorageSettings;
            }

            @Override
            public final java.lang.Object getDefaultEbsStorageSettings() {
                return this.defaultEbsStorageSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultEbsStorageSettings() != null) {
                    data.set("defaultEbsStorageSettings", om.valueToTree(this.getDefaultEbsStorageSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.DefaultSpaceStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultSpaceStorageSettingsProperty.Jsii$Proxy that = (DefaultSpaceStorageSettingsProperty.Jsii$Proxy) o;

                return this.defaultEbsStorageSettings != null ? this.defaultEbsStorageSettings.equals(that.defaultEbsStorageSettings) : that.defaultEbsStorageSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultEbsStorageSettings != null ? this.defaultEbsStorageSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for assigning a custom Amazon EFS file system to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EFSFileSystemConfigProperty eFSFileSystemConfigProperty = EFSFileSystemConfigProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         // the properties below are optional
     *         .fileSystemPath("fileSystemPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.EFSFileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EFSFileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EFSFileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of your Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html#cfn-sagemaker-userprofile-efsfilesystemconfig-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html#cfn-sagemaker-userprofile-efsfilesystemconfig-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * The path to the file system directory that is accessible in Amazon SageMaker Studio.
         * <p>
         * Permitted users can access only this directory and below.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html#cfn-sagemaker-userprofile-efsfilesystemconfig-filesystempath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-efsfilesystemconfig.html#cfn-sagemaker-userprofile-efsfilesystemconfig-filesystempath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EFSFileSystemConfigProperty> {
            java.lang.String fileSystemId;
            java.lang.String fileSystemPath;

            /**
             * Sets the value of {@link EFSFileSystemConfigProperty#getFileSystemId}
             * @param fileSystemId The ID of your Amazon EFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link EFSFileSystemConfigProperty#getFileSystemPath}
             * @param fileSystemPath The path to the file system directory that is accessible in Amazon SageMaker Studio.
             *                       Permitted users can access only this directory and below.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemPath(java.lang.String fileSystemPath) {
                this.fileSystemPath = fileSystemPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EFSFileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EFSFileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EFSFileSystemConfigProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.String fileSystemPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemPath = software.amazon.jsii.Kernel.get(this, "fileSystemPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
                this.fileSystemPath = builder.fileSystemPath;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.String getFileSystemPath() {
                return this.fileSystemPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                if (this.getFileSystemPath() != null) {
                    data.set("fileSystemPath", om.valueToTree(this.getFileSystemPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.EFSFileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EFSFileSystemConfigProperty.Jsii$Proxy that = (EFSFileSystemConfigProperty.Jsii$Proxy) o;

                if (!fileSystemId.equals(that.fileSystemId)) return false;
                return this.fileSystemPath != null ? this.fileSystemPath.equals(that.fileSystemPath) : that.fileSystemPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                result = 31 * result + (this.fileSystemPath != null ? this.fileSystemPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for the JupyterLab application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterLabAppSettingsProperty jupyterLabAppSettingsProperty = JupyterLabAppSettingsProperty.builder()
     *         .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                 .repositoryUrl("repositoryUrl")
     *                 .build()))
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.JupyterLabAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterLabAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterLabAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-coderepositories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-coderepositories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeRepositories() {
            return null;
        }

        /**
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
         * <p>
         * To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterlabappsettings.html#cfn-sagemaker-userprofile-jupyterlabappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterLabAppSettingsProperty> {
            java.lang.Object codeRepositories;
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(software.amazon.awscdk.IResolvable codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(java.util.List<? extends java.lang.Object> codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnUserProfile.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
             *                            To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterLabAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterLabAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterLabAppSettingsProperty {
            private final java.lang.Object codeRepositories;
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeRepositories = software.amazon.jsii.Kernel.get(this, "codeRepositories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeRepositories = builder.codeRepositories;
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getCodeRepositories() {
                return this.codeRepositories;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCodeRepositories() != null) {
                    data.set("codeRepositories", om.valueToTree(this.getCodeRepositories()));
                }
                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.JupyterLabAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterLabAppSettingsProperty.Jsii$Proxy that = (JupyterLabAppSettingsProperty.Jsii$Proxy) o;

                if (this.codeRepositories != null ? !this.codeRepositories.equals(that.codeRepositories) : that.codeRepositories != null) return false;
                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeRepositories != null ? this.codeRepositories.hashCode() : 0;
                result = 31 * result + (this.customImages != null ? this.customImages.hashCode() : 0);
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The JupyterServer app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterServerAppSettingsProperty jupyterServerAppSettingsProperty = JupyterServerAppSettingsProperty.builder()
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterServerAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterServerAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html#cfn-sagemaker-userprofile-jupyterserverappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html#cfn-sagemaker-userprofile-jupyterserverappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnUserProfile.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterServerAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterServerAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterServerAppSettingsProperty {
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.JupyterServerAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterServerAppSettingsProperty.Jsii$Proxy that = (JupyterServerAppSettingsProperty.Jsii$Proxy) o;

                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The KernelGateway app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelGatewayAppSettingsProperty kernelGatewayAppSettingsProperty = KernelGatewayAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelGatewayAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelGatewayAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a KernelGateway app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnUserProfile.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelGatewayAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelGatewayAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelGatewayAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.KernelGatewayAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelGatewayAppSettingsProperty.Jsii$Proxy that = (KernelGatewayAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RStudioServerProAppSettingsProperty rStudioServerProAppSettingsProperty = RStudioServerProAppSettingsProperty.builder()
     *         .accessStatus("accessStatus")
     *         .userGroup("userGroup")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.RStudioServerProAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RStudioServerProAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RStudioServerProAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html#cfn-sagemaker-userprofile-rstudioserverproappsettings-accessstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html#cfn-sagemaker-userprofile-rstudioserverproappsettings-accessstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessStatus() {
            return null;
        }

        /**
         * The level of permissions that the user has within the <code>RStudioServerPro</code> app.
         * <p>
         * This value defaults to <code>User</code>. The <code>Admin</code> value allows the user access to the RStudio Administrative Dashboard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html#cfn-sagemaker-userprofile-rstudioserverproappsettings-usergroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-rstudioserverproappsettings.html#cfn-sagemaker-userprofile-rstudioserverproappsettings-usergroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RStudioServerProAppSettingsProperty> {
            java.lang.String accessStatus;
            java.lang.String userGroup;

            /**
             * Sets the value of {@link RStudioServerProAppSettingsProperty#getAccessStatus}
             * @param accessStatus Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessStatus(java.lang.String accessStatus) {
                this.accessStatus = accessStatus;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProAppSettingsProperty#getUserGroup}
             * @param userGroup The level of permissions that the user has within the <code>RStudioServerPro</code> app.
             *                  This value defaults to <code>User</code>. The <code>Admin</code> value allows the user access to the RStudio Administrative Dashboard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userGroup(java.lang.String userGroup) {
                this.userGroup = userGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RStudioServerProAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RStudioServerProAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RStudioServerProAppSettingsProperty {
            private final java.lang.String accessStatus;
            private final java.lang.String userGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessStatus = software.amazon.jsii.Kernel.get(this, "accessStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userGroup = software.amazon.jsii.Kernel.get(this, "userGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessStatus = builder.accessStatus;
                this.userGroup = builder.userGroup;
            }

            @Override
            public final java.lang.String getAccessStatus() {
                return this.accessStatus;
            }

            @Override
            public final java.lang.String getUserGroup() {
                return this.userGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessStatus() != null) {
                    data.set("accessStatus", om.valueToTree(this.getAccessStatus()));
                }
                if (this.getUserGroup() != null) {
                    data.set("userGroup", om.valueToTree(this.getUserGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.RStudioServerProAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RStudioServerProAppSettingsProperty.Jsii$Proxy that = (RStudioServerProAppSettingsProperty.Jsii$Proxy) o;

                if (this.accessStatus != null ? !this.accessStatus.equals(that.accessStatus) : that.accessStatus != null) return false;
                return this.userGroup != null ? this.userGroup.equals(that.userGroup) : that.userGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessStatus != null ? this.accessStatus.hashCode() : 0;
                result = 31 * result + (this.userGroup != null ? this.userGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ResourceSpecProperty resourceSpecProperty = ResourceSpecProperty.builder()
     *         .instanceType("instanceType")
     *         .sageMakerImageArn("sageMakerImageArn")
     *         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.ResourceSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The instance type that the image version runs on.
         * <p>
         * <blockquote>
         * <p>
         * <em>JupyterServer apps</em> only support the <code>system</code> value.
         * <p>
         * For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The ARN of the SageMaker image that the image version belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimagearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimagearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageArn() {
            return null;
        }

        /**
         * The ARN of the image version created on the instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimageversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimageversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageVersionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            java.lang.String instanceType;
            java.lang.String sageMakerImageArn;
            java.lang.String sageMakerImageVersionArn;

            /**
             * Sets the value of {@link ResourceSpecProperty#getInstanceType}
             * @param instanceType The instance type that the image version runs on.
             *                     <blockquote>
             *                     <p>
             *                     <em>JupyterServer apps</em> only support the <code>system</code> value.
             *                     <p>
             *                     For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageArn}
             * @param sageMakerImageArn The ARN of the SageMaker image that the image version belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageArn(java.lang.String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageVersionArn}
             * @param sageMakerImageVersionArn The ARN of the image version created on the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageVersionArn(java.lang.String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSpecProperty {
            private final java.lang.String instanceType;
            private final java.lang.String sageMakerImageArn;
            private final java.lang.String sageMakerImageVersionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageVersionArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = builder.instanceType;
                this.sageMakerImageArn = builder.sageMakerImageArn;
                this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getSageMakerImageArn() {
                return this.sageMakerImageArn;
            }

            @Override
            public final java.lang.String getSageMakerImageVersionArn() {
                return this.sageMakerImageVersionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getSageMakerImageArn() != null) {
                    data.set("sageMakerImageArn", om.valueToTree(this.getSageMakerImageArn()));
                }
                if (this.getSageMakerImageVersionArn() != null) {
                    data.set("sageMakerImageVersionArn", om.valueToTree(this.getSageMakerImageVersionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.ResourceSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceSpecProperty.Jsii$Proxy that = (ResourceSpecProperty.Jsii$Proxy) o;

                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.sageMakerImageArn != null ? !this.sageMakerImageArn.equals(that.sageMakerImageArn) : that.sageMakerImageArn != null) return false;
                return this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.equals(that.sageMakerImageVersionArn) : that.sageMakerImageVersionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType != null ? this.instanceType.hashCode() : 0;
                result = 31 * result + (this.sageMakerImageArn != null ? this.sageMakerImageArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies options when sharing an Amazon SageMaker Studio notebook.
     * <p>
     * These settings are specified as part of <code>DefaultUserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> API is called, and as part of <code>UserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a> API is called.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SharingSettingsProperty sharingSettingsProperty = SharingSettingsProperty.builder()
     *         .notebookOutputOption("notebookOutputOption")
     *         .s3KmsKeyId("s3KmsKeyId")
     *         .s3OutputPath("s3OutputPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.SharingSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SharingSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharingSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to include the notebook cell output when sharing the notebook.
         * <p>
         * The default is <code>Disabled</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-notebookoutputoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-notebookoutputoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotebookOutputOption() {
            return null;
        }

        /**
         * When <code>NotebookOutputOption</code> is <code>Allowed</code> , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KmsKeyId() {
            return null;
        }

        /**
         * When <code>NotebookOutputOption</code> is <code>Allowed</code> , the Amazon S3 bucket used to store the shared notebook snapshots.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3outputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3outputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3OutputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharingSettingsProperty> {
            java.lang.String notebookOutputOption;
            java.lang.String s3KmsKeyId;
            java.lang.String s3OutputPath;

            /**
             * Sets the value of {@link SharingSettingsProperty#getNotebookOutputOption}
             * @param notebookOutputOption Whether to include the notebook cell output when sharing the notebook.
             *                             The default is <code>Disabled</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notebookOutputOption(java.lang.String notebookOutputOption) {
                this.notebookOutputOption = notebookOutputOption;
                return this;
            }

            /**
             * Sets the value of {@link SharingSettingsProperty#getS3KmsKeyId}
             * @param s3KmsKeyId When <code>NotebookOutputOption</code> is <code>Allowed</code> , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KmsKeyId(java.lang.String s3KmsKeyId) {
                this.s3KmsKeyId = s3KmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link SharingSettingsProperty#getS3OutputPath}
             * @param s3OutputPath When <code>NotebookOutputOption</code> is <code>Allowed</code> , the Amazon S3 bucket used to store the shared notebook snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputPath(java.lang.String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharingSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharingSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharingSettingsProperty {
            private final java.lang.String notebookOutputOption;
            private final java.lang.String s3KmsKeyId;
            private final java.lang.String s3OutputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.notebookOutputOption = software.amazon.jsii.Kernel.get(this, "notebookOutputOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KmsKeyId = software.amazon.jsii.Kernel.get(this, "s3KmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notebookOutputOption = builder.notebookOutputOption;
                this.s3KmsKeyId = builder.s3KmsKeyId;
                this.s3OutputPath = builder.s3OutputPath;
            }

            @Override
            public final java.lang.String getNotebookOutputOption() {
                return this.notebookOutputOption;
            }

            @Override
            public final java.lang.String getS3KmsKeyId() {
                return this.s3KmsKeyId;
            }

            @Override
            public final java.lang.String getS3OutputPath() {
                return this.s3OutputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNotebookOutputOption() != null) {
                    data.set("notebookOutputOption", om.valueToTree(this.getNotebookOutputOption()));
                }
                if (this.getS3KmsKeyId() != null) {
                    data.set("s3KmsKeyId", om.valueToTree(this.getS3KmsKeyId()));
                }
                if (this.getS3OutputPath() != null) {
                    data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.SharingSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharingSettingsProperty.Jsii$Proxy that = (SharingSettingsProperty.Jsii$Proxy) o;

                if (this.notebookOutputOption != null ? !this.notebookOutputOption.equals(that.notebookOutputOption) : that.notebookOutputOption != null) return false;
                if (this.s3KmsKeyId != null ? !this.s3KmsKeyId.equals(that.s3KmsKeyId) : that.s3KmsKeyId != null) return false;
                return this.s3OutputPath != null ? this.s3OutputPath.equals(that.s3OutputPath) : that.s3OutputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.notebookOutputOption != null ? this.notebookOutputOption.hashCode() : 0;
                result = 31 * result + (this.s3KmsKeyId != null ? this.s3KmsKeyId.hashCode() : 0);
                result = 31 * result + (this.s3OutputPath != null ? this.s3OutputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     * <p>
     * These settings are specified when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a> API is called, and as <code>DefaultUserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> API is called.
     * <p>
     * <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code> , the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * UserSettingsProperty userSettingsProperty = UserSettingsProperty.builder()
     *         .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
     *                 .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .fileSystemPath("fileSystemPath")
     *                         .build())
     *                 .build()))
     *         .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
     *                 .gid(123)
     *                 .uid(123)
     *                 .build())
     *         .defaultLandingUri("defaultLandingUri")
     *         .executionRole("executionRole")
     *         .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
     *                 .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                         .repositoryUrl("repositoryUrl")
     *                         .build()))
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
     *                 .accessStatus("accessStatus")
     *                 .userGroup("userGroup")
     *                 .build())
     *         .securityGroups(List.of("securityGroups"))
     *         .sharingSettings(SharingSettingsProperty.builder()
     *                 .notebookOutputOption("notebookOutputOption")
     *                 .s3KmsKeyId("s3KmsKeyId")
     *                 .s3OutputPath("s3OutputPath")
     *                 .build())
     *         .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
     *                 .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
     *                         .defaultEbsVolumeSizeInGb(123)
     *                         .maximumEbsVolumeSizeInGb(123)
     *                         .build())
     *                 .build())
     *         .studioWebPortal("studioWebPortal")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfile.UserSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(UserSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Code Editor application settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-codeeditorappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-codeeditorappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeEditorAppSettings() {
            return null;
        }

        /**
         * The settings for assigning a custom file system to a user profile.
         * <p>
         * Permitted users can access this file system in Amazon SageMaker Studio.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-customfilesystemconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-customfilesystemconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFileSystemConfigs() {
            return null;
        }

        /**
         * Details about the POSIX identity that is used for file system operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-customposixuserconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-customposixuserconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPosixUserConfig() {
            return null;
        }

        /**
         * The default experience that the user is directed to when accessing the domain. The supported values are:.
         * <p>
         * <ul>
         * <li><code>studio::</code> : Indicates that Studio is the default experience. This value can only be passed if <code>StudioWebPortal</code> is set to <code>ENABLED</code> .</li>
         * <li><code>app:JupyterServer:</code> : Indicates that Studio Classic is the default experience.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-defaultlandinguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-defaultlandinguri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultLandingUri() {
            return null;
        }

        /**
         * The execution role for the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
            return null;
        }

        /**
         * The settings for the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-jupyterlabappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-jupyterlabappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterLabAppSettings() {
            return null;
        }

        /**
         * The Jupyter server's app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-jupyterserverappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-jupyterserverappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterServerAppSettings() {
            return null;
        }

        /**
         * The kernel gateway app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-kernelgatewayappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-kernelgatewayappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayAppSettings() {
            return null;
        }

        /**
         * A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-rstudioserverproappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-rstudioserverproappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRStudioServerProAppSettings() {
            return null;
        }

        /**
         * The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         * <p>
         * Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>PublicInternetOnly</code> .
         * <p>
         * Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code> , unless specified as part of the <code>DefaultUserSettings</code> for the domain.
         * <p>
         * Amazon SageMaker adds a security group to allow NFS traffic from Amazon SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * Specifies options for sharing Amazon SageMaker Studio notebooks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-sharingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-sharingsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSharingSettings() {
            return null;
        }

        /**
         * The storage settings for a private space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-spacestoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-spacestoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceStorageSettings() {
            return null;
        }

        /**
         * Whether the user can access Studio.
         * <p>
         * If this value is set to <code>DISABLED</code> , the user cannot access Studio, even if that is the default experience for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-studiowebportal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-studiowebportal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStudioWebPortal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserSettingsProperty> {
            java.lang.Object codeEditorAppSettings;
            java.lang.Object customFileSystemConfigs;
            java.lang.Object customPosixUserConfig;
            java.lang.String defaultLandingUri;
            java.lang.String executionRole;
            java.lang.Object jupyterLabAppSettings;
            java.lang.Object jupyterServerAppSettings;
            java.lang.Object kernelGatewayAppSettings;
            java.lang.Object rStudioServerProAppSettings;
            java.util.List<java.lang.String> securityGroups;
            java.lang.Object sharingSettings;
            java.lang.Object spaceStorageSettings;
            java.lang.String studioWebPortal;

            /**
             * Sets the value of {@link UserSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.IResolvable codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.CodeEditorAppSettingsProperty codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a user profile.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(software.amazon.awscdk.IResolvable customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a user profile.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(java.util.List<? extends java.lang.Object> customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig Details about the POSIX identity that is used for file system operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.IResolvable customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig Details about the POSIX identity that is used for file system operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.services.sagemaker.CfnUserProfile.CustomPosixUserConfigProperty customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getDefaultLandingUri}
             * @param defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are:.
             *                          <ul>
             *                          <li><code>studio::</code> : Indicates that Studio is the default experience. This value can only be passed if <code>StudioWebPortal</code> is set to <code>ENABLED</code> .</li>
             *                          <li><code>app:JupyterServer:</code> : Indicates that Studio Classic is the default experience.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultLandingUri(java.lang.String defaultLandingUri) {
                this.defaultLandingUri = defaultLandingUri;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getExecutionRole}
             * @param executionRole The execution role for the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.JupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The Jupyter server's app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The Jupyter server's app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The kernel gateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The kernel gateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRStudioServerProAppSettings}
             * @param rStudioServerProAppSettings A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProAppSettings(software.amazon.awscdk.IResolvable rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRStudioServerProAppSettings}
             * @param rStudioServerProAppSettings A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProAppSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.RStudioServerProAppSettingsProperty rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSecurityGroups}
             * @param securityGroups The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
             *                       Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>PublicInternetOnly</code> .
             *                       <p>
             *                       Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code> , unless specified as part of the <code>DefaultUserSettings</code> for the domain.
             *                       <p>
             *                       Amazon SageMaker adds a security group to allow NFS traffic from Amazon SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSharingSettings}
             * @param sharingSettings Specifies options for sharing Amazon SageMaker Studio notebooks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharingSettings(software.amazon.awscdk.IResolvable sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSharingSettings}
             * @param sharingSettings Specifies options for sharing Amazon SageMaker Studio notebooks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharingSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.SharingSettingsProperty sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a private space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a private space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.DefaultSpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getStudioWebPortal}
             * @param studioWebPortal Whether the user can access Studio.
             *                        If this value is set to <code>DISABLED</code> , the user cannot access Studio, even if that is the default experience for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder studioWebPortal(java.lang.String studioWebPortal) {
                this.studioWebPortal = studioWebPortal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserSettingsProperty {
            private final java.lang.Object codeEditorAppSettings;
            private final java.lang.Object customFileSystemConfigs;
            private final java.lang.Object customPosixUserConfig;
            private final java.lang.String defaultLandingUri;
            private final java.lang.String executionRole;
            private final java.lang.Object jupyterLabAppSettings;
            private final java.lang.Object jupyterServerAppSettings;
            private final java.lang.Object kernelGatewayAppSettings;
            private final java.lang.Object rStudioServerProAppSettings;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object sharingSettings;
            private final java.lang.Object spaceStorageSettings;
            private final java.lang.String studioWebPortal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeEditorAppSettings = software.amazon.jsii.Kernel.get(this, "codeEditorAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customFileSystemConfigs = software.amazon.jsii.Kernel.get(this, "customFileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customPosixUserConfig = software.amazon.jsii.Kernel.get(this, "customPosixUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultLandingUri = software.amazon.jsii.Kernel.get(this, "defaultLandingUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jupyterLabAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterLabAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterServerAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterServerAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kernelGatewayAppSettings = software.amazon.jsii.Kernel.get(this, "kernelGatewayAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rStudioServerProAppSettings = software.amazon.jsii.Kernel.get(this, "rStudioServerProAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sharingSettings = software.amazon.jsii.Kernel.get(this, "sharingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spaceStorageSettings = software.amazon.jsii.Kernel.get(this, "spaceStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.studioWebPortal = software.amazon.jsii.Kernel.get(this, "studioWebPortal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeEditorAppSettings = builder.codeEditorAppSettings;
                this.customFileSystemConfigs = builder.customFileSystemConfigs;
                this.customPosixUserConfig = builder.customPosixUserConfig;
                this.defaultLandingUri = builder.defaultLandingUri;
                this.executionRole = builder.executionRole;
                this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
                this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
                this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
                this.rStudioServerProAppSettings = builder.rStudioServerProAppSettings;
                this.securityGroups = builder.securityGroups;
                this.sharingSettings = builder.sharingSettings;
                this.spaceStorageSettings = builder.spaceStorageSettings;
                this.studioWebPortal = builder.studioWebPortal;
            }

            @Override
            public final java.lang.Object getCodeEditorAppSettings() {
                return this.codeEditorAppSettings;
            }

            @Override
            public final java.lang.Object getCustomFileSystemConfigs() {
                return this.customFileSystemConfigs;
            }

            @Override
            public final java.lang.Object getCustomPosixUserConfig() {
                return this.customPosixUserConfig;
            }

            @Override
            public final java.lang.String getDefaultLandingUri() {
                return this.defaultLandingUri;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getJupyterLabAppSettings() {
                return this.jupyterLabAppSettings;
            }

            @Override
            public final java.lang.Object getJupyterServerAppSettings() {
                return this.jupyterServerAppSettings;
            }

            @Override
            public final java.lang.Object getKernelGatewayAppSettings() {
                return this.kernelGatewayAppSettings;
            }

            @Override
            public final java.lang.Object getRStudioServerProAppSettings() {
                return this.rStudioServerProAppSettings;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getSharingSettings() {
                return this.sharingSettings;
            }

            @Override
            public final java.lang.Object getSpaceStorageSettings() {
                return this.spaceStorageSettings;
            }

            @Override
            public final java.lang.String getStudioWebPortal() {
                return this.studioWebPortal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCodeEditorAppSettings() != null) {
                    data.set("codeEditorAppSettings", om.valueToTree(this.getCodeEditorAppSettings()));
                }
                if (this.getCustomFileSystemConfigs() != null) {
                    data.set("customFileSystemConfigs", om.valueToTree(this.getCustomFileSystemConfigs()));
                }
                if (this.getCustomPosixUserConfig() != null) {
                    data.set("customPosixUserConfig", om.valueToTree(this.getCustomPosixUserConfig()));
                }
                if (this.getDefaultLandingUri() != null) {
                    data.set("defaultLandingUri", om.valueToTree(this.getDefaultLandingUri()));
                }
                if (this.getExecutionRole() != null) {
                    data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                }
                if (this.getJupyterLabAppSettings() != null) {
                    data.set("jupyterLabAppSettings", om.valueToTree(this.getJupyterLabAppSettings()));
                }
                if (this.getJupyterServerAppSettings() != null) {
                    data.set("jupyterServerAppSettings", om.valueToTree(this.getJupyterServerAppSettings()));
                }
                if (this.getKernelGatewayAppSettings() != null) {
                    data.set("kernelGatewayAppSettings", om.valueToTree(this.getKernelGatewayAppSettings()));
                }
                if (this.getRStudioServerProAppSettings() != null) {
                    data.set("rStudioServerProAppSettings", om.valueToTree(this.getRStudioServerProAppSettings()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSharingSettings() != null) {
                    data.set("sharingSettings", om.valueToTree(this.getSharingSettings()));
                }
                if (this.getSpaceStorageSettings() != null) {
                    data.set("spaceStorageSettings", om.valueToTree(this.getSpaceStorageSettings()));
                }
                if (this.getStudioWebPortal() != null) {
                    data.set("studioWebPortal", om.valueToTree(this.getStudioWebPortal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfile.UserSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserSettingsProperty.Jsii$Proxy that = (UserSettingsProperty.Jsii$Proxy) o;

                if (this.codeEditorAppSettings != null ? !this.codeEditorAppSettings.equals(that.codeEditorAppSettings) : that.codeEditorAppSettings != null) return false;
                if (this.customFileSystemConfigs != null ? !this.customFileSystemConfigs.equals(that.customFileSystemConfigs) : that.customFileSystemConfigs != null) return false;
                if (this.customPosixUserConfig != null ? !this.customPosixUserConfig.equals(that.customPosixUserConfig) : that.customPosixUserConfig != null) return false;
                if (this.defaultLandingUri != null ? !this.defaultLandingUri.equals(that.defaultLandingUri) : that.defaultLandingUri != null) return false;
                if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
                if (this.jupyterLabAppSettings != null ? !this.jupyterLabAppSettings.equals(that.jupyterLabAppSettings) : that.jupyterLabAppSettings != null) return false;
                if (this.jupyterServerAppSettings != null ? !this.jupyterServerAppSettings.equals(that.jupyterServerAppSettings) : that.jupyterServerAppSettings != null) return false;
                if (this.kernelGatewayAppSettings != null ? !this.kernelGatewayAppSettings.equals(that.kernelGatewayAppSettings) : that.kernelGatewayAppSettings != null) return false;
                if (this.rStudioServerProAppSettings != null ? !this.rStudioServerProAppSettings.equals(that.rStudioServerProAppSettings) : that.rStudioServerProAppSettings != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.sharingSettings != null ? !this.sharingSettings.equals(that.sharingSettings) : that.sharingSettings != null) return false;
                if (this.spaceStorageSettings != null ? !this.spaceStorageSettings.equals(that.spaceStorageSettings) : that.spaceStorageSettings != null) return false;
                return this.studioWebPortal != null ? this.studioWebPortal.equals(that.studioWebPortal) : that.studioWebPortal == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeEditorAppSettings != null ? this.codeEditorAppSettings.hashCode() : 0;
                result = 31 * result + (this.customFileSystemConfigs != null ? this.customFileSystemConfigs.hashCode() : 0);
                result = 31 * result + (this.customPosixUserConfig != null ? this.customPosixUserConfig.hashCode() : 0);
                result = 31 * result + (this.defaultLandingUri != null ? this.defaultLandingUri.hashCode() : 0);
                result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
                result = 31 * result + (this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.hashCode() : 0);
                result = 31 * result + (this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.hashCode() : 0);
                result = 31 * result + (this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.hashCode() : 0);
                result = 31 * result + (this.rStudioServerProAppSettings != null ? this.rStudioServerProAppSettings.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.sharingSettings != null ? this.sharingSettings.hashCode() : 0);
                result = 31 * result + (this.spaceStorageSettings != null ? this.spaceStorageSettings.hashCode() : 0);
                result = 31 * result + (this.studioWebPortal != null ? this.studioWebPortal.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnUserProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnUserProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnUserProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnUserProfileProps.Builder();
        }

        /**
         * The domain ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid</a>
         * @param domainId The domain ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(final java.lang.String domainId) {
            this.props.domainId(domainId);
            return this;
        }

        /**
         * The user profile name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename</a>
         * @param userProfileName The user profile name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userProfileName(final java.lang.String userProfileName) {
            this.props.userProfileName(userProfileName);
            return this;
        }

        /**
         * A specifier for the type of value specified in SingleSignOnUserValue.
         * <p>
         * Currently, the only supported value is "UserName". If the Domain's AuthMode is IAM Identity Center , this field is required. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier</a>
         * @param singleSignOnUserIdentifier A specifier for the type of value specified in SingleSignOnUserValue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleSignOnUserIdentifier(final java.lang.String singleSignOnUserIdentifier) {
            this.props.singleSignOnUserIdentifier(singleSignOnUserIdentifier);
            return this;
        }

        /**
         * The username of the associated AWS Single Sign-On User for this UserProfile.
         * <p>
         * If the Domain's AuthMode is IAM Identity Center , this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue</a>
         * @param singleSignOnUserValue The username of the associated AWS Single Sign-On User for this UserProfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleSignOnUserValue(final java.lang.String singleSignOnUserValue) {
            this.props.singleSignOnUserValue(singleSignOnUserValue);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * Tags that you specify for the User Profile are also added to all apps that the User Profile launches.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A collection of settings that apply to users of Amazon SageMaker Studio.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings</a>
         * @param userSettings A collection of settings that apply to users of Amazon SageMaker Studio. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettings(final software.amazon.awscdk.IResolvable userSettings) {
            this.props.userSettings(userSettings);
            return this;
        }
        /**
         * A collection of settings that apply to users of Amazon SageMaker Studio.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings</a>
         * @param userSettings A collection of settings that apply to users of Amazon SageMaker Studio. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettings(final software.amazon.awscdk.services.sagemaker.CfnUserProfile.UserSettingsProperty userSettings) {
            this.props.userSettings(userSettings);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnUserProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnUserProfile build() {
            return new software.amazon.awscdk.services.sagemaker.CfnUserProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
