/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.codepipeline.CrossRegionSupport;
import software.amazon.awscdk.services.codepipeline.IPipeline;
import software.amazon.awscdk.services.codepipeline.IStage;
import software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions;
import software.amazon.awscdk.services.codepipeline.PipelineProps;
import software.amazon.awscdk.services.codepipeline.PipelineType;
import software.amazon.awscdk.services.codepipeline.StageOptions;
import software.amazon.awscdk.services.codepipeline.StageProps;
import software.amazon.awscdk.services.codepipeline.Trigger;
import software.amazon.awscdk.services.codepipeline.TriggerProps;
import software.amazon.awscdk.services.codepipeline.Variable;
import software.amazon.awscdk.services.codestarnotifications.INotificationRule;
import software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget;
import software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions;
import software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codepipeline.Pipeline")
public class Pipeline
extends Resource
implements IPipeline {
    protected Pipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Pipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Pipeline(@NotNull Construct scope, @NotNull String id, @Nullable PipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Pipeline(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IPipeline fromPipelineArn(@NotNull Construct scope, @NotNull String id, @NotNull String pipelineArn) {
        return (IPipeline)JsiiObject.jsiiStaticCall(Pipeline.class, (String)"fromPipelineArn", (NativeType)NativeType.forClass(IPipeline.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(pipelineArn, "pipelineArn is required")});
    }

    @NotNull
    public IStage addStage(@NotNull StageOptions props) {
        return (IStage)Kernel.call((Object)this, (String)"addStage", (NativeType)NativeType.forClass(IStage.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @NotNull
    public Trigger addTrigger(@NotNull TriggerProps props) {
        return (Trigger)((Object)Kernel.call((Object)this, (String)"addTrigger", (NativeType)NativeType.forClass(Trigger.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public Variable addVariable(@NotNull Variable variable) {
        return (Variable)((Object)Kernel.call((Object)this, (String)"addVariable", (NativeType)NativeType.forClass(Variable.class), (Object[])new Object[]{Objects.requireNonNull(variable, "variable is required")}));
    }

    @Override
    @NotNull
    public NotificationRuleSourceConfig bindAsNotificationRuleSource(@NotNull Construct _scope) {
        return (NotificationRuleSourceConfig)Kernel.call((Object)this, (String)"bindAsNotificationRuleSource", (NativeType)NativeType.forClass(NotificationRuleSourceConfig.class), (Object[])new Object[]{Objects.requireNonNull(_scope, "_scope is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOn(@NotNull String id, @NotNull INotificationRuleTarget target, @NotNull PipelineNotifyOnOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOn", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyActionStateChange(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyActionStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyActionStateChange(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyActionStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyManualApprovalStateChange(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyManualApprovalStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyManualApprovalStateChange(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyManualApprovalStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyStageStateChange(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyStageStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnAnyStageStateChange(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnAnyStageStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnExecutionStateChange(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnExecutionStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnExecutionStateChange(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnExecutionStateChange", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public IStage stage(@NotNull String stageName) {
        return (IStage)Kernel.call((Object)this, (String)"stage", (NativeType)NativeType.forClass(IStage.class), (Object[])new Object[]{Objects.requireNonNull(stageName, "stageName is required")});
    }

    @NotNull
    public IBucket getArtifactBucket() {
        return (IBucket)Kernel.get((Object)this, (String)"artifactBucket", (NativeType)NativeType.forClass(IBucket.class));
    }

    @NotNull
    public Map<String, CrossRegionSupport> getCrossRegionSupport() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"crossRegionSupport", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(CrossRegionSupport.class))));
    }

    @Override
    @NotNull
    public String getPipelineArn() {
        return (String)Kernel.get((Object)this, (String)"pipelineArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getPipelineName() {
        return (String)Kernel.get((Object)this, (String)"pipelineName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getPipelineVersion() {
        return (String)Kernel.get((Object)this, (String)"pipelineVersion", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @NotNull
    public Number getStageCount() {
        return (Number)Kernel.get((Object)this, (String)"stageCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public List<IStage> getStages() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"stages", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IStage.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Pipeline> {
        private final Construct scope;
        private final String id;
        private PipelineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder artifactBucket(IBucket artifactBucket) {
            this.props().artifactBucket(artifactBucket);
            return this;
        }

        public Builder crossAccountKeys(Boolean crossAccountKeys) {
            this.props().crossAccountKeys(crossAccountKeys);
            return this;
        }

        public Builder crossRegionReplicationBuckets(Map<String, ? extends IBucket> crossRegionReplicationBuckets) {
            this.props().crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        public Builder enableKeyRotation(Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        public Builder pipelineName(String pipelineName) {
            this.props().pipelineName(pipelineName);
            return this;
        }

        public Builder pipelineType(PipelineType pipelineType) {
            this.props().pipelineType(pipelineType);
            return this;
        }

        public Builder restartExecutionOnUpdate(Boolean restartExecutionOnUpdate) {
            this.props().restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder reuseCrossRegionSupportStacks(Boolean reuseCrossRegionSupportStacks) {
            this.props().reuseCrossRegionSupportStacks(reuseCrossRegionSupportStacks);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder stages(List<? extends StageProps> stages) {
            this.props().stages(stages);
            return this;
        }

        public Builder triggers(List<? extends TriggerProps> triggers) {
            this.props().triggers(triggers);
            return this;
        }

        public Builder variables(List<? extends Variable> variables) {
            this.props().variables(variables);
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private PipelineProps.Builder props() {
            if (this.props == null) {
                this.props = new PipelineProps.Builder();
            }
            return this.props;
        }
    }
}

