/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appconfig;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appconfig.ActionPoint;
import software.amazon.awscdk.services.appconfig.EnvironmentAttributes;
import software.amazon.awscdk.services.appconfig.EnvironmentProps;
import software.amazon.awscdk.services.appconfig.ExtensibleBase;
import software.amazon.awscdk.services.appconfig.ExtensionOptions;
import software.amazon.awscdk.services.appconfig.IApplication;
import software.amazon.awscdk.services.appconfig.IEnvironment;
import software.amazon.awscdk.services.appconfig.IEventDestination;
import software.amazon.awscdk.services.appconfig.IExtensible;
import software.amazon.awscdk.services.appconfig.IExtension;
import software.amazon.awscdk.services.appconfig.Monitor;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appconfig.Environment")
public class Environment
extends Resource
implements IEnvironment,
IExtensible {
    protected Environment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Environment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Environment(@NotNull Construct scope, @NotNull String id, @NotNull EnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEnvironment fromEnvironmentArn(@NotNull Construct scope, @NotNull String id, @NotNull String environmentArn) {
        return (IEnvironment)JsiiObject.jsiiStaticCall(Environment.class, (String)"fromEnvironmentArn", (NativeType)NativeType.forClass(IEnvironment.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(environmentArn, "environmentArn is required")});
    }

    @NotNull
    public static IEnvironment fromEnvironmentAttributes(@NotNull Construct scope, @NotNull String id, @NotNull EnvironmentAttributes attrs) {
        return (IEnvironment)JsiiObject.jsiiStaticCall(Environment.class, (String)"fromEnvironmentAttributes", (NativeType)NativeType.forClass(IEnvironment.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void addExtension(@NotNull IExtension extension) {
        Kernel.call((Object)this, (String)"addExtension", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(extension, "extension is required")});
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEnvironmentArn() {
        return (String)Kernel.get((Object)this, (String)"environmentArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEnvironmentId() {
        return (String)Kernel.get((Object)this, (String)"environmentId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IApplication getApplication() {
        return (IApplication)Kernel.get((Object)this, (String)"application", (NativeType)NativeType.forClass(IApplication.class));
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public List<Monitor> getMonitors() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"monitors", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Monitor.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected ExtensibleBase getExtensible() {
        return (ExtensibleBase)Kernel.get((Object)this, (String)"extensible", (NativeType)NativeType.forClass(ExtensibleBase.class));
    }

    protected void setExtensible(@NotNull ExtensibleBase value) {
        Kernel.set((Object)this, (String)"extensible", (Object)Objects.requireNonNull(value, "extensible is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Environment> {
        private final Construct scope;
        private final String id;
        private final EnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EnvironmentProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environmentName(String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        public Builder monitors(List<? extends Monitor> monitors) {
            this.props.monitors(monitors);
            return this;
        }

        public Builder application(IApplication application) {
            this.props.application(application);
            return this;
        }

        public Environment build() {
            return new Environment(this.scope, this.id, this.props.build());
        }
    }
}

