/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.BackupProps;
import software.amazon.awscdk.services.rds.Credentials;
import software.amazon.awscdk.services.rds.DBClusterStorageType;
import software.amazon.awscdk.services.rds.DatabaseClusterProps;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IClusterInstance;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.InstanceProps;
import software.amazon.awscdk.services.rds.InstanceUpdateBehaviour;
import software.amazon.awscdk.services.rds.NetworkType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.DatabaseClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseClusterProps
extends JsiiSerializable {
    @NotNull
    public IClusterEngine getEngine();

    @Nullable
    default public Duration getBacktrackWindow() {
        return null;
    }

    @Nullable
    default public BackupProps getBackup() {
        return null;
    }

    @Nullable
    default public List<String> getCloudwatchLogsExports() {
        return null;
    }

    @Nullable
    default public RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    @Nullable
    default public IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    @Nullable
    default public String getClusterIdentifier() {
        return null;
    }

    @Nullable
    default public Boolean getCopyTagsToSnapshot() {
        return null;
    }

    @Nullable
    default public Credentials getCredentials() {
        return null;
    }

    @Nullable
    default public String getDefaultDatabaseName() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public String getDomain() {
        return null;
    }

    @Nullable
    default public IRole getDomainRole() {
        return null;
    }

    @Nullable
    default public Boolean getIamAuthentication() {
        return null;
    }

    @Nullable
    default public String getInstanceIdentifierBase() {
        return null;
    }

    @Deprecated
    @Nullable
    default public InstanceProps getInstanceProps() {
        return null;
    }

    @Deprecated
    @Nullable
    default public Number getInstances() {
        return null;
    }

    @Nullable
    default public InstanceUpdateBehaviour getInstanceUpdateBehaviour() {
        return null;
    }

    @Nullable
    default public Duration getMonitoringInterval() {
        return null;
    }

    @Nullable
    default public IRole getMonitoringRole() {
        return null;
    }

    @Nullable
    default public NetworkType getNetworkType() {
        return null;
    }

    @Nullable
    default public IParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Map<String, String> getParameters() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public List<IClusterInstance> getReaders() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ExportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ExportRole() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ImportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ImportRole() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public Number getServerlessV2MaxCapacity() {
        return null;
    }

    @Nullable
    default public Number getServerlessV2MinCapacity() {
        return null;
    }

    @Nullable
    default public Boolean getStorageEncrypted() {
        return null;
    }

    @Nullable
    default public IKey getStorageEncryptionKey() {
        return null;
    }

    @Nullable
    default public DBClusterStorageType getStorageType() {
        return null;
    }

    @Nullable
    default public ISubnetGroup getSubnetGroup() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    @Nullable
    default public IClusterInstance getWriter() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        IClusterEngine engine;
        Duration backtrackWindow;
        BackupProps backup;
        List<String> cloudwatchLogsExports;
        RetentionDays cloudwatchLogsRetention;
        IRole cloudwatchLogsRetentionRole;
        String clusterIdentifier;
        Boolean copyTagsToSnapshot;
        Credentials credentials;
        String defaultDatabaseName;
        Boolean deletionProtection;
        String domain;
        IRole domainRole;
        Boolean iamAuthentication;
        String instanceIdentifierBase;
        InstanceProps instanceProps;
        Number instances;
        InstanceUpdateBehaviour instanceUpdateBehaviour;
        Duration monitoringInterval;
        IRole monitoringRole;
        NetworkType networkType;
        IParameterGroup parameterGroup;
        Map<String, String> parameters;
        Number port;
        String preferredMaintenanceWindow;
        List<IClusterInstance> readers;
        RemovalPolicy removalPolicy;
        List<IBucket> s3ExportBuckets;
        IRole s3ExportRole;
        List<IBucket> s3ImportBuckets;
        IRole s3ImportRole;
        List<ISecurityGroup> securityGroups;
        Number serverlessV2MaxCapacity;
        Number serverlessV2MinCapacity;
        Boolean storageEncrypted;
        IKey storageEncryptionKey;
        DBClusterStorageType storageType;
        ISubnetGroup subnetGroup;
        IVpc vpc;
        SubnetSelection vpcSubnets;
        IClusterInstance writer;

        public Builder engine(IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder backtrackWindow(Duration backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.backup = backup;
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainRole(IRole domainRole) {
            this.domainRole = domainRole;
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        @Deprecated
        public Builder instanceProps(InstanceProps instanceProps) {
            this.instanceProps = instanceProps;
            return this;
        }

        @Deprecated
        public Builder instances(Number instances) {
            this.instances = instances;
            return this;
        }

        public Builder instanceUpdateBehaviour(InstanceUpdateBehaviour instanceUpdateBehaviour) {
            this.instanceUpdateBehaviour = instanceUpdateBehaviour;
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder readers(List<? extends IClusterInstance> readers) {
            this.readers = readers;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder s3ExportBuckets(List<? extends IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = s3ExportBuckets;
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        public Builder s3ImportBuckets(List<? extends IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = s3ImportBuckets;
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder serverlessV2MaxCapacity(Number serverlessV2MaxCapacity) {
            this.serverlessV2MaxCapacity = serverlessV2MaxCapacity;
            return this;
        }

        public Builder serverlessV2MinCapacity(Number serverlessV2MinCapacity) {
            this.serverlessV2MinCapacity = serverlessV2MinCapacity;
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        public Builder storageType(DBClusterStorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public Builder writer(IClusterInstance writer) {
            this.writer = writer;
            return this;
        }

        public DatabaseClusterProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

