/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.ConfigureNatOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.CpuCredits;
import software.amazon.awscdk.services.ec2.GatewayConfig;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IKeyPair;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.NatInstanceProps;
import software.amazon.awscdk.services.ec2.NatProvider;
import software.amazon.awscdk.services.ec2.NatTrafficDirection;
import software.amazon.awscdk.services.ec2.PrivateSubnet;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.NatInstanceProviderV2")
public class NatInstanceProviderV2
extends NatProvider
implements IConnectable {
    protected NatInstanceProviderV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NatInstanceProviderV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NatInstanceProviderV2(@NotNull NatInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void configureNat(@NotNull ConfigureNatOptions options) {
        Kernel.call((Object)this, (String)"configureNat", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void configureSubnet(@NotNull PrivateSubnet subnet) {
        Kernel.call((Object)this, (String)"configureSubnet", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(subnet, "subnet is required")});
    }

    @Override
    @NotNull
    public List<GatewayConfig> getConfiguredGateways() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"configuredGateways", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(GatewayConfig.class))));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public ISecurityGroup getSecurityGroup() {
        return (ISecurityGroup)Kernel.get((Object)this, (String)"securityGroup", (NativeType)NativeType.forClass(ISecurityGroup.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NatInstanceProviderV2> {
        private final NatInstanceProps.Builder props = new NatInstanceProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder creditSpecification(CpuCredits creditSpecification) {
            this.props.creditSpecification(creditSpecification);
            return this;
        }

        public Builder defaultAllowedTraffic(NatTrafficDirection defaultAllowedTraffic) {
            this.props.defaultAllowedTraffic(defaultAllowedTraffic);
            return this;
        }

        @Deprecated
        public Builder keyName(String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        public Builder keyPair(IKeyPair keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public NatInstanceProviderV2 build() {
            return new NatInstanceProviderV2(this.props.build());
        }
    }
}

