/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kms;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.AliasAttributes;
import software.amazon.awscdk.services.kms.AliasProps;
import software.amazon.awscdk.services.kms.IAlias;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kms.Alias")
public class Alias
extends Resource
implements IAlias {
    protected Alias(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alias(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Alias(@NotNull Construct scope, @NotNull String id, @NotNull AliasProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAlias fromAliasAttributes(@NotNull Construct scope, @NotNull String id, @NotNull AliasAttributes attrs) {
        return (IAlias)JsiiObject.jsiiStaticCall(Alias.class, (String)"fromAliasAttributes", (NativeType)NativeType.forClass(IAlias.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IAlias fromAliasName(@NotNull Construct scope, @NotNull String id, @NotNull String aliasName) {
        return (IAlias)JsiiObject.jsiiStaticCall(Alias.class, (String)"fromAliasName", (NativeType)NativeType.forClass(IAlias.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(aliasName, "aliasName is required")});
    }

    @Override
    @NotNull
    public Alias addAlias(@NotNull String alias) {
        return (Alias)Kernel.call((Object)this, (String)"addAlias", (NativeType)NativeType.forClass(Alias.class), (Object[])new Object[]{Objects.requireNonNull(alias, "alias is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement, @Nullable Boolean allowNoOp) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required"), allowNoOp});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    protected String generatePhysicalName() {
        return (String)Kernel.call((Object)this, (String)"generatePhysicalName", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantDecrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantDecrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantEncrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantEncrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantEncryptDecrypt(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantEncryptDecrypt", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantGenerateMac(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantGenerateMac", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantVerifyMac(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantVerifyMac", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @NotNull
    public String getAliasArn() {
        return (String)Kernel.get((Object)this, (String)"aliasArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getAliasName() {
        return (String)Kernel.get((Object)this, (String)"aliasName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IKey getAliasTargetKey() {
        return (IKey)Kernel.get((Object)this, (String)"aliasTargetKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Deprecated
    @NotNull
    public String getKeyArn() {
        return (String)Kernel.get((Object)this, (String)"keyArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getKeyId() {
        return (String)Kernel.get((Object)this, (String)"keyId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Alias> {
        private final Construct scope;
        private final String id;
        private final AliasProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AliasProps.Builder();
        }

        public Builder aliasName(String aliasName) {
            this.props.aliasName(aliasName);
            return this;
        }

        public Builder targetKey(IKey targetKey) {
            this.props.targetKey(targetKey);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Alias build() {
            return new Alias(this.scope, this.id, this.props.build());
        }
    }
}

