/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda_event_sources.S3EventSourceV2")
public class S3EventSourceV2
extends JsiiObject
implements IEventSource {
    protected S3EventSourceV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3EventSourceV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3EventSourceV2(@NotNull IBucket bucket, @NotNull S3EventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void bind(@NotNull IFunction target) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3EventSourceV2> {
        private final IBucket bucket;
        private final S3EventSourceProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
            this.props = new S3EventSourceProps.Builder();
        }

        public Builder events(List<? extends EventType> events) {
            this.props.events(events);
            return this;
        }

        public Builder filters(List<? extends NotificationKeyFilter> filters) {
            this.props.filters(filters);
            return this;
        }

        public S3EventSourceV2 build() {
            return new S3EventSourceV2(this.bucket, this.props.build());
        }
    }
}

