package software.amazon.awscdk;

/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.constructs.Construct;
 * import software.constructs.IConstruct;
 * public class MyAspect implements IAspect {
 *     public void visit(IConstruct node) {
 *         if (node instanceof CfnResource &amp;&amp; node.getCfnResourceType() == "Foo::Bar") {
 *             this.error(node, "we do not want a Foo::Bar resource");
 *         }
 *     }
 *     public void error(IConstruct node, String message) {
 *         Annotations.of(node).addError(message);
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         Stack stack = new Stack();
 *         CfnResource.Builder.create(stack, "Foo")
 *                 .type("Foo::Bar")
 *                 .properties(Map.of(
 *                         "Fred", "Thud"))
 *                 .build();
 *         Aspects.of(stack).add(new MyAspect());
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:48.965Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Aspects")
public class Aspects extends software.amazon.jsii.JsiiObject {

    protected Aspects(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Aspects(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the <code>Aspects</code> object associated with a construct scope.
     * <p>
     * @param scope The scope for which these aspects will apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Aspects of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Aspects.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Aspects.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Adds an aspect to apply this scope before synthesis.
     * <p>
     * @param aspect The aspect to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void add(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IAspect aspect) {
        software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(aspect, "aspect is required") });
    }

    /**
     * The list of aspects which were directly applied on this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.IAspect> getAll() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IAspect.class))));
    }
}
