package software.amazon.awscdk;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnMapping regionTable = CfnMapping.Builder.create(this, "RegionTable")
 *         .mapping(Map.of(
 *                 "us-east-1", Map.of(
 *                         "regionName", "US East (N. Virginia)"),
 *                 "us-east-2", Map.of(
 *                         "regionName", "US East (Ohio)")))
 *         .lazy(true)
 *         .build();
 * regionTable.findInMap("us-east-2", "regionName");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.010Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnMappingProps")
@software.amazon.jsii.Jsii.Proxy(CfnMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLazy() {
        return null;
    }

    /**
     * Mapping of key to a set of corresponding set of named values.
     * <p>
     * The key identifies a map of name-value pairs and must be unique within the mapping.
     * <p>
     * For example, if you want to set values based on a region, you can create a mapping
     * that uses the region name as a key and contains the values you want to specify for
     * each specific region.
     * <p>
     * Default: - No mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getMapping() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMappingProps> {
        java.lang.Boolean lazy;
        java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> mapping;

        /**
         * Sets the value of {@link CfnMappingProps#getLazy}
         * @param lazy the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lazy(java.lang.Boolean lazy) {
            this.lazy = lazy;
            return this;
        }

        /**
         * Sets the value of {@link CfnMappingProps#getMapping}
         * @param mapping Mapping of key to a set of corresponding set of named values.
         *                The key identifies a map of name-value pairs and must be unique within the mapping.
         *                <p>
         *                For example, if you want to set values based on a region, you can create a mapping
         *                that uses the region name as a key and contains the values you want to specify for
         *                each specific region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder mapping(java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> mapping) {
            this.mapping = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)mapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMappingProps {
        private final java.lang.Boolean lazy;
        private final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> mapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lazy = software.amazon.jsii.Kernel.get(this, "lazy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lazy = builder.lazy;
            this.mapping = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)builder.mapping;
        }

        @Override
        public final java.lang.Boolean getLazy() {
            return this.lazy;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getMapping() {
            return this.mapping;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLazy() != null) {
                data.set("lazy", om.valueToTree(this.getLazy()));
            }
            if (this.getMapping() != null) {
                data.set("mapping", om.valueToTree(this.getMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMappingProps.Jsii$Proxy that = (CfnMappingProps.Jsii$Proxy) o;

            if (this.lazy != null ? !this.lazy.equals(that.lazy) : that.lazy != null) return false;
            return this.mapping != null ? this.mapping.equals(that.mapping) : that.mapping == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lazy != null ? this.lazy.hashCode() : 0;
            result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
            return result;
        }
    }
}
