package software.amazon.awscdk;

/**
 * Properties for defining a <code>CfnPublicTypeVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnPublicTypeVersionProps cfnPublicTypeVersionProps = CfnPublicTypeVersionProps.builder()
 *         .arn("arn")
 *         .logDeliveryBucket("logDeliveryBucket")
 *         .publicVersionNumber("publicVersionNumber")
 *         .type("type")
 *         .typeName("typeName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.020Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnPublicTypeVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnPublicTypeVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPublicTypeVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Number (ARN) of the extension.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-arn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
        return null;
    }

    /**
     * The S3 bucket to which CloudFormation delivers the contract test execution logs.
     * <p>
     * CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of <code>PASSED</code> or <code>FAILED</code> .
     * <p>
     * The user initiating the stack operation must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:
     * <p>
     * <ul>
     * <li>GetObject</li>
     * <li>PutObject</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-logdeliverybucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-logdeliverybucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDeliveryBucket() {
        return null;
    }

    /**
     * The version number to assign to this version of the extension.
     * <p>
     * Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
     * <p>
     * <code>MAJOR.MINOR.PATCH</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning 2.0.0</a> .
     * <p>
     * If you don't specify a version number, CloudFormation increments the version number by one minor version release.
     * <p>
     * You cannot specify a version number the first time you publish a type. AWS CloudFormation automatically sets the first version number to be <code>1.0.0</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-publicversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-publicversionnumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicVersionNumber() {
        return null;
    }

    /**
     * The type of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * The name of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-publictypeversion.html#cfn-cloudformation-publictypeversion-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPublicTypeVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPublicTypeVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPublicTypeVersionProps> {
        java.lang.String arn;
        java.lang.String logDeliveryBucket;
        java.lang.String publicVersionNumber;
        java.lang.String type;
        java.lang.String typeName;

        /**
         * Sets the value of {@link CfnPublicTypeVersionProps#getArn}
         * @param arn The Amazon Resource Number (ARN) of the extension.
         *            Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicTypeVersionProps#getLogDeliveryBucket}
         * @param logDeliveryBucket The S3 bucket to which CloudFormation delivers the contract test execution logs.
         *                          CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of <code>PASSED</code> or <code>FAILED</code> .
         *                          <p>
         *                          The user initiating the stack operation must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:
         *                          <p>
         *                          <ul>
         *                          <li>GetObject</li>
         *                          <li>PutObject</li>
         *                          </ul>
         *                          <p>
         *                          For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryBucket(java.lang.String logDeliveryBucket) {
            this.logDeliveryBucket = logDeliveryBucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicTypeVersionProps#getPublicVersionNumber}
         * @param publicVersionNumber The version number to assign to this version of the extension.
         *                            Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
         *                            <p>
         *                            <code>MAJOR.MINOR.PATCH</code>
         *                            <p>
         *                            For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning 2.0.0</a> .
         *                            <p>
         *                            If you don't specify a version number, CloudFormation increments the version number by one minor version release.
         *                            <p>
         *                            You cannot specify a version number the first time you publish a type. AWS CloudFormation automatically sets the first version number to be <code>1.0.0</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicVersionNumber(java.lang.String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicTypeVersionProps#getType}
         * @param type The type of the extension to test.
         *             Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicTypeVersionProps#getTypeName}
         * @param typeName The name of the extension to test.
         *                 Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPublicTypeVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPublicTypeVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPublicTypeVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPublicTypeVersionProps {
        private final java.lang.String arn;
        private final java.lang.String logDeliveryBucket;
        private final java.lang.String publicVersionNumber;
        private final java.lang.String type;
        private final java.lang.String typeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDeliveryBucket = software.amazon.jsii.Kernel.get(this, "logDeliveryBucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicVersionNumber = software.amazon.jsii.Kernel.get(this, "publicVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = builder.arn;
            this.logDeliveryBucket = builder.logDeliveryBucket;
            this.publicVersionNumber = builder.publicVersionNumber;
            this.type = builder.type;
            this.typeName = builder.typeName;
        }

        @Override
        public final java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public final java.lang.String getLogDeliveryBucket() {
            return this.logDeliveryBucket;
        }

        @Override
        public final java.lang.String getPublicVersionNumber() {
            return this.publicVersionNumber;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArn() != null) {
                data.set("arn", om.valueToTree(this.getArn()));
            }
            if (this.getLogDeliveryBucket() != null) {
                data.set("logDeliveryBucket", om.valueToTree(this.getLogDeliveryBucket()));
            }
            if (this.getPublicVersionNumber() != null) {
                data.set("publicVersionNumber", om.valueToTree(this.getPublicVersionNumber()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getTypeName() != null) {
                data.set("typeName", om.valueToTree(this.getTypeName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnPublicTypeVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPublicTypeVersionProps.Jsii$Proxy that = (CfnPublicTypeVersionProps.Jsii$Proxy) o;

            if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
            if (this.logDeliveryBucket != null ? !this.logDeliveryBucket.equals(that.logDeliveryBucket) : that.logDeliveryBucket != null) return false;
            if (this.publicVersionNumber != null ? !this.publicVersionNumber.equals(that.publicVersionNumber) : that.publicVersionNumber != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.typeName != null ? this.typeName.equals(that.typeName) : that.typeName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.arn != null ? this.arn.hashCode() : 0;
            result = 31 * result + (this.logDeliveryBucket != null ? this.logDeliveryBucket.hashCode() : 0);
            result = 31 * result + (this.publicVersionNumber != null ? this.publicVersionNumber.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            return result;
        }
    }
}
