package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Properties to initialize HttpTokenAuthorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * HttpLambdaAuthorizer authorizer = HttpLambdaAuthorizer.Builder.create("BooksAuthorizer", authHandler)
 *         .responseTypes(List.of(HttpLambdaResponseType.SIMPLE))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(HttpLambdaAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpLambdaAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Friendly authorizer name.
     * <p>
     * Default: - same value as `id` passed in the constructor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The identity source for which authorization is requested.
     * <p>
     * Default: ['$request.header.Authorization']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentitySource() {
        return null;
    }

    /**
     * The types of responses the lambda can return.
     * <p>
     * If HttpLambdaResponseType.SIMPLE is included then
     * response format 2.0 will be used.
     * <p>
     * Default: [HttpLambdaResponseType.IAM]
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> getResponseTypes() {
        return null;
    }

    /**
     * How long APIGateway should cache the results.
     * <p>
     * Max 1 hour.
     * Disable caching by setting this to <code>Duration.seconds(0)</code>.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getResultsCacheTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpLambdaAuthorizerProps> {
        java.lang.String authorizerName;
        java.util.List<java.lang.String> identitySource;
        java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> responseTypes;
        software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Sets the value of {@link HttpLambdaAuthorizerProps#getAuthorizerName}
         * @param authorizerName Friendly authorizer name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpLambdaAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link HttpLambdaAuthorizerProps#getResponseTypes}
         * @param responseTypes The types of responses the lambda can return.
         *                      If HttpLambdaResponseType.SIMPLE is included then
         *                      response format 2.0 will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder responseTypes(java.util.List<? extends software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> responseTypes) {
            this.responseTypes = (java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType>)responseTypes;
            return this;
        }

        /**
         * Sets the value of {@link HttpLambdaAuthorizerProps#getResultsCacheTtl}
         * @param resultsCacheTtl How long APIGateway should cache the results.
         *                        Max 1 hour.
         *                        Disable caching by setting this to <code>Duration.seconds(0)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(software.amazon.awscdk.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpLambdaAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpLambdaAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpLambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpLambdaAuthorizerProps {
        private final java.lang.String authorizerName;
        private final java.util.List<java.lang.String> identitySource;
        private final java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> responseTypes;
        private final software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.responseTypes = software.amazon.jsii.Kernel.get(this, "responseTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType.class)));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerName = builder.authorizerName;
            this.identitySource = builder.identitySource;
            this.responseTypes = (java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType>)builder.responseTypes;
            this.resultsCacheTtl = builder.resultsCacheTtl;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> getResponseTypes() {
            return this.responseTypes;
        }

        @Override
        public final software.amazon.awscdk.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }
            if (this.getResponseTypes() != null) {
                data.set("responseTypes", om.valueToTree(this.getResponseTypes()));
            }
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpLambdaAuthorizerProps.Jsii$Proxy that = (HttpLambdaAuthorizerProps.Jsii$Proxy) o;

            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            if (this.identitySource != null ? !this.identitySource.equals(that.identitySource) : that.identitySource != null) return false;
            if (this.responseTypes != null ? !this.responseTypes.equals(that.responseTypes) : that.responseTypes != null) return false;
            return this.resultsCacheTtl != null ? this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerName != null ? this.authorizerName.hashCode() : 0;
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            result = 31 * result + (this.responseTypes != null ? this.responseTypes.hashCode() : 0);
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            return result;
        }
    }
}
