package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * AWS WebSocket AWS Type Integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration;
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role apiRole;
 * Table table;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("$connect", WebSocketRouteOptions.builder()
 *         .integration(WebSocketAwsIntegration.Builder.create("DynamodbPutItem")
 *                 .integrationUri(String.format("arn:aws:apigateway:%s:dynamodb:action/PutItem", this.region))
 *                 .integrationMethod(HttpMethod.POST)
 *                 .credentialsRole(apiRole)
 *                 .requestTemplates(Map.of(
 *                         "application/json", JSON.stringify(Map.of(
 *                                 "TableName", table.getTableName(),
 *                                 "Item", Map.of(
 *                                         "id", Map.of(
 *                                                 "S", "$context.requestId"))))))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.771Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.WebSocketAwsIntegration")
public class WebSocketAwsIntegration extends software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration {

    protected WebSocketAwsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketAwsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketAwsIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegrationProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegrationProps.Builder();
        }

        /**
         * Specifies the integration's HTTP method type.
         * <p>
         * @return {@code this}
         * @param integrationMethod Specifies the integration's HTTP method type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationMethod(final java.lang.String integrationMethod) {
            this.props.integrationMethod(integrationMethod);
            return this;
        }

        /**
         * Integration URI.
         * <p>
         * @return {@code this}
         * @param integrationUri Integration URI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(final java.lang.String integrationUri) {
            this.props.integrationUri(integrationUri);
            return this;
        }

        /**
         * Specifies the credentials role required for the integration.
         * <p>
         * Default: - No credential role provided.
         * <p>
         * @return {@code this}
         * @param credentialsRole Specifies the credentials role required for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.props.credentialsRole(credentialsRole);
            return this;
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * <p>
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         * <p>
         * Default: - No passthrough behavior required.
         * <p>
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior) {
            this.props.passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * <p>
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * <p>
         * Default: - No request parameter provided to the integration.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * <p>
         * <blockquote><pre>
         *   { "application/json": "{ \"statusCode\": 200 }" }
         * </pre></blockquote>
         * <p>
         * Default: - No request template provided to the integration.
         * <p>
         * @return {@code this}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.props.requestTemplates(requestTemplates);
            return this;
        }

        /**
         * The template selection expression for the integration.
         * <p>
         * Default: - No template selection expression provided.
         * <p>
         * @return {@code this}
         * @param templateSelectionExpression The template selection expression for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(final java.lang.String templateSelectionExpression) {
            this.props.templateSelectionExpression(templateSelectionExpression);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration(
                this.id,
                this.props.build()
            );
        }
    }
}
