package software.amazon.awscdk.customresources;

/**
 * Physical ID of the custom resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource getParameter = AwsCustomResource.Builder.create(this, "AssociateVPCWithHostedZone")
 *         .onCreate(AwsSdkCall.builder()
 *                 .assumedRoleArn("arn:aws:iam::OTHERACCOUNT:role/CrossAccount/ManageHostedZoneConnections")
 *                 .service("Route53")
 *                 .action("AssociateVPCWithHostedZone")
 *                 .parameters(Map.of(
 *                         "HostedZoneId", "hz-123",
 *                         "VPC", Map.of(
 *                                 "VPCId", "vpc-123",
 *                                 "VPCRegion", "region-for-vpc")))
 *                 .physicalResourceId(PhysicalResourceId.of("${vpcStack.SharedVpc.VpcId}-${vpcStack.Region}-${PrivateHostedZone.HostedZoneId}"))
 *                 .build())
 *         //Will ignore any resource and use the assumedRoleArn as resource and 'sts:AssumeRole' for service:action
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:03.076Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.PhysicalResourceId")
public class PhysicalResourceId extends software.amazon.jsii.JsiiObject {

    protected PhysicalResourceId(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PhysicalResourceId(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Extract the physical resource id from the path (dot notation) to the data in the API call response.
     * <p>
     * @param responsePath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.PhysicalResourceId fromResponse(final @org.jetbrains.annotations.NotNull java.lang.String responsePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.PhysicalResourceId.class, "fromResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class), new Object[] { java.util.Objects.requireNonNull(responsePath, "responsePath is required") });
    }

    /**
     * Explicit physical resource id.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.PhysicalResourceId of(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.PhysicalResourceId.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Literal string to be used as the physical id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Path to a response data element to be used as the physical id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResponsePath() {
        return software.amazon.jsii.Kernel.get(this, "responsePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
