package software.amazon.awscdk.pipelines;

/**
 * Options for defining credentials for a Docker Credential.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecret dockerHubSecret = Secret.fromSecretCompleteArn(this, "DHSecret", "arn:aws:...");
 * // Only the image asset publishing actions will be granted read access to the secret.
 * DockerCredential creds = DockerCredential.dockerHub(dockerHubSecret, ExternalDockerCredentialOptions.builder().usages(List.of(DockerCredentialUsage.ASSET_PUBLISHING)).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:03.151Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ExternalDockerCredentialOptions")
@software.amazon.jsii.Jsii.Proxy(ExternalDockerCredentialOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExternalDockerCredentialOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * An IAM role to assume prior to accessing the secret.
     * <p>
     * Default: - none. The current execution role will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAssumeRole() {
        return null;
    }

    /**
     * The name of the JSON field of the secret which contains the secret/password.
     * <p>
     * Default: 'secret'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretPasswordField() {
        return null;
    }

    /**
     * The name of the JSON field of the secret which contains the user/login name.
     * <p>
     * Default: 'username'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretUsernameField() {
        return null;
    }

    /**
     * Defines which stages of the pipeline should be granted access to these credentials.
     * <p>
     * Default: - all relevant stages (synth, self-update, asset publishing) are granted access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> getUsages() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExternalDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExternalDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExternalDockerCredentialOptions> {
        software.amazon.awscdk.services.iam.IRole assumeRole;
        java.lang.String secretPasswordField;
        java.lang.String secretUsernameField;
        java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> usages;

        /**
         * Sets the value of {@link ExternalDockerCredentialOptions#getAssumeRole}
         * @param assumeRole An IAM role to assume prior to accessing the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        /**
         * Sets the value of {@link ExternalDockerCredentialOptions#getSecretPasswordField}
         * @param secretPasswordField The name of the JSON field of the secret which contains the secret/password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretPasswordField(java.lang.String secretPasswordField) {
            this.secretPasswordField = secretPasswordField;
            return this;
        }

        /**
         * Sets the value of {@link ExternalDockerCredentialOptions#getSecretUsernameField}
         * @param secretUsernameField The name of the JSON field of the secret which contains the user/login name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretUsernameField(java.lang.String secretUsernameField) {
            this.secretUsernameField = secretUsernameField;
            return this;
        }

        /**
         * Sets the value of {@link ExternalDockerCredentialOptions#getUsages}
         * @param usages Defines which stages of the pipeline should be granted access to these credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder usages(java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredentialUsage> usages) {
            this.usages = (java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage>)usages;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExternalDockerCredentialOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExternalDockerCredentialOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExternalDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExternalDockerCredentialOptions {
        private final software.amazon.awscdk.services.iam.IRole assumeRole;
        private final java.lang.String secretPasswordField;
        private final java.lang.String secretUsernameField;
        private final java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> usages;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assumeRole = software.amazon.jsii.Kernel.get(this, "assumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.secretPasswordField = software.amazon.jsii.Kernel.get(this, "secretPasswordField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretUsernameField = software.amazon.jsii.Kernel.get(this, "secretUsernameField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.usages = software.amazon.jsii.Kernel.get(this, "usages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DockerCredentialUsage.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assumeRole = builder.assumeRole;
            this.secretPasswordField = builder.secretPasswordField;
            this.secretUsernameField = builder.secretUsernameField;
            this.usages = (java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage>)builder.usages;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAssumeRole() {
            return this.assumeRole;
        }

        @Override
        public final java.lang.String getSecretPasswordField() {
            return this.secretPasswordField;
        }

        @Override
        public final java.lang.String getSecretUsernameField() {
            return this.secretUsernameField;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> getUsages() {
            return this.usages;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssumeRole() != null) {
                data.set("assumeRole", om.valueToTree(this.getAssumeRole()));
            }
            if (this.getSecretPasswordField() != null) {
                data.set("secretPasswordField", om.valueToTree(this.getSecretPasswordField()));
            }
            if (this.getSecretUsernameField() != null) {
                data.set("secretUsernameField", om.valueToTree(this.getSecretUsernameField()));
            }
            if (this.getUsages() != null) {
                data.set("usages", om.valueToTree(this.getUsages()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ExternalDockerCredentialOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExternalDockerCredentialOptions.Jsii$Proxy that = (ExternalDockerCredentialOptions.Jsii$Proxy) o;

            if (this.assumeRole != null ? !this.assumeRole.equals(that.assumeRole) : that.assumeRole != null) return false;
            if (this.secretPasswordField != null ? !this.secretPasswordField.equals(that.secretPasswordField) : that.secretPasswordField != null) return false;
            if (this.secretUsernameField != null ? !this.secretUsernameField.equals(that.secretUsernameField) : that.secretUsernameField != null) return false;
            return this.usages != null ? this.usages.equals(that.usages) : that.usages == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assumeRole != null ? this.assumeRole.hashCode() : 0;
            result = 31 * result + (this.secretPasswordField != null ? this.secretPasswordField.hashCode() : 0);
            result = 31 * result + (this.secretUsernameField != null ? this.secretUsernameField.hashCode() : 0);
            result = 31 * result + (this.usages != null ? this.usages.hashCode() : 0);
            return result;
        }
    }
}
