package software.amazon.awscdk.pipelines;

/**
 * Run shell script commands in the pipeline.
 * <p>
 * This is a generic step designed
 * to be deployment engine agnostic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Modern API
 * CodePipeline modernPipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .selfMutation(false)
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         .build();
 * // Original API
 * Artifact cloudAssemblyArtifact = new Artifact();
 * CdkPipeline originalPipeline = new CdkPipeline(this, "Pipeline", new CdkPipelineProps()
 *         .selfMutating(false)
 *         .cloudAssemblyArtifact(cloudAssemblyArtifact)
 *         );
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:03.158Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ShellStep")
public class ShellStep extends software.amazon.awscdk.pipelines.Step {

    protected ShellStep(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ShellStep(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ShellStep(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ShellStepProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an additional output FileSet based on a directory.
     * <p>
     * After running the script, the contents of the given directory
     * will be exported as a <code>FileSet</code>. Use the <code>FileSet</code> as the
     * input to another step.
     * <p>
     * Multiple calls with the exact same directory name string (not normalized)
     * will return the same FileSet.
     * <p>
     * @param directory This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet addOutputDirectory(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        return software.amazon.jsii.Kernel.call(this, "addOutputDirectory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Configure the given output directory as primary output.
     * <p>
     * If no primary output has been configured yet, this directory
     * will become the primary output of this ShellStep, otherwise this
     * method will throw if the given directory is different than the
     * currently configured primary output directory.
     * <p>
     * @param directory This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet primaryOutputDirectory(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        return software.amazon.jsii.Kernel.call(this, "primaryOutputDirectory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Commands to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCommands() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * StackOutputReferences this step consumes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackOutputReference> getConsumedStackOutputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "consumedStackOutputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackOutputReference.class))));
    }

    /**
     * Environment variables to set.
     * <p>
     * Default: - No environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Set environment variables based on Stack Outputs.
     * <p>
     * Default: - No environment variables created from stack outputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.StackOutputReference> getEnvFromCfnOutputs() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "envFromCfnOutputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackOutputReference.class))));
    }

    /**
     * Input FileSets.
     * <p>
     * A list of <code>(FileSet, directory)</code> pairs, which are a copy of the
     * input properties. This list should not be modified directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.FileSetLocation> getInputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSetLocation.class))));
    }

    /**
     * Installation commands to run before the regular commands.
     * <p>
     * For deployment engines that support it, install commands will be classified
     * differently in the job history from the regular <code>commands</code>.
     * <p>
     * Default: - No installation commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstallCommands() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "installCommands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Output FileSets.
     * <p>
     * A list of <code>(FileSet, directory)</code> pairs, which are a copy of the
     * input properties. This list should not be modified directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.FileSetLocation> getOutputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSetLocation.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.ShellStep}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.ShellStep> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id Identifier for this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.ShellStepProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.ShellStepProps.Builder();
        }

        /**
         * Commands to run.
         * <p>
         * @return {@code this}
         * @param commands Commands to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(final java.util.List<java.lang.String> commands) {
            this.props.commands(commands);
            return this;
        }

        /**
         * Additional FileSets to put in other directories.
         * <p>
         * Specifies a mapping from directory name to FileSets. During the
         * script execution, the FileSets will be available in the directories
         * indicated.
         * <p>
         * The directory names may be relative. For example, you can put
         * the main input and an additional input side-by-side with the
         * following configuration:
         * <p>
         * <blockquote><pre>
         * ShellStep script = ShellStep.Builder.create("MainScript")
         *         .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
         *         .input(CodePipelineSource.gitHub("org/source1", "main"))
         *         .additionalInputs(Map.of(
         *                 "../siblingdir", CodePipelineSource.gitHub("org/source2", "main")))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - No additional inputs
         * <p>
         * @return {@code this}
         * @param additionalInputs Additional FileSets to put in other directories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInputs(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs) {
            this.props.additionalInputs(additionalInputs);
            return this;
        }

        /**
         * Environment variables to set.
         * <p>
         * Default: - No environment variables
         * <p>
         * @return {@code this}
         * @param env Environment variables to set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.Map<java.lang.String, java.lang.String> env) {
            this.props.env(env);
            return this;
        }

        /**
         * Set environment variables based on Stack Outputs.
         * <p>
         * <code>ShellStep</code>s following stack or stage deployments may
         * access the <code>CfnOutput</code>s of those stacks to get access to
         * --for example--automatically generated resource names or
         * endpoint URLs.
         * <p>
         * Default: - No environment variables created from stack outputs
         * <p>
         * @return {@code this}
         * @param envFromCfnOutputs Set environment variables based on Stack Outputs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envFromCfnOutputs(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.CfnOutput> envFromCfnOutputs) {
            this.props.envFromCfnOutputs(envFromCfnOutputs);
            return this;
        }

        /**
         * FileSet to run these scripts on.
         * <p>
         * The files in the FileSet will be placed in the working directory when
         * the script is executed. Use <code>additionalInputs</code> to download file sets
         * to other directories as well.
         * <p>
         * Default: - No input specified
         * <p>
         * @return {@code this}
         * @param input FileSet to run these scripts on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.pipelines.IFileSetProducer input) {
            this.props.input(input);
            return this;
        }

        /**
         * Installation commands to run before the regular commands.
         * <p>
         * For deployment engines that support it, install commands will be classified
         * differently in the job history from the regular <code>commands</code>.
         * <p>
         * Default: - No installation commands
         * <p>
         * @return {@code this}
         * @param installCommands Installation commands to run before the regular commands. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installCommands(final java.util.List<java.lang.String> installCommands) {
            this.props.installCommands(installCommands);
            return this;
        }

        /**
         * The directory that will contain the primary output fileset.
         * <p>
         * After running the script, the contents of the given directory
         * will be treated as the primary output of this Step.
         * <p>
         * Default: - No primary output
         * <p>
         * @return {@code this}
         * @param primaryOutputDirectory The directory that will contain the primary output fileset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryOutputDirectory(final java.lang.String primaryOutputDirectory) {
            this.props.primaryOutputDirectory(primaryOutputDirectory);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.ShellStep}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.ShellStep build() {
            return new software.amazon.awscdk.pipelines.ShellStep(
                this.id,
                this.props.build()
            );
        }
    }
}
