package software.amazon.awscdk.services.apigatewayv2;

/**
 * Route class that creates the Route for API Gateway WebSocket API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketApi webSocketApi;
 * IWebSocketRouteAuthorizer webSocketRouteAuthorizer;
 * WebSocketRouteIntegration webSocketRouteIntegration;
 * WebSocketRoute webSocketRoute = WebSocketRoute.Builder.create(this, "MyWebSocketRoute")
 *         .integration(webSocketRouteIntegration)
 *         .routeKey("routeKey")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizer(webSocketRouteAuthorizer)
 *         .returnResponse(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.745Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketRoute")
public class WebSocketRoute extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute {

    protected WebSocketRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Id of the Route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteId() {
        return software.amazon.jsii.Kernel.get(this, "routeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The key to this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteKey() {
        return software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The WebSocket API associated with this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
        return software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
    }

    /**
     * Integration response ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntegrationResponseId() {
        return software.amazon.jsii.Kernel.get(this, "integrationResponseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.WebSocketRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.WebSocketRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps.Builder();
        }

        /**
         * The integration to be configured on this route.
         * <p>
         * @return {@code this}
         * @param integration The integration to be configured on this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * The authorize to this route.
         * <p>
         * You can only set authorizer to a $connect route.
         * <p>
         * Default: - No Authorizer
         * <p>
         * @return {@code this}
         * @param authorizer The authorize to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer) {
            this.props.authorizer(authorizer);
            return this;
        }

        /**
         * Should the route send a response to the client.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param returnResponse Should the route send a response to the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnResponse(final java.lang.Boolean returnResponse) {
            this.props.returnResponse(returnResponse);
            return this;
        }

        /**
         * The key to this route.
         * <p>
         * @return {@code this}
         * @param routeKey The key to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(final java.lang.String routeKey) {
            this.props.routeKey(routeKey);
            return this;
        }

        /**
         * The API the route is associated with.
         * <p>
         * @return {@code this}
         * @param webSocketApi The API the route is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.props.webSocketApi(webSocketApi);
            return this;
        }

        /**
         * Whether the route requires an API Key to be provided.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param apiKeyRequired Whether the route requires an API Key to be provided. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.WebSocketRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.WebSocketRoute build() {
            return new software.amazon.awscdk.services.apigatewayv2.WebSocketRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
