package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize a new Route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketApi webSocketApi;
 * IWebSocketRouteAuthorizer webSocketRouteAuthorizer;
 * WebSocketRouteIntegration webSocketRouteIntegration;
 * WebSocketRouteProps webSocketRouteProps = WebSocketRouteProps.builder()
 *         .integration(webSocketRouteIntegration)
 *         .routeKey("routeKey")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizer(webSocketRouteAuthorizer)
 *         .returnResponse(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.749Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketRouteProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketRouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions {

    /**
     * The key to this route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteKey();

    /**
     * The API the route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi();

    /**
     * Whether the route requires an API Key to be provided.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApiKeyRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteProps> {
        java.lang.String routeKey;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        java.lang.Boolean apiKeyRequired;
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;
        java.lang.Boolean returnResponse;

        /**
         * Sets the value of {@link WebSocketRouteProps#getRouteKey}
         * @param routeKey The key to this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(java.lang.String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getWebSocketApi}
         * @param webSocketApi The API the route is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.webSocketApi = webSocketApi;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getApiKeyRequired}
         * @param apiKeyRequired Whether the route requires an API Key to be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getAuthorizer}
         * @param authorizer The authorize to this route.
         *                   You can only set authorizer to a $connect route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getReturnResponse}
         * @param returnResponse Should the route send a response to the client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnResponse(java.lang.Boolean returnResponse) {
            this.returnResponse = returnResponse;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteProps {
        private final java.lang.String routeKey;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        private final java.lang.Boolean apiKeyRequired;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;
        private final java.lang.Boolean returnResponse;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeKey = software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webSocketApi = software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration.class));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer.class));
            this.returnResponse = software.amazon.jsii.Kernel.get(this, "returnResponse", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeKey = java.util.Objects.requireNonNull(builder.routeKey, "routeKey is required");
            this.webSocketApi = java.util.Objects.requireNonNull(builder.webSocketApi, "webSocketApi is required");
            this.apiKeyRequired = builder.apiKeyRequired;
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
            this.authorizer = builder.authorizer;
            this.returnResponse = builder.returnResponse;
        }

        @Override
        public final java.lang.String getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
            return this.webSocketApi;
        }

        @Override
        public final java.lang.Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final java.lang.Boolean getReturnResponse() {
            return this.returnResponse;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeKey", om.valueToTree(this.getRouteKey()));
            data.set("webSocketApi", om.valueToTree(this.getWebSocketApi()));
            if (this.getApiKeyRequired() != null) {
                data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            data.set("integration", om.valueToTree(this.getIntegration()));
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getReturnResponse() != null) {
                data.set("returnResponse", om.valueToTree(this.getReturnResponse()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteProps.Jsii$Proxy that = (WebSocketRouteProps.Jsii$Proxy) o;

            if (!routeKey.equals(that.routeKey)) return false;
            if (!webSocketApi.equals(that.webSocketApi)) return false;
            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (!integration.equals(that.integration)) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            return this.returnResponse != null ? this.returnResponse.equals(that.returnResponse) : that.returnResponse == null;
        }

        @Override
        public final int hashCode() {
            int result = this.routeKey.hashCode();
            result = 31 * result + (this.webSocketApi.hashCode());
            result = 31 * result + (this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0);
            result = 31 * result + (this.integration.hashCode());
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.returnResponse != null ? this.returnResponse.hashCode() : 0);
            return result;
        }
    }
}
