package software.amazon.awscdk.services.appconfig;

/**
 * An AWS AppConfig environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application app = new Application(this, "MyApp");
 * Environment env = Environment.Builder.create(this, "MyEnv")
 *         .application(app)
 *         .build();
 * HostedConfiguration.Builder.create(this, "MyHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-environment.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.821Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Environment")
public class Environment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appconfig.IEnvironment, software.amazon.awscdk.services.appconfig.IExtensible {

    protected Environment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Environment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Environment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.EnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an environment into the CDK using its Amazon Resource Name (ARN).
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the environment construct. This parameter is required.
     * @param environmentArn The Amazon Resource Name (ARN) of the environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment fromEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String environmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Environment.class, "fromEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(environmentArn, "environmentArn is required") });
    }

    /**
     * Imports an environment into the CDK from its attributes.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the environment construct. This parameter is required.
     * @param attrs The attributes of the environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment fromEnvironmentAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.EnvironmentAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Environment.class, "fromEnvironmentAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds an extension association to the environment.
     * <p>
     * @param extension This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
        software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint This parameter is required.
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint This parameter is required.
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * The ID of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "environmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The application associated with the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IApplication getApplication() {
        return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
    }

    /**
     * The description of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The monitors for the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)(software.amazon.jsii.Kernel.get(this, "monitors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase getExtensible() {
        return software.amazon.jsii.Kernel.get(this, "extensible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ExtensibleBase.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setExtensible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase value) {
        software.amazon.jsii.Kernel.set(this, "extensible", java.util.Objects.requireNonNull(value, "extensible is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.Environment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.Environment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appconfig.EnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appconfig.EnvironmentProps.Builder();
        }

        /**
         * The description of the environment.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the environment.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param environmentName The name of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(final java.lang.String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        /**
         * The monitors for the environment.
         * <p>
         * Default: - No monitors.
         * <p>
         * @return {@code this}
         * @param monitors The monitors for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitors(final java.util.List<? extends software.amazon.awscdk.services.appconfig.Monitor> monitors) {
            this.props.monitors(monitors);
            return this;
        }

        /**
         * The application to be associated with the environment.
         * <p>
         * @return {@code this}
         * @param application The application to be associated with the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.appconfig.IApplication application) {
            this.props.application(application);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.Environment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.Environment build() {
            return new software.amazon.awscdk.services.appconfig.Environment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
