package software.amazon.awscdk.services.appflow;

/**
 * Properties for defining a <code>CfnConnectorProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * CfnConnectorProfileProps cfnConnectorProfileProps = CfnConnectorProfileProps.builder()
 *         .connectionMode("connectionMode")
 *         .connectorProfileName("connectorProfileName")
 *         .connectorType("connectorType")
 *         // the properties below are optional
 *         .connectorLabel("connectorLabel")
 *         .connectorProfileConfig(ConnectorProfileConfigProperty.builder()
 *                 .connectorProfileCredentials(ConnectorProfileCredentialsProperty.builder()
 *                         .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .secretKey("secretKey")
 *                                 .build())
 *                         .customConnector(CustomConnectorProfileCredentialsProperty.builder()
 *                                 .authenticationType("authenticationType")
 *                                 // the properties below are optional
 *                                 .apiKey(ApiKeyCredentialsProperty.builder()
 *                                         .apiKey("apiKey")
 *                                         // the properties below are optional
 *                                         .apiSecretKey("apiSecretKey")
 *                                         .build())
 *                                 .basic(BasicAuthCredentialsProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .custom(CustomAuthCredentialsProperty.builder()
 *                                         .customAuthenticationType("customAuthenticationType")
 *                                         // the properties below are optional
 *                                         .credentialsMap(Map.of(
 *                                                 "credentialsMapKey", "credentialsMap"))
 *                                         .build())
 *                                 .oauth2(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .build())
 *                         .datadog(DatadogConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .applicationKey("applicationKey")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
 *                                 .apiToken("apiToken")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
 *                                 .accessKeyId("accessKeyId")
 *                                 .datakey("datakey")
 *                                 .secretAccessKey("secretAccessKey")
 *                                 .userId("userId")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .pardot(PardotConnectorProfileCredentialsProperty.builder()
 *                                 .accessToken("accessToken")
 *                                 .clientCredentialsArn("clientCredentialsArn")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
 *                                 .accessToken("accessToken")
 *                                 .clientCredentialsArn("clientCredentialsArn")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .jwtToken("jwtToken")
 *                                 .oAuth2GrantType("oAuth2GrantType")
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
 *                                 .basicAuthCredentials(BasicAuthCredentialsProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .oAuthCredentials(OAuthCredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
 *                                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .singular(SingularConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .build())
 *                         .slack(SlackConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
 *                                 .apiSecretKey("apiSecretKey")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .connectorProfileProperties(ConnectorProfilePropertiesProperty.builder()
 *                         .customConnector(CustomConnectorProfilePropertiesProperty.builder()
 *                                 .oAuth2Properties(OAuth2PropertiesProperty.builder()
 *                                         .oAuth2GrantType("oAuth2GrantType")
 *                                         .tokenUrl("tokenUrl")
 *                                         .tokenUrlCustomProperties(Map.of(
 *                                                 "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
 *                                         .build())
 *                                 .profileProperties(Map.of(
 *                                         "profilePropertiesKey", "profileProperties"))
 *                                 .build())
 *                         .datadog(DatadogConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .pardot(PardotConnectorProfilePropertiesProperty.builder()
 *                                 .businessUnitId("businessUnitId")
 *                                 // the properties below are optional
 *                                 .instanceUrl("instanceUrl")
 *                                 .isSandboxEnvironment(false)
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .clusterIdentifier("clusterIdentifier")
 *                                 .dataApiRoleArn("dataApiRoleArn")
 *                                 .databaseName("databaseName")
 *                                 .databaseUrl("databaseUrl")
 *                                 .isRedshiftServerless(false)
 *                                 .workgroupName("workgroupName")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .isSandboxEnvironment(false)
 *                                 .usePrivateLinkForMetadataAndAuthorization(false)
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
 *                                 .applicationHostUrl("applicationHostUrl")
 *                                 .applicationServicePath("applicationServicePath")
 *                                 .clientNumber("clientNumber")
 *                                 .disableSso(false)
 *                                 .logonLanguage("logonLanguage")
 *                                 .oAuthProperties(OAuthPropertiesProperty.builder()
 *                                         .authCodeUrl("authCodeUrl")
 *                                         .oAuthScopes(List.of("oAuthScopes"))
 *                                         .tokenUrl("tokenUrl")
 *                                         .build())
 *                                 .portNumber(123)
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .slack(SlackConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .stage("stage")
 *                                 .warehouse("warehouse")
 *                                 // the properties below are optional
 *                                 .accountName("accountName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .region("region")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kmsArn("kmsArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:49.903Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectorProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectorProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates the connection mode and if it is public or private.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionMode();

    /**
     * The name of the connector profile.
     * <p>
     * The name is unique for each <code>ConnectorProfile</code> in the AWS account .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorProfileName();

    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

    /**
     * The label for the connector profile being created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorlabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectorLabel() {
        return null;
    }

    /**
     * Defines the connector-specific configuration and credentials.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileConfig() {
        return null;
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectorProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectorProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectorProfileProps> {
        java.lang.String connectionMode;
        java.lang.String connectorProfileName;
        java.lang.String connectorType;
        java.lang.String connectorLabel;
        java.lang.Object connectorProfileConfig;
        java.lang.String kmsArn;

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectionMode}
         * @param connectionMode Indicates the connection mode and if it is public or private. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionMode(java.lang.String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectorProfileName}
         * @param connectorProfileName The name of the connector profile. This parameter is required.
         *                             The name is unique for each <code>ConnectorProfile</code> in the AWS account .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileName(java.lang.String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectorType}
         * @param connectorType The type of connector, such as Salesforce, Amplitude, and so on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorType(java.lang.String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectorLabel}
         * @param connectorLabel The label for the connector profile being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorLabel(java.lang.String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectorProfileConfig}
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(software.amazon.awscdk.IResolvable connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getConnectorProfileConfig}
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProfileProps#getKmsArn}
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *               This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(java.lang.String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectorProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectorProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectorProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectorProfileProps {
        private final java.lang.String connectionMode;
        private final java.lang.String connectorProfileName;
        private final java.lang.String connectorType;
        private final java.lang.String connectorLabel;
        private final java.lang.Object connectorProfileConfig;
        private final java.lang.String kmsArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionMode = software.amazon.jsii.Kernel.get(this, "connectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorLabel = software.amazon.jsii.Kernel.get(this, "connectorLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorProfileConfig = software.amazon.jsii.Kernel.get(this, "connectorProfileConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionMode = java.util.Objects.requireNonNull(builder.connectionMode, "connectionMode is required");
            this.connectorProfileName = java.util.Objects.requireNonNull(builder.connectorProfileName, "connectorProfileName is required");
            this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
            this.connectorLabel = builder.connectorLabel;
            this.connectorProfileConfig = builder.connectorProfileConfig;
            this.kmsArn = builder.kmsArn;
        }

        @Override
        public final java.lang.String getConnectionMode() {
            return this.connectionMode;
        }

        @Override
        public final java.lang.String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        @Override
        public final java.lang.String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final java.lang.String getConnectorLabel() {
            return this.connectorLabel;
        }

        @Override
        public final java.lang.Object getConnectorProfileConfig() {
            return this.connectorProfileConfig;
        }

        @Override
        public final java.lang.String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionMode", om.valueToTree(this.getConnectionMode()));
            data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
            data.set("connectorType", om.valueToTree(this.getConnectorType()));
            if (this.getConnectorLabel() != null) {
                data.set("connectorLabel", om.valueToTree(this.getConnectorLabel()));
            }
            if (this.getConnectorProfileConfig() != null) {
                data.set("connectorProfileConfig", om.valueToTree(this.getConnectorProfileConfig()));
            }
            if (this.getKmsArn() != null) {
                data.set("kmsArn", om.valueToTree(this.getKmsArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectorProfileProps.Jsii$Proxy that = (CfnConnectorProfileProps.Jsii$Proxy) o;

            if (!connectionMode.equals(that.connectionMode)) return false;
            if (!connectorProfileName.equals(that.connectorProfileName)) return false;
            if (!connectorType.equals(that.connectorType)) return false;
            if (this.connectorLabel != null ? !this.connectorLabel.equals(that.connectorLabel) : that.connectorLabel != null) return false;
            if (this.connectorProfileConfig != null ? !this.connectorProfileConfig.equals(that.connectorProfileConfig) : that.connectorProfileConfig != null) return false;
            return this.kmsArn != null ? this.kmsArn.equals(that.kmsArn) : that.kmsArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionMode.hashCode();
            result = 31 * result + (this.connectorProfileName.hashCode());
            result = 31 * result + (this.connectorType.hashCode());
            result = 31 * result + (this.connectorLabel != null ? this.connectorLabel.hashCode() : 0);
            result = 31 * result + (this.connectorProfileConfig != null ? this.connectorProfileConfig.hashCode() : 0);
            result = 31 * result + (this.kmsArn != null ? this.kmsArn.hashCode() : 0);
            return result;
        }
    }
}
