package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a <code>CfnDirectoryConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * CfnDirectoryConfigProps cfnDirectoryConfigProps = CfnDirectoryConfigProps.builder()
 *         .directoryName("directoryName")
 *         .organizationalUnitDistinguishedNames(List.of("organizationalUnitDistinguishedNames"))
 *         .serviceAccountCredentials(ServiceAccountCredentialsProperty.builder()
 *                 .accountName("accountName")
 *                 .accountPassword("accountPassword")
 *                 .build())
 *         // the properties below are optional
 *         .certificateBasedAuthProperties(CertificateBasedAuthPropertiesProperty.builder()
 *                 .certificateAuthorityArn("certificateAuthorityArn")
 *                 .status("status")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.307Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnDirectoryConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnDirectoryConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDirectoryConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fully qualified name of the directory (for example, corp.example.com).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectoryName();

    /**
     * The distinguished names of the organizational units for computer accounts.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOrganizationalUnitDistinguishedNames();

    /**
     * The credentials for the service account used by the streaming instance to connect to the directory.
     * <p>
     * Do not use this parameter directly. Use <code>ServiceAccountCredentials</code> as an input parameter with <code>noEcho</code> as shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html">Parameters</a> . For best practices information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds">Do Not Embed Credentials in Your Templates</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getServiceAccountCredentials();

    /**
     * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-certificatebasedauthproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-certificatebasedauthproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificateBasedAuthProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDirectoryConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDirectoryConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDirectoryConfigProps> {
        java.lang.String directoryName;
        java.util.List<java.lang.String> organizationalUnitDistinguishedNames;
        java.lang.Object serviceAccountCredentials;
        java.lang.Object certificateBasedAuthProperties;

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getDirectoryName}
         * @param directoryName The fully qualified name of the directory (for example, corp.example.com). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryName(java.lang.String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getOrganizationalUnitDistinguishedNames}
         * @param organizationalUnitDistinguishedNames The distinguished names of the organizational units for computer accounts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnitDistinguishedNames(java.util.List<java.lang.String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = organizationalUnitDistinguishedNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getServiceAccountCredentials}
         * @param serviceAccountCredentials The credentials for the service account used by the streaming instance to connect to the directory. This parameter is required.
         *                                  Do not use this parameter directly. Use <code>ServiceAccountCredentials</code> as an input parameter with <code>noEcho</code> as shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html">Parameters</a> . For best practices information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds">Do Not Embed Credentials in Your Templates</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccountCredentials(software.amazon.awscdk.IResolvable serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getServiceAccountCredentials}
         * @param serviceAccountCredentials The credentials for the service account used by the streaming instance to connect to the directory. This parameter is required.
         *                                  Do not use this parameter directly. Use <code>ServiceAccountCredentials</code> as an input parameter with <code>noEcho</code> as shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html">Parameters</a> . For best practices information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds">Do Not Embed Credentials in Your Templates</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccountCredentials(software.amazon.awscdk.services.appstream.CfnDirectoryConfig.ServiceAccountCredentialsProperty serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getCertificateBasedAuthProperties}
         * @param certificateBasedAuthProperties The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateBasedAuthProperties(software.amazon.awscdk.IResolvable certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryConfigProps#getCertificateBasedAuthProperties}
         * @param certificateBasedAuthProperties The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateBasedAuthProperties(software.amazon.awscdk.services.appstream.CfnDirectoryConfig.CertificateBasedAuthPropertiesProperty certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDirectoryConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDirectoryConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDirectoryConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDirectoryConfigProps {
        private final java.lang.String directoryName;
        private final java.util.List<java.lang.String> organizationalUnitDistinguishedNames;
        private final java.lang.Object serviceAccountCredentials;
        private final java.lang.Object certificateBasedAuthProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.directoryName = software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationalUnitDistinguishedNames = software.amazon.jsii.Kernel.get(this, "organizationalUnitDistinguishedNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serviceAccountCredentials = software.amazon.jsii.Kernel.get(this, "serviceAccountCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.certificateBasedAuthProperties = software.amazon.jsii.Kernel.get(this, "certificateBasedAuthProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directoryName = java.util.Objects.requireNonNull(builder.directoryName, "directoryName is required");
            this.organizationalUnitDistinguishedNames = java.util.Objects.requireNonNull(builder.organizationalUnitDistinguishedNames, "organizationalUnitDistinguishedNames is required");
            this.serviceAccountCredentials = java.util.Objects.requireNonNull(builder.serviceAccountCredentials, "serviceAccountCredentials is required");
            this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
        }

        @Override
        public final java.lang.String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final java.util.List<java.lang.String> getOrganizationalUnitDistinguishedNames() {
            return this.organizationalUnitDistinguishedNames;
        }

        @Override
        public final java.lang.Object getServiceAccountCredentials() {
            return this.serviceAccountCredentials;
        }

        @Override
        public final java.lang.Object getCertificateBasedAuthProperties() {
            return this.certificateBasedAuthProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("directoryName", om.valueToTree(this.getDirectoryName()));
            data.set("organizationalUnitDistinguishedNames", om.valueToTree(this.getOrganizationalUnitDistinguishedNames()));
            data.set("serviceAccountCredentials", om.valueToTree(this.getServiceAccountCredentials()));
            if (this.getCertificateBasedAuthProperties() != null) {
                data.set("certificateBasedAuthProperties", om.valueToTree(this.getCertificateBasedAuthProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnDirectoryConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDirectoryConfigProps.Jsii$Proxy that = (CfnDirectoryConfigProps.Jsii$Proxy) o;

            if (!directoryName.equals(that.directoryName)) return false;
            if (!organizationalUnitDistinguishedNames.equals(that.organizationalUnitDistinguishedNames)) return false;
            if (!serviceAccountCredentials.equals(that.serviceAccountCredentials)) return false;
            return this.certificateBasedAuthProperties != null ? this.certificateBasedAuthProperties.equals(that.certificateBasedAuthProperties) : that.certificateBasedAuthProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.directoryName.hashCode();
            result = 31 * result + (this.organizationalUnitDistinguishedNames.hashCode());
            result = 31 * result + (this.serviceAccountCredentials.hashCode());
            result = 31 * result + (this.certificateBasedAuthProperties != null ? this.certificateBasedAuthProperties.hashCode() : 0);
            return result;
        }
    }
}
