package software.amazon.awscdk.services.appsync;

/**
 * Specifies the attribute value assignments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .definition(Definition.fromFile(join(__dirname, "schema.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.IAM)
 *                         .build())
 *                 .build())
 *         .xrayEnabled(true)
 *         .build();
 * Table demoTable = Table.Builder.create(this, "DemoTable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * DynamoDbDataSource demoDS = api.addDynamoDbDataSource("demoDataSource", demoTable);
 * // Resolver for the Query "getDemos" that scans the DynamoDb table and returns the entire list.
 * // Resolver Mapping Template Reference:
 * // https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference-dynamodb.html
 * demoDS.createResolver("QueryGetDemosResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemos")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable())
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * // Resolver for the Mutation "addDemo" that puts the item into the DynamoDb table.
 * demoDS.createResolver("MutationAddDemoResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemo")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbPutItem(PrimaryKey.partition("id").auto(), Values.projecting("input")))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultItem())
 *         .build());
 * //To enable DynamoDB read consistency with the `MappingTemplate`:
 * demoDS.createResolver("QueryGetDemosConsistentResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosConsistent")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable(true))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.352Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AttributeValues")
public class AttributeValues extends software.amazon.jsii.JsiiObject {

    protected AttributeValues(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AttributeValues(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param container This parameter is required.
     * @param assignments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AttributeValues(final @org.jetbrains.annotations.NotNull java.lang.String container, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Assign> assignments) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(container, "container is required"), assignments });
    }

    /**
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AttributeValues(final @org.jetbrains.annotations.NotNull java.lang.String container) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * Allows assigning a value to the specified attribute.
     * <p>
     * @param attr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValuesStep attribute(final @org.jetbrains.annotations.NotNull java.lang.String attr) {
        return software.amazon.jsii.Kernel.call(this, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AttributeValuesStep.class), new Object[] { java.util.Objects.requireNonNull(attr, "attr is required") });
    }

    /**
     * Renders the attribute value assingments to a VTL string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String renderTemplate() {
        return software.amazon.jsii.Kernel.call(this, "renderTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Renders the variables required for <code>renderTemplate</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String renderVariables() {
        return software.amazon.jsii.Kernel.call(this, "renderVariables", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
