package software.amazon.awscdk.services.appsync;

/**
 * Represents source code for an AppSync Function or Resolver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction myJsFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("my_js_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .code(Code.fromAsset("directory/function_code.js"))
 *         .runtime(FunctionRuntime.JS_1_0_0)
 *         .build();
 * Resolver.Builder.create(this, "PipelineResolver")
 *         .api(api)
 *         .typeName("typeName")
 *         .fieldName("fieldName")
 *         .code(Code.fromInline("\n    // The before step\n    export function request(...args) {\n      console.log(args);\n      return {}\n    }\n\n    // The after step\n    export function response(ctx) {\n      return ctx.prev.result\n    }\n  "))
 *         .runtime(FunctionRuntime.JS_1_0_0)
 *         .pipelineConfig(List.of(myJsFunction))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path The path to the source code file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path The path to the source code file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Inline code for AppSync function.
     * <p>
     * @return <code>InlineCode</code> with inline code.
     * @param code The actual handler code (limited to 4KiB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.InlineCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.InlineCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * Bind source code to an AppSync Function or resolver.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Bind source code to an AppSync Function or resolver.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
