package software.amazon.awscdk.services.batch;

/**
 * The corresponding Action will only be taken if <em>all</em> of the conditions specified here are met.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .retryAttempts(5)
 *         .retryStrategies(List.of(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER)))
 *         .build();
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.SPOT_INSTANCE_RECLAIMED));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.custom(CustomReason.builder()
 *         .onExitCode("40*")
 *         .onReason("some reason")
 *         .build())));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.846Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CustomReason")
@software.amazon.jsii.Jsii.Proxy(CustomReason.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomReason extends software.amazon.jsii.JsiiSerializable {

    /**
     * A glob string that will match on the job exit code.
     * <p>
     * For example, <code>'40*'</code> will match 400, 404, 40123456789012
     * <p>
     * Default: - will not match on the exit code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOnExitCode() {
        return null;
    }

    /**
     * A glob string that will match on the reason returned by the exiting job For example, <code>'CannotPullContainerError*'</code> indicates that container needed to start the job could not be pulled.
     * <p>
     * Default: - will not match on the reason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOnReason() {
        return null;
    }

    /**
     * A glob string that will match on the statusReason returned by the exiting job.
     * <p>
     * For example, <code>'Host EC2*'</code> indicates that the spot instance has been reclaimed.
     * <p>
     * Default: - will not match on the status reason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOnStatusReason() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomReason}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomReason}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomReason> {
        java.lang.String onExitCode;
        java.lang.String onReason;
        java.lang.String onStatusReason;

        /**
         * Sets the value of {@link CustomReason#getOnExitCode}
         * @param onExitCode A glob string that will match on the job exit code.
         *                   For example, <code>'40*'</code> will match 400, 404, 40123456789012
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExitCode(java.lang.String onExitCode) {
            this.onExitCode = onExitCode;
            return this;
        }

        /**
         * Sets the value of {@link CustomReason#getOnReason}
         * @param onReason A glob string that will match on the reason returned by the exiting job For example, <code>'CannotPullContainerError*'</code> indicates that container needed to start the job could not be pulled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onReason(java.lang.String onReason) {
            this.onReason = onReason;
            return this;
        }

        /**
         * Sets the value of {@link CustomReason#getOnStatusReason}
         * @param onStatusReason A glob string that will match on the statusReason returned by the exiting job.
         *                       For example, <code>'Host EC2*'</code> indicates that the spot instance has been reclaimed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onStatusReason(java.lang.String onStatusReason) {
            this.onStatusReason = onStatusReason;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomReason}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomReason build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomReason}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomReason {
        private final java.lang.String onExitCode;
        private final java.lang.String onReason;
        private final java.lang.String onStatusReason;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onExitCode = software.amazon.jsii.Kernel.get(this, "onExitCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onReason = software.amazon.jsii.Kernel.get(this, "onReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onStatusReason = software.amazon.jsii.Kernel.get(this, "onStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onExitCode = builder.onExitCode;
            this.onReason = builder.onReason;
            this.onStatusReason = builder.onStatusReason;
        }

        @Override
        public final java.lang.String getOnExitCode() {
            return this.onExitCode;
        }

        @Override
        public final java.lang.String getOnReason() {
            return this.onReason;
        }

        @Override
        public final java.lang.String getOnStatusReason() {
            return this.onStatusReason;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOnExitCode() != null) {
                data.set("onExitCode", om.valueToTree(this.getOnExitCode()));
            }
            if (this.getOnReason() != null) {
                data.set("onReason", om.valueToTree(this.getOnReason()));
            }
            if (this.getOnStatusReason() != null) {
                data.set("onStatusReason", om.valueToTree(this.getOnStatusReason()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CustomReason"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomReason.Jsii$Proxy that = (CustomReason.Jsii$Proxy) o;

            if (this.onExitCode != null ? !this.onExitCode.equals(that.onExitCode) : that.onExitCode != null) return false;
            if (this.onReason != null ? !this.onReason.equals(that.onReason) : that.onReason != null) return false;
            return this.onStatusReason != null ? this.onStatusReason.equals(that.onStatusReason) : that.onStatusReason == null;
        }

        @Override
        public final int hashCode() {
            int result = this.onExitCode != null ? this.onExitCode.hashCode() : 0;
            result = 31 * result + (this.onReason != null ? this.onReason.hashCode() : 0);
            result = 31 * result + (this.onStatusReason != null ? this.onStatusReason.hashCode() : 0);
            return result;
        }
    }
}
