package software.amazon.awscdk.services.batch;

/**
 * A container orchestrated by ECS that uses Fargate resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsFargateContainerDefinition.Builder.create(this, "myFargateContainer")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .ephemeralStorageSize(Size.gibibytes(100))
 *                 .fargateCpuArchitecture(CpuArchitecture.ARM64)
 *                 .fargateOperatingSystemFamily(OperatingSystemFamily.LINUX)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.859Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsFargateContainerDefinition")
public class EcsFargateContainerDefinition extends software.constructs.Construct implements software.amazon.awscdk.services.batch.IEcsFargateContainerDefinition, software.amazon.awscdk.services.batch.IEcsContainerDefinition {

    protected EcsFargateContainerDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsFargateContainerDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsFargateContainerDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsFargateContainerDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a Volume to this container.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * The number of vCPUs reserved for the container.
     * <p>
     * Each vCPU is equivalent to 1,024 CPU shares.
     * For containers running on EC2 resources, you must specify at least one vCPU.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getCpu() {
        return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The image that this container will run.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
    }

    /**
     * The memory hard limit present to the container.
     * <p>
     * If your container attempts to exceed the memory specified, the container is terminated.
     * You must specify at least 4 MiB of memory for a job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory() {
        return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The volumes to mount to this container.
     * <p>
     * Automatically added to the job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class))));
    }

    /**
     * Indicates whether the job has a public IP address.
     * <p>
     * For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet
     * (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The command that's passed to the container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The environment variables to pass to a container.
     * <p>
     * Cannot start with <code>AWS_BATCH</code>.
     * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The size for ephemeral storage.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEphemeralStorageSize() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The vCPU architecture of Fargate Runtime.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CpuArchitecture getFargateCpuArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "fargateCpuArchitecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class));
    }

    /**
     * The operating system for the compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.OperatingSystemFamily getFargateOperatingSystemFamily() {
        return software.amazon.jsii.Kernel.get(this, "fargateOperatingSystemFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
    }

    /**
     * Which version of Fargate to use when running this container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getFargatePlatformVersion() {
        return software.amazon.jsii.Kernel.get(this, "fargatePlatformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
    }

    /**
     * The role that the container can assume.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
        return software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
        return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
    }

    /**
     * The configuration of the log driver.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
        return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
    }

    /**
     * Gives the container readonly access to its root filesystem.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
        return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A map from environment variable names to the secrets for the container.
     * <p>
     * Allows your job definitions
     * to reference the secret by the environment variable name defined in this property.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The user name to use inside the container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EcsFargateContainerDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EcsFargateContainerDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.EcsFargateContainerDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.EcsFargateContainerDefinitionProps.Builder();
        }

        /**
         * The number of vCPUs reserved for the container.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares.
         * For containers running on EC2 resources, you must specify at least one vCPU.
         * <p>
         * @return {@code this}
         * @param cpu The number of vCPUs reserved for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The image that this container will run.
         * <p>
         * @return {@code this}
         * @param image The image that this container will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props.image(image);
            return this;
        }

        /**
         * The memory hard limit present to the container.
         * <p>
         * If your container attempts to exceed the memory specified, the container is terminated.
         * You must specify at least 4 MiB of memory for a job.
         * <p>
         * @return {@code this}
         * @param memory The memory hard limit present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(final software.amazon.awscdk.Size memory) {
            this.props.memory(memory);
            return this;
        }

        /**
         * The command that's passed to the container.
         * <p>
         * Default: - no command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         * @param command The command that's passed to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * Cannot start with <code>AWS_BATCH</code>.
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * Default: - no environment variables
         * <p>
         * @return {@code this}
         * @param environment The environment variables to pass to a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * <p>
         * Default: - a Role will be created
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
         * @param executionRole The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The role that the container can assume.
         * <p>
         * Default: - no job role
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
         * @param jobRole The role that the container can assume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRole(final software.amazon.awscdk.services.iam.IRole jobRole) {
            this.props.jobRole(jobRole);
            return this;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(final software.amazon.awscdk.services.batch.LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        /**
         * The loging configuration for this Job.
         * <p>
         * Default: - the log configuration of the Docker daemon
         * <p>
         * @return {@code this}
         * @param logging The loging configuration for this Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * Gives the container readonly access to its root filesystem.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonlyRootFilesystem Gives the container readonly access to its root filesystem. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(final java.lang.Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        /**
         * A map from environment variable names to the secrets for the container.
         * <p>
         * Allows your job definitions
         * to reference the secret by the environment variable name defined in this property.
         * <p>
         * Default: - no secrets
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
         * @param secrets A map from environment variable names to the secrets for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.batch.Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: - no user
         * <p>
         * @return {@code this}
         * @param user The user name to use inside the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(final java.lang.String user) {
            this.props.user(user);
            return this;
        }

        /**
         * The volumes to mount to this container.
         * <p>
         * Automatically added to the job definition.
         * <p>
         * Default: - no volumes
         * <p>
         * @return {@code this}
         * @param volumes The volumes to mount to this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.batch.EcsVolume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * Indicates whether the job has a public IP address.
         * <p>
         * For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet
         * (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html</a>
         * @param assignPublicIp Indicates whether the job has a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * The size for ephemeral storage.
         * <p>
         * Default: - 20 GiB
         * <p>
         * @return {@code this}
         * @param ephemeralStorageSize The size for ephemeral storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(final software.amazon.awscdk.Size ephemeralStorageSize) {
            this.props.ephemeralStorageSize(ephemeralStorageSize);
            return this;
        }

        /**
         * The vCPU architecture of Fargate Runtime.
         * <p>
         * Default: - X86_64
         * <p>
         * @return {@code this}
         * @param fargateCpuArchitecture The vCPU architecture of Fargate Runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateCpuArchitecture(final software.amazon.awscdk.services.ecs.CpuArchitecture fargateCpuArchitecture) {
            this.props.fargateCpuArchitecture(fargateCpuArchitecture);
            return this;
        }

        /**
         * The operating system for the compute environment.
         * <p>
         * Default: - LINUX
         * <p>
         * @return {@code this}
         * @param fargateOperatingSystemFamily The operating system for the compute environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateOperatingSystemFamily(final software.amazon.awscdk.services.ecs.OperatingSystemFamily fargateOperatingSystemFamily) {
            this.props.fargateOperatingSystemFamily(fargateOperatingSystemFamily);
            return this;
        }

        /**
         * Which version of Fargate to use when running this container.
         * <p>
         * Default: LATEST
         * <p>
         * @return {@code this}
         * @param fargatePlatformVersion Which version of Fargate to use when running this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargatePlatformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion fargatePlatformVersion) {
            this.props.fargatePlatformVersion(fargatePlatformVersion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EcsFargateContainerDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EcsFargateContainerDefinition build() {
            return new software.amazon.awscdk.services.batch.EcsFargateContainerDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
