package software.amazon.awscdk.services.batch;

/**
 * A container that can be run with EKS orchestration on EC2 resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksContainerDefinition")
public class EksContainerDefinition extends software.constructs.Construct implements software.amazon.awscdk.services.batch.IEksContainerDefinition {

    protected EksContainerDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksContainerDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EksContainerDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Mount a Volume to this container.
     * <p>
     * Automatically added to the Pod.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksVolume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * The image that this container will run.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
    }

    /**
     * The Volumes to mount to this container.
     * <p>
     * Automatically added to the Pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksVolume.class))));
    }

    /**
     * An array of arguments to the entrypoint.
     * <p>
     * If this isn't specified, the CMD of the container image is used.
     * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
     * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
     * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The entrypoint for the container.
     * <p>
     * This isn't run within a shell.
     * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
     * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
     * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
     * <p>
     * The entrypoint can't be updated.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getCpuLimit() {
        return software.amazon.jsii.Kernel.get(this, "cpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getCpuReservation() {
        return software.amazon.jsii.Kernel.get(this, "cpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The environment variables to pass to this container.
     * <p>
     * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
     * This naming convention is reserved for variables that AWS Batch sets.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The hard limit of GPUs to present to this container.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getGpuLimit() {
        return software.amazon.jsii.Kernel.get(this, "gpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getGpuReservation() {
        return software.amazon.jsii.Kernel.get(this, "gpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The image pull policy for this container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ImagePullPolicy.class));
    }

    /**
     * The amount (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed the allocated memory, it will be terminated.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryLimit() {
        return software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * <p>
     * Your container will be given at least this much memory, but may consume more.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * When system memory is under heavy contention, Docker attempts to keep the
     * container memory to this soft limit. However, your container can consume more
     * memory when it needs to, up to either the hard limit specified with the memory
     * parameter (if applicable), or all of the available memory on the container
     * instance, whichever comes first.
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
     * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryReservation() {
        return software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
    }

    /**
     * The name of this container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If specified, gives this container elevated permissions on the host container instance.
     * <p>
     * The level of permissions are similar to the root user permissions.
     * <p>
     * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * If specified, gives this container readonly access to its root file system.
     * <p>
     * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
        return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * If specified, the container is run as the specified group ID (<code>gid</code>).
     * <p>
     * If this parameter isn't specified, the default is the group that's specified in the image metadata.
     * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
        return software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * If specified, the container is run as a user with a <code>uid</code> other than 0.
     * <p>
     * Otherwise, no such rule is enforced.
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getRunAsRoot() {
        return software.amazon.jsii.Kernel.get(this, "runAsRoot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * If specified, this container is run as the specified user ID (<code>uid</code>).
     * <p>
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
        return software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EksContainerDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EksContainerDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.EksContainerDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.EksContainerDefinitionProps.Builder();
        }

        /**
         * The image that this container will run.
         * <p>
         * @return {@code this}
         * @param image The image that this container will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props.image(image);
            return this;
        }

        /**
         * An array of arguments to the entrypoint.
         * <p>
         * If this isn't specified, the CMD of the container image is used.
         * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
         * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
         * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
         * <p>
         * Default: - no args
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/</a>
         * @param args An array of arguments to the entrypoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(final java.util.List<java.lang.String> args) {
            this.props.args(args);
            return this;
        }

        /**
         * The entrypoint for the container.
         * <p>
         * This isn't run within a shell.
         * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
         * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
         * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
         * <p>
         * The entrypoint can't be updated.
         * <p>
         * Default: - no command
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint</a>
         * @param command The entrypoint for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPU limit
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         * @param cpuLimit The hard limit of CPUs to present to this container. Must be an even multiple of 0.25. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuLimit(final java.lang.Number cpuLimit) {
            this.props.cpuLimit(cpuLimit);
            return this;
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPUs reserved
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         * @param cpuReservation The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuReservation(final java.lang.Number cpuReservation) {
            this.props.cpuReservation(cpuReservation);
            return this;
        }

        /**
         * The environment variables to pass to this container.
         * <p>
         * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
         * This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * Default: - no environment variables
         * <p>
         * @return {@code this}
         * @param env The environment variables to pass to this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.Map<java.lang.String, java.lang.String> env) {
            this.props.env(env);
            return this;
        }

        /**
         * The hard limit of GPUs to present to this container.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPU limit
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         * @param gpuLimit The hard limit of GPUs to present to this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuLimit(final java.lang.Number gpuLimit) {
            this.props.gpuLimit(gpuLimit);
            return this;
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPUs reserved
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         * @param gpuReservation The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuReservation(final java.lang.Number gpuReservation) {
            this.props.gpuReservation(gpuReservation);
            return this;
        }

        /**
         * The image pull policy for this container.
         * <p>
         * Default: - `ALWAYS` if the `:latest` tag is specified, `IF_NOT_PRESENT` otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#updating-images">https://kubernetes.io/docs/concepts/containers/images/#updating-images</a>
         * @param imagePullPolicy The image pull policy for this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imagePullPolicy(final software.amazon.awscdk.services.batch.ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, it will be terminated.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory limit
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         * @param memoryLimit The amount (in MiB) of memory to present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(final software.amazon.awscdk.Size memoryLimit) {
            this.props.memoryLimit(memoryLimit);
            return this;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * Your container will be given at least this much memory, but may consume more.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the
         * container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the memory
         * parameter (if applicable), or all of the available memory on the container
         * instance, whichever comes first.
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
         * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory reserved
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         * @param memoryReservation The soft limit (in MiB) of memory to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservation(final software.amazon.awscdk.Size memoryReservation) {
            this.props.memoryReservation(memoryReservation);
            return this;
        }

        /**
         * The name of this container.
         * <p>
         * Default: : `'Default'`
         * <p>
         * @return {@code this}
         * @param name The name of this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * If specified, gives this container elevated permissions on the host container instance.
         * <p>
         * The level of permissions are similar to the root user permissions.
         * <p>
         * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         * @param privileged If specified, gives this container elevated permissions on the host container instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(final java.lang.Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        /**
         * If specified, gives this container readonly access to its root file system.
         * <p>
         * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         * @param readonlyRootFilesystem If specified, gives this container readonly access to its root file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(final java.lang.Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        /**
         * If specified, the container is run as the specified group ID (<code>gid</code>).
         * <p>
         * If this parameter isn't specified, the default is the group that's specified in the image metadata.
         * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         * @param runAsGroup If specified, the container is run as the specified group ID (<code>gid</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsGroup(final java.lang.Number runAsGroup) {
            this.props.runAsGroup(runAsGroup);
            return this;
        }

        /**
         * If specified, the container is run as a user with a <code>uid</code> other than 0.
         * <p>
         * Otherwise, no such rule is enforced.
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the container is *not* required to run as a non-root user
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         * @param runAsRoot If specified, the container is run as a user with a <code>uid</code> other than 0. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsRoot(final java.lang.Boolean runAsRoot) {
            this.props.runAsRoot(runAsRoot);
            return this;
        }

        /**
         * If specified, this container is run as the specified user ID (<code>uid</code>).
         * <p>
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the user that is specified in the image metadata.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         * @param runAsUser If specified, this container is run as the specified user ID (<code>uid</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runAsUser(final java.lang.Number runAsUser) {
            this.props.runAsUser(runAsUser);
            return this;
        }

        /**
         * The Volumes to mount to this container.
         * <p>
         * Automatically added to the Pod.
         * <p>
         * Default: - no volumes
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/">https://kubernetes.io/docs/concepts/storage/volumes/</a>
         * @param volumes The Volumes to mount to this container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.batch.EksVolume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EksContainerDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EksContainerDefinition build() {
            return new software.amazon.awscdk.services.batch.EksContainerDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
