package software.amazon.awscdk.services.batch;

/**
 * Options for a kubernetes HostPath volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn;
 * jobDefn.container.addVolume(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *         .name("emptyDir")
 *         .mountPath("/Volumes/emptyDir")
 *         .build()));
 * jobDefn.container.addVolume(EksVolume.hostPath(HostPathVolumeOptions.builder()
 *         .name("hostPath")
 *         .hostPath("/sys")
 *         .mountPath("/Volumes/hostPath")
 *         .build()));
 * jobDefn.container.addVolume(EksVolume.secret(SecretPathVolumeOptions.builder()
 *         .name("secret")
 *         .optional(true)
 *         .mountPath("/Volumes/secret")
 *         .secretName("mySecret")
 *         .build()));
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.892Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.HostPathVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(HostPathVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HostPathVolumeOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EksVolumeOptions {

    /**
     * The path of the file or directory on the host to mount into containers on the pod.
     * <p>
     * <em>Note</em>: HothPath Volumes present many security risks, and should be avoided when possible.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostPath();

    /**
     * @return a {@link Builder} of {@link HostPathVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostPathVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HostPathVolumeOptions> {
        java.lang.String hostPath;
        java.lang.String name;
        java.lang.String mountPath;
        java.lang.Boolean readonly;

        /**
         * Sets the value of {@link HostPathVolumeOptions#getHostPath}
         * @param hostPath The path of the file or directory on the host to mount into containers on the pod. This parameter is required.
         *                 <em>Note</em>: HothPath Volumes present many security risks, and should be avoided when possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(java.lang.String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        /**
         * Sets the value of {@link HostPathVolumeOptions#getName}
         * @param name The name of this volume. This parameter is required.
         *             The name must be a valid DNS subdomain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link HostPathVolumeOptions#getMountPath}
         * @param mountPath The path on the container where the volume is mounted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(java.lang.String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        /**
         * Sets the value of {@link HostPathVolumeOptions#getReadonly}
         * @param readonly If specified, the container has readonly access to the volume.
         *                 Otherwise, the container has read/write access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(java.lang.Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostPathVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HostPathVolumeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HostPathVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostPathVolumeOptions {
        private final java.lang.String hostPath;
        private final java.lang.String name;
        private final java.lang.String mountPath;
        private final java.lang.Boolean readonly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readonly = software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostPath = java.util.Objects.requireNonNull(builder.hostPath, "hostPath is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.mountPath = builder.mountPath;
            this.readonly = builder.readonly;
        }

        @Override
        public final java.lang.String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getMountPath() {
            return this.mountPath;
        }

        @Override
        public final java.lang.Boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostPath", om.valueToTree(this.getHostPath()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getMountPath() != null) {
                data.set("mountPath", om.valueToTree(this.getMountPath()));
            }
            if (this.getReadonly() != null) {
                data.set("readonly", om.valueToTree(this.getReadonly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.HostPathVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostPathVolumeOptions.Jsii$Proxy that = (HostPathVolumeOptions.Jsii$Proxy) o;

            if (!hostPath.equals(that.hostPath)) return false;
            if (!name.equals(that.name)) return false;
            if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) return false;
            return this.readonly != null ? this.readonly.equals(that.readonly) : that.readonly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostPath.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
            result = 31 * result + (this.readonly != null ? this.readonly.hashCode() : 0);
            return result;
        }
    }
}
