package software.amazon.awscdk.services.batch;

/**
 * Assigns an order to a ComputeEnvironment.
 * <p>
 * The JobQueue will prioritize the lowest-order ComputeEnvironment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * IComputeEnvironment computeEnvironment;
 * OrderedComputeEnvironment orderedComputeEnvironment = OrderedComputeEnvironment.builder()
 *         .computeEnvironment(computeEnvironment)
 *         .order(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.938Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.OrderedComputeEnvironment")
@software.amazon.jsii.Jsii.Proxy(OrderedComputeEnvironment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrderedComputeEnvironment extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ComputeEnvironment to link to this JobQueue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment getComputeEnvironment();

    /**
     * The order associated with <code>computeEnvironment</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getOrder();

    /**
     * @return a {@link Builder} of {@link OrderedComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrderedComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrderedComputeEnvironment> {
        software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment;
        java.lang.Number order;

        /**
         * Sets the value of {@link OrderedComputeEnvironment#getComputeEnvironment}
         * @param computeEnvironment The ComputeEnvironment to link to this JobQueue. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironment(software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link OrderedComputeEnvironment#getOrder}
         * @param order The order associated with <code>computeEnvironment</code>. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder order(java.lang.Number order) {
            this.order = order;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrderedComputeEnvironment}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrderedComputeEnvironment build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrderedComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrderedComputeEnvironment {
        private final software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment;
        private final java.lang.Number order;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironment = software.amazon.jsii.Kernel.get(this, "computeEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IComputeEnvironment.class));
            this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironment = java.util.Objects.requireNonNull(builder.computeEnvironment, "computeEnvironment is required");
            this.order = java.util.Objects.requireNonNull(builder.order, "order is required");
        }

        @Override
        public final software.amazon.awscdk.services.batch.IComputeEnvironment getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final java.lang.Number getOrder() {
            return this.order;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironment", om.valueToTree(this.getComputeEnvironment()));
            data.set("order", om.valueToTree(this.getOrder()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.OrderedComputeEnvironment"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrderedComputeEnvironment.Jsii$Proxy that = (OrderedComputeEnvironment.Jsii$Proxy) o;

            if (!computeEnvironment.equals(that.computeEnvironment)) return false;
            return this.order.equals(that.order);
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironment.hashCode();
            result = 31 * result + (this.order.hashCode());
            return result;
        }
    }
}
