package software.amazon.awscdk.services.bedrock;

/**
 * The model identifiers for the Bedrock base foundation models.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.ANTHROPIC_CLAUDE_V2);
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html">https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.955Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.FoundationModelIdentifier")
public class FoundationModelIdentifier extends software.amazon.jsii.JsiiObject {

    protected FoundationModelIdentifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FoundationModelIdentifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AI21_LABS_JURASSIC_2_MID_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_LABS_JURASSIC_2_MID_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_LABS_JURASSIC_2_ULTRA_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_LABS_JURASSIC_2_ULTRA_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_IMAGE_GENERATOR_G1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_IMAGE_GENERATOR_G1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_G1_EXPRESS_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_G1_EXPRESS_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_INSTANT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_INSTANT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_LIGHT_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_LIGHT_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_ENGLISH_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_ENGLISH_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_MULTILINGUAL_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_MULTILINGUAL_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_CHAT_13_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_CHAT_13B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_CHAT_70_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_CHAT_70B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL_V0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL_V0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
    }

    /**
     * Constructor for foundation model identifier.
     * <p>
     * @param modelId the model identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FoundationModelIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String modelId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(modelId, "modelId is required") });
    }

    /**
     * Base model "ai21.j2-mid-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_LABS_JURASSIC_2_MID_V1;

    /**
     * Base model "ai21.j2-ultra-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_LABS_JURASSIC_2_ULTRA_V1;

    /**
     * Base model "amazon.titan-embed-text-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1;

    /**
     * Base model "amazon.titan-image-generator-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_IMAGE_GENERATOR_G1_V1;

    /**
     * Base model "amazon.titan-embed-image-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1;

    /**
     * Base model "amazon.titan-text-express-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_G1_EXPRESS_V1;

    /**
     * Base model "anthropic.claude-instant-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_INSTANT_V1;

    /**
     * Base model "anthropic.claude-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V1;

    /**
     * Base model "anthropic.claude-v2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2;

    /**
     * Base model "anthropic.claude-v2:1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_1;

    /**
     * Base model "cohere.command-light-text-v14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_LIGHT_V14;

    /**
     * Base model "cohere.command-text-v14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_V14;

    /**
     * Base model "cohere.embed-english-v3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_ENGLISH_V3;

    /**
     * Base model "cohere.embed-multilingual-v3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_MULTILINGUAL_V3;

    /**
     * Base model "meta.llama2-13b-chat-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_CHAT_13_B_V1;

    /**
     * Base model "meta.llama2-70b-chat-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_CHAT_70_B_V1;

    /**
     * Base model "stability.stable-diffusion-xl-v0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL_V0;

    /**
     * Base model "stability.stable-diffusion-xl-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL_V1;

    /**
     * the model identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelId() {
        return software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
