package software.amazon.awscdk.services.cassandra;

/**
 * You can use the <code>AWS::Cassandra::Table</code> resource to create a new table in Amazon Keyspaces (for Apache Cassandra).
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/getting-started.ddl.html">Create a keyspace and a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .keyspaceName("keyspaceName")
 *         .partitionKeyColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         // the properties below are optional
 *         .autoScalingSpecifications(AutoScalingSpecificationProperty.builder()
 *                 .readCapacityAutoScaling(AutoScalingSettingProperty.builder()
 *                         .autoScalingDisabled(false)
 *                         .maximumUnits(123)
 *                         .minimumUnits(123)
 *                         .scalingPolicy(ScalingPolicyProperty.builder()
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .writeCapacityAutoScaling(AutoScalingSettingProperty.builder()
 *                         .autoScalingDisabled(false)
 *                         .maximumUnits(123)
 *                         .minimumUnits(123)
 *                         .scalingPolicy(ScalingPolicyProperty.builder()
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .billingMode(BillingModeProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                         .readCapacityUnits(123)
 *                         .writeCapacityUnits(123)
 *                         .build())
 *                 .build())
 *         .clientSideTimestampsEnabled(false)
 *         .clusteringKeyColumns(List.of(ClusteringKeyColumnProperty.builder()
 *                 .column(ColumnProperty.builder()
 *                         .columnName("columnName")
 *                         .columnType("columnType")
 *                         .build())
 *                 // the properties below are optional
 *                 .orderBy("orderBy")
 *                 .build()))
 *         .defaultTimeToLive(123)
 *         .encryptionSpecification(EncryptionSpecificationProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 // the properties below are optional
 *                 .kmsKeyIdentifier("kmsKeyIdentifier")
 *                 .build())
 *         .pointInTimeRecoveryEnabled(false)
 *         .regularColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         .replicaSpecifications(List.of(ReplicaSpecificationProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .readCapacityAutoScaling(AutoScalingSettingProperty.builder()
 *                         .autoScalingDisabled(false)
 *                         .maximumUnits(123)
 *                         .minimumUnits(123)
 *                         .scalingPolicy(ScalingPolicyProperty.builder()
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .readCapacityUnits(123)
 *                 .build()))
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:50.997Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cassandra.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cassandra.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the keyspace to create the table in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyspaceName() {
        return software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the keyspace to create the table in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyspaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyspaceName", java.util.Objects.requireNonNull(value, "keyspaceName is required"));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPartitionKeyColumns() {
        return software.amazon.jsii.Kernel.get(this, "partitionKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartitionKeyColumns(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "partitionKeyColumns", java.util.Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartitionKeyColumns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "partitionKeyColumns", java.util.Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    /**
     * The optional auto scaling capacity settings for a table in provisioned capacity mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The optional auto scaling capacity settings for a table in provisioned capacity mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingSpecifications", value);
    }

    /**
     * The optional auto scaling capacity settings for a table in provisioned capacity mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnTable.AutoScalingSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingSpecifications", value);
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBillingMode() {
        return software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnTable.BillingModeProperty value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * Enables client-side timestamps for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientSideTimestampsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "clientSideTimestampsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables client-side timestamps for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientSideTimestampsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "clientSideTimestampsEnabled", value);
    }

    /**
     * Enables client-side timestamps for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientSideTimestampsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientSideTimestampsEnabled", value);
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClusteringKeyColumns() {
        return software.amazon.jsii.Kernel.get(this, "clusteringKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusteringKeyColumns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clusteringKeyColumns", value);
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusteringKeyColumns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ClusteringKeyColumnProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ClusteringKeyColumnProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "clusteringKeyColumns", value);
    }

    /**
     * The default Time To Live (TTL) value for all rows in a table in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTimeToLive() {
        return software.amazon.jsii.Kernel.get(this, "defaultTimeToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default Time To Live (TTL) value for all rows in a table in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultTimeToLive(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "defaultTimeToLive", value);
    }

    /**
     * The encryption at rest options for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionSpecification() {
        return software.amazon.jsii.Kernel.get(this, "encryptionSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encryption at rest options for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionSpecification", value);
    }

    /**
     * The encryption at rest options for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnTable.EncryptionSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionSpecification", value);
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoveryEnabled() {
        return software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoveryEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoveryEnabled", value);
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoveryEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoveryEnabled", value);
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegularColumns() {
        return software.amazon.jsii.Kernel.get(this, "regularColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegularColumns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "regularColumns", value);
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegularColumns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "regularColumns", value);
    }

    /**
     * The AWS Region specific settings of a multi-Region table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicaSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "replicaSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS Region specific settings of a multi-Region table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicaSpecifications", value);
    }

    /**
     * The AWS Region specific settings of a multi-Region table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ReplicaSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ReplicaSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "replicaSpecifications", value);
    }

    /**
     * The name of the table to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The optional auto scaling settings for a table with provisioned throughput capacity.
     * <p>
     * To turn on auto scaling for a table in <code>throughputMode:PROVISIONED</code> , you must specify the following parameters.
     * <p>
     * Configure the minimum and maximum capacity units. The auto scaling policy ensures that capacity never goes below the minimum or above the maximum range.
     * <p>
     * <ul>
     * <li><code>minimumUnits</code> : The minimum level of throughput the table should always be ready to support. The value must be between 1 and the max throughput per second quota for your account (40,000 by default).</li>
     * <li><code>maximumUnits</code> : The maximum level of throughput the table should always be ready to support. The value must be between 1 and the max throughput per second quota for your account (40,000 by default).</li>
     * <li><code>scalingPolicy</code> : Amazon Keyspaces supports the <code>target tracking</code> scaling policy. The auto scaling target is a percentage of the provisioned capacity of the table.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput capacity automatically with Amazon Keyspaces auto scaling</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * AutoScalingSettingProperty autoScalingSettingProperty = AutoScalingSettingProperty.builder()
     *         .autoScalingDisabled(false)
     *         .maximumUnits(123)
     *         .minimumUnits(123)
     *         .scalingPolicy(ScalingPolicyProperty.builder()
     *                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                         .targetValue(123)
     *                         // the properties below are optional
     *                         .disableScaleIn(false)
     *                         .scaleInCooldown(123)
     *                         .scaleOutCooldown(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This optional parameter enables auto scaling for the table if set to <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-autoscalingdisabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-autoscalingdisabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingDisabled() {
            return null;
        }

        /**
         * Manage costs by specifying the maximum amount of throughput to provision.
         * <p>
         * The value must be between 1 and the max throughput per second quota for your account (40,000 by default).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-maximumunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-maximumunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumUnits() {
            return null;
        }

        /**
         * The minimum level of throughput the table should always be ready to support.
         * <p>
         * The value must be between 1 and the max throughput per second quota for your account (40,000 by default).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-minimumunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-minimumunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumUnits() {
            return null;
        }

        /**
         * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy.
         * <p>
         * With this policy, Amazon Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the target value that you specify. You define the target value as a percentage between 20 and 90.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-scalingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingsetting.html#cfn-cassandra-table-autoscalingsetting-scalingpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalingPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingSettingProperty> {
            java.lang.Object autoScalingDisabled;
            java.lang.Number maximumUnits;
            java.lang.Number minimumUnits;
            java.lang.Object scalingPolicy;

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getAutoScalingDisabled}
             * @param autoScalingDisabled This optional parameter enables auto scaling for the table if set to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingDisabled(java.lang.Boolean autoScalingDisabled) {
                this.autoScalingDisabled = autoScalingDisabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getAutoScalingDisabled}
             * @param autoScalingDisabled This optional parameter enables auto scaling for the table if set to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingDisabled(software.amazon.awscdk.IResolvable autoScalingDisabled) {
                this.autoScalingDisabled = autoScalingDisabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getMaximumUnits}
             * @param maximumUnits Manage costs by specifying the maximum amount of throughput to provision.
             *                     The value must be between 1 and the max throughput per second quota for your account (40,000 by default).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumUnits(java.lang.Number maximumUnits) {
                this.maximumUnits = maximumUnits;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getMinimumUnits}
             * @param minimumUnits The minimum level of throughput the table should always be ready to support.
             *                     The value must be between 1 and the max throughput per second quota for your account (40,000 by default).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumUnits(java.lang.Number minimumUnits) {
                this.minimumUnits = minimumUnits;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getScalingPolicy}
             * @param scalingPolicy Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy.
             *                      With this policy, Amazon Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the target value that you specify. You define the target value as a percentage between 20 and 90.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingPolicy(software.amazon.awscdk.IResolvable scalingPolicy) {
                this.scalingPolicy = scalingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSettingProperty#getScalingPolicy}
             * @param scalingPolicy Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy.
             *                      With this policy, Amazon Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the target value that you specify. You define the target value as a percentage between 20 and 90.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingPolicy(software.amazon.awscdk.services.cassandra.CfnTable.ScalingPolicyProperty scalingPolicy) {
                this.scalingPolicy = scalingPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingSettingProperty {
            private final java.lang.Object autoScalingDisabled;
            private final java.lang.Number maximumUnits;
            private final java.lang.Number minimumUnits;
            private final java.lang.Object scalingPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScalingDisabled = software.amazon.jsii.Kernel.get(this, "autoScalingDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumUnits = software.amazon.jsii.Kernel.get(this, "maximumUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumUnits = software.amazon.jsii.Kernel.get(this, "minimumUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scalingPolicy = software.amazon.jsii.Kernel.get(this, "scalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScalingDisabled = builder.autoScalingDisabled;
                this.maximumUnits = builder.maximumUnits;
                this.minimumUnits = builder.minimumUnits;
                this.scalingPolicy = builder.scalingPolicy;
            }

            @Override
            public final java.lang.Object getAutoScalingDisabled() {
                return this.autoScalingDisabled;
            }

            @Override
            public final java.lang.Number getMaximumUnits() {
                return this.maximumUnits;
            }

            @Override
            public final java.lang.Number getMinimumUnits() {
                return this.minimumUnits;
            }

            @Override
            public final java.lang.Object getScalingPolicy() {
                return this.scalingPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoScalingDisabled() != null) {
                    data.set("autoScalingDisabled", om.valueToTree(this.getAutoScalingDisabled()));
                }
                if (this.getMaximumUnits() != null) {
                    data.set("maximumUnits", om.valueToTree(this.getMaximumUnits()));
                }
                if (this.getMinimumUnits() != null) {
                    data.set("minimumUnits", om.valueToTree(this.getMinimumUnits()));
                }
                if (this.getScalingPolicy() != null) {
                    data.set("scalingPolicy", om.valueToTree(this.getScalingPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingSettingProperty.Jsii$Proxy that = (AutoScalingSettingProperty.Jsii$Proxy) o;

                if (this.autoScalingDisabled != null ? !this.autoScalingDisabled.equals(that.autoScalingDisabled) : that.autoScalingDisabled != null) return false;
                if (this.maximumUnits != null ? !this.maximumUnits.equals(that.maximumUnits) : that.maximumUnits != null) return false;
                if (this.minimumUnits != null ? !this.minimumUnits.equals(that.minimumUnits) : that.minimumUnits != null) return false;
                return this.scalingPolicy != null ? this.scalingPolicy.equals(that.scalingPolicy) : that.scalingPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoScalingDisabled != null ? this.autoScalingDisabled.hashCode() : 0;
                result = 31 * result + (this.maximumUnits != null ? this.maximumUnits.hashCode() : 0);
                result = 31 * result + (this.minimumUnits != null ? this.minimumUnits.hashCode() : 0);
                result = 31 * result + (this.scalingPolicy != null ? this.scalingPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The optional auto scaling capacity settings for a table in provisioned capacity mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * AutoScalingSpecificationProperty autoScalingSpecificationProperty = AutoScalingSpecificationProperty.builder()
     *         .readCapacityAutoScaling(AutoScalingSettingProperty.builder()
     *                 .autoScalingDisabled(false)
     *                 .maximumUnits(123)
     *                 .minimumUnits(123)
     *                 .scalingPolicy(ScalingPolicyProperty.builder()
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .writeCapacityAutoScaling(AutoScalingSettingProperty.builder()
     *                 .autoScalingDisabled(false)
     *                 .maximumUnits(123)
     *                 .minimumUnits(123)
     *                 .scalingPolicy(ScalingPolicyProperty.builder()
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The auto scaling settings for the table's read capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html#cfn-cassandra-table-autoscalingspecification-readcapacityautoscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html#cfn-cassandra-table-autoscalingspecification-readcapacityautoscaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadCapacityAutoScaling() {
            return null;
        }

        /**
         * The auto scaling settings for the table's write capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html#cfn-cassandra-table-autoscalingspecification-writecapacityautoscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-autoscalingspecification.html#cfn-cassandra-table-autoscalingspecification-writecapacityautoscaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteCapacityAutoScaling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingSpecificationProperty> {
            java.lang.Object readCapacityAutoScaling;
            java.lang.Object writeCapacityAutoScaling;

            /**
             * Sets the value of {@link AutoScalingSpecificationProperty#getReadCapacityAutoScaling}
             * @param readCapacityAutoScaling The auto scaling settings for the table's read capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScaling(software.amazon.awscdk.IResolvable readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSpecificationProperty#getReadCapacityAutoScaling}
             * @param readCapacityAutoScaling The auto scaling settings for the table's read capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScaling(software.amazon.awscdk.services.cassandra.CfnTable.AutoScalingSettingProperty readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSpecificationProperty#getWriteCapacityAutoScaling}
             * @param writeCapacityAutoScaling The auto scaling settings for the table's write capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityAutoScaling(software.amazon.awscdk.IResolvable writeCapacityAutoScaling) {
                this.writeCapacityAutoScaling = writeCapacityAutoScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingSpecificationProperty#getWriteCapacityAutoScaling}
             * @param writeCapacityAutoScaling The auto scaling settings for the table's write capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityAutoScaling(software.amazon.awscdk.services.cassandra.CfnTable.AutoScalingSettingProperty writeCapacityAutoScaling) {
                this.writeCapacityAutoScaling = writeCapacityAutoScaling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingSpecificationProperty {
            private final java.lang.Object readCapacityAutoScaling;
            private final java.lang.Object writeCapacityAutoScaling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readCapacityAutoScaling = software.amazon.jsii.Kernel.get(this, "readCapacityAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeCapacityAutoScaling = software.amazon.jsii.Kernel.get(this, "writeCapacityAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityAutoScaling = builder.readCapacityAutoScaling;
                this.writeCapacityAutoScaling = builder.writeCapacityAutoScaling;
            }

            @Override
            public final java.lang.Object getReadCapacityAutoScaling() {
                return this.readCapacityAutoScaling;
            }

            @Override
            public final java.lang.Object getWriteCapacityAutoScaling() {
                return this.writeCapacityAutoScaling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReadCapacityAutoScaling() != null) {
                    data.set("readCapacityAutoScaling", om.valueToTree(this.getReadCapacityAutoScaling()));
                }
                if (this.getWriteCapacityAutoScaling() != null) {
                    data.set("writeCapacityAutoScaling", om.valueToTree(this.getWriteCapacityAutoScaling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingSpecificationProperty.Jsii$Proxy that = (AutoScalingSpecificationProperty.Jsii$Proxy) o;

                if (this.readCapacityAutoScaling != null ? !this.readCapacityAutoScaling.equals(that.readCapacityAutoScaling) : that.readCapacityAutoScaling != null) return false;
                return this.writeCapacityAutoScaling != null ? this.writeCapacityAutoScaling.equals(that.writeCapacityAutoScaling) : that.writeCapacityAutoScaling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.readCapacityAutoScaling != null ? this.readCapacityAutoScaling.hashCode() : 0;
                result = 31 * result + (this.writeCapacityAutoScaling != null ? this.writeCapacityAutoScaling.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines the billing mode for the table - on-demand or provisioned.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * BillingModeProperty billingModeProperty = BillingModeProperty.builder()
     *         .mode("mode")
     *         // the properties below are optional
     *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                 .readCapacityUnits(123)
     *                 .writeCapacityUnits(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.BillingModeProperty")
    @software.amazon.jsii.Jsii.Proxy(BillingModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BillingModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The billing mode for the table:.
         * <p>
         * <ul>
         * <li>On-demand mode - <code>ON_DEMAND</code></li>
         * <li>Provisioned mode - <code>PROVISIONED</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>PROVISIONED</code> mode, then you also need to specify provisioned throughput (read and write capacity) for the table.
         * <p>
         * </blockquote>
         * <p>
         * Valid values: <code>ON_DEMAND</code> | <code>PROVISIONED</code>
         * <p>
         * Default: - "ON_DEMAND"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * The provisioned read capacity and write capacity for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-provisionedthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-provisionedthroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BillingModeProperty> {
            java.lang.String mode;
            java.lang.Object provisionedThroughput;

            /**
             * Sets the value of {@link BillingModeProperty#getMode}
             * @param mode The billing mode for the table:. This parameter is required.
             *             <ul>
             *             <li>On-demand mode - <code>ON_DEMAND</code></li>
             *             <li>Provisioned mode - <code>PROVISIONED</code></li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             If you choose <code>PROVISIONED</code> mode, then you also need to specify provisioned throughput (read and write capacity) for the table.
             *             <p>
             *             </blockquote>
             *             <p>
             *             Valid values: <code>ON_DEMAND</code> | <code>PROVISIONED</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link BillingModeProperty#getProvisionedThroughput}
             * @param provisionedThroughput The provisioned read capacity and write capacity for the table.
             *                              For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link BillingModeProperty#getProvisionedThroughput}
             * @param provisionedThroughput The provisioned read capacity and write capacity for the table.
             *                              For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.services.cassandra.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BillingModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BillingModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BillingModeProperty {
            private final java.lang.String mode;
            private final java.lang.Object provisionedThroughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.provisionedThroughput = builder.provisionedThroughput;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getProvisionedThroughput() {
                return this.provisionedThroughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getProvisionedThroughput() != null) {
                    data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.BillingModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BillingModeProperty.Jsii$Proxy that = (BillingModeProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.provisionedThroughput != null ? this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an individual column within the clustering key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ClusteringKeyColumnProperty clusteringKeyColumnProperty = ClusteringKeyColumnProperty.builder()
     *         .column(ColumnProperty.builder()
     *                 .columnName("columnName")
     *                 .columnType("columnType")
     *                 .build())
     *         // the properties below are optional
     *         .orderBy("orderBy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ClusteringKeyColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusteringKeyColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusteringKeyColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name and data type of this clustering key column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The order in which this column's data is stored:.
         * <p>
         * <ul>
         * <li><code>ASC</code> (default) - The column's data is stored in ascending order.</li>
         * <li><code>DESC</code> - The column's data is stored in descending order.</li>
         * </ul>
         * <p>
         * Default: - "ASC"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-orderby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-orderby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrderBy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusteringKeyColumnProperty> {
            java.lang.Object column;
            java.lang.String orderBy;

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getColumn}
             * @param column The name and data type of this clustering key column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getColumn}
             * @param column The name and data type of this clustering key column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getOrderBy}
             * @param orderBy The order in which this column's data is stored:.
             *                <ul>
             *                <li><code>ASC</code> (default) - The column's data is stored in ascending order.</li>
             *                <li><code>DESC</code> - The column's data is stored in descending order.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderBy(java.lang.String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusteringKeyColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusteringKeyColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusteringKeyColumnProperty {
            private final java.lang.Object column;
            private final java.lang.String orderBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orderBy = software.amazon.jsii.Kernel.get(this, "orderBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.orderBy = builder.orderBy;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getOrderBy() {
                return this.orderBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                if (this.getOrderBy() != null) {
                    data.set("orderBy", om.valueToTree(this.getOrderBy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ClusteringKeyColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusteringKeyColumnProperty.Jsii$Proxy that = (ClusteringKeyColumnProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                return this.orderBy != null ? this.orderBy.equals(that.orderBy) : that.orderBy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The name and data type of an individual column in a table.
     * <p>
     * In addition to the data type, you can also use the following two keywords:
     * <p>
     * <ul>
     * <li><code>STATIC</code> if the table has a clustering column. Static columns store values that are shared by all rows in the same partition.</li>
     * <li><code>FROZEN</code> for collection data types. In frozen collections the values of the collection are serialized into a single immutable value, and Amazon Keyspaces treats them like a <code>BLOB</code> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ColumnProperty columnProperty = ColumnProperty.builder()
     *         .columnName("columnName")
     *         .columnType("columnType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.elements.identifier">Identifiers</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The data type of the column.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columntype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columntype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnType();

        /**
         * @return a {@link Builder} of {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnProperty> {
            java.lang.String columnName;
            java.lang.String columnType;

            /**
             * Sets the value of {@link ColumnProperty#getColumnName}
             * @param columnName The name of the column. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.elements.identifier">Identifiers</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnProperty#getColumnType}
             * @param columnType The data type of the column. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnType(java.lang.String columnType) {
                this.columnType = columnType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnProperty {
            private final java.lang.String columnName;
            private final java.lang.String columnType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnType = software.amazon.jsii.Kernel.get(this, "columnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.columnType = java.util.Objects.requireNonNull(builder.columnType, "columnType is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getColumnType() {
                return this.columnType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("columnType", om.valueToTree(this.getColumnType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnProperty.Jsii$Proxy that = (ColumnProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.columnType.equals(that.columnType);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.columnType.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the encryption at rest option selected for the table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * EncryptionSpecificationProperty encryptionSpecificationProperty = EncryptionSpecificationProperty.builder()
     *         .encryptionType("encryptionType")
     *         // the properties below are optional
     *         .kmsKeyIdentifier("kmsKeyIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.EncryptionSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - <code>AWS_OWNED_KMS_KEY</code></li>
         * <li><em>Customer managed key</em> - <code>CUSTOMER_MANAGED_KMS_KEY</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>CUSTOMER_MANAGED_KMS_KEY</code> , a <code>kms_key_identifier</code> in the format of a key ARN is required.
         * <p>
         * </blockquote>
         * <p>
         * Valid values: <code>CUSTOMER_MANAGED_KMS_KEY</code> | <code>AWS_OWNED_KMS_KEY</code> .
         * <p>
         * Default: - "AWS_OWNED_KMS_KEY"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html#cfn-cassandra-table-encryptionspecification-encryptiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html#cfn-cassandra-table-encryptionspecification-encryptiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * Requires a <code>kms_key_identifier</code> in the format of a key ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html#cfn-cassandra-table-encryptionspecification-kmskeyidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-encryptionspecification.html#cfn-cassandra-table-encryptionspecification-kmskeyidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionSpecificationProperty> {
            java.lang.String encryptionType;
            java.lang.String kmsKeyIdentifier;

            /**
             * Sets the value of {@link EncryptionSpecificationProperty#getEncryptionType}
             * @param encryptionType The encryption at rest options for the table. This parameter is required.
             *                       <ul>
             *                       <li><em>AWS owned key</em> (default) - <code>AWS_OWNED_KMS_KEY</code></li>
             *                       <li><em>Customer managed key</em> - <code>CUSTOMER_MANAGED_KMS_KEY</code></li>
             *                       </ul>
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       If you choose <code>CUSTOMER_MANAGED_KMS_KEY</code> , a <code>kms_key_identifier</code> in the format of a key ARN is required.
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       Valid values: <code>CUSTOMER_MANAGED_KMS_KEY</code> | <code>AWS_OWNED_KMS_KEY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionSpecificationProperty#getKmsKeyIdentifier}
             * @param kmsKeyIdentifier Requires a <code>kms_key_identifier</code> in the format of a key ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyIdentifier(java.lang.String kmsKeyIdentifier) {
                this.kmsKeyIdentifier = kmsKeyIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionSpecificationProperty {
            private final java.lang.String encryptionType;
            private final java.lang.String kmsKeyIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = software.amazon.jsii.Kernel.get(this, "encryptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyIdentifier = software.amazon.jsii.Kernel.get(this, "kmsKeyIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(builder.encryptionType, "encryptionType is required");
                this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
            }

            @Override
            public final java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            public final java.lang.String getKmsKeyIdentifier() {
                return this.kmsKeyIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));
                if (this.getKmsKeyIdentifier() != null) {
                    data.set("kmsKeyIdentifier", om.valueToTree(this.getKmsKeyIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.EncryptionSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionSpecificationProperty.Jsii$Proxy that = (EncryptionSpecificationProperty.Jsii$Proxy) o;

                if (!encryptionType.equals(that.encryptionType)) return false;
                return this.kmsKeyIdentifier != null ? this.kmsKeyIdentifier.equals(that.kmsKeyIdentifier) : that.kmsKeyIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionType.hashCode();
                result = 31 * result + (this.kmsKeyIdentifier != null ? this.kmsKeyIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The provisioned throughput for the table, which consists of <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ProvisionedThroughputProperty provisionedThroughputProperty = ProvisionedThroughputProperty.builder()
     *         .readCapacityUnits(123)
     *         .writeCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of read capacity that's provisioned for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-readcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-readcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getReadCapacityUnits();

        /**
         * The amount of write capacity that's provisioned for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-writecapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-writecapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWriteCapacityUnits();

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            java.lang.Number readCapacityUnits;
            java.lang.Number writeCapacityUnits;

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getReadCapacityUnits}
             * @param readCapacityUnits The amount of read capacity that's provisioned for the table. This parameter is required.
             *                          For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getWriteCapacityUnits}
             * @param writeCapacityUnits The amount of write capacity that's provisioned for the table. This parameter is required.
             *                           For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityUnits(java.lang.Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedThroughputProperty {
            private final java.lang.Number readCapacityUnits;
            private final java.lang.Number writeCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readCapacityUnits = software.amazon.jsii.Kernel.get(this, "readCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writeCapacityUnits = software.amazon.jsii.Kernel.get(this, "writeCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityUnits = java.util.Objects.requireNonNull(builder.readCapacityUnits, "readCapacityUnits is required");
                this.writeCapacityUnits = java.util.Objects.requireNonNull(builder.writeCapacityUnits, "writeCapacityUnits is required");
            }

            @Override
            public final java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            public final java.lang.Number getWriteCapacityUnits() {
                return this.writeCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                data.set("writeCapacityUnits", om.valueToTree(this.getWriteCapacityUnits()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ProvisionedThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedThroughputProperty.Jsii$Proxy that = (ProvisionedThroughputProperty.Jsii$Proxy) o;

                if (!readCapacityUnits.equals(that.readCapacityUnits)) return false;
                return this.writeCapacityUnits.equals(that.writeCapacityUnits);
            }

            @Override
            public final int hashCode() {
                int result = this.readCapacityUnits.hashCode();
                result = 31 * result + (this.writeCapacityUnits.hashCode());
                return result;
            }
        }
    }
    /**
     * The AWS Region specific settings of a multi-Region table.
     * <p>
     * For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.
     * <p>
     * <ul>
     * <li><code>region</code> : The Region where these settings are applied. (Required)</li>
     * <li><code>readCapacityUnits</code> : The provisioned read capacity units. (Optional)</li>
     * <li><code>readCapacityAutoScaling</code> : The read capacity auto scaling settings for the table. (Optional)</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ReplicaSpecificationProperty replicaSpecificationProperty = ReplicaSpecificationProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .readCapacityAutoScaling(AutoScalingSettingProperty.builder()
     *                 .autoScalingDisabled(false)
     *                 .maximumUnits(123)
     *                 .minimumUnits(123)
     *                 .scalingPolicy(ScalingPolicyProperty.builder()
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .readCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ReplicaSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The read capacity auto scaling settings for the multi-Region table in the specified AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-readcapacityautoscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-readcapacityautoscaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadCapacityAutoScaling() {
            return null;
        }

        /**
         * The provisioned read capacity units for the multi-Region table in the specified AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-readcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-replicaspecification.html#cfn-cassandra-table-replicaspecification-readcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReadCapacityUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaSpecificationProperty> {
            java.lang.String region;
            java.lang.Object readCapacityAutoScaling;
            java.lang.Number readCapacityUnits;

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getRegion}
             * @param region The AWS Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadCapacityAutoScaling}
             * @param readCapacityAutoScaling The read capacity auto scaling settings for the multi-Region table in the specified AWS Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScaling(software.amazon.awscdk.IResolvable readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadCapacityAutoScaling}
             * @param readCapacityAutoScaling The read capacity auto scaling settings for the multi-Region table in the specified AWS Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScaling(software.amazon.awscdk.services.cassandra.CfnTable.AutoScalingSettingProperty readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadCapacityUnits}
             * @param readCapacityUnits The provisioned read capacity units for the multi-Region table in the specified AWS Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaSpecificationProperty {
            private final java.lang.String region;
            private final java.lang.Object readCapacityAutoScaling;
            private final java.lang.Number readCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readCapacityAutoScaling = software.amazon.jsii.Kernel.get(this, "readCapacityAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readCapacityUnits = software.amazon.jsii.Kernel.get(this, "readCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.readCapacityAutoScaling = builder.readCapacityAutoScaling;
                this.readCapacityUnits = builder.readCapacityUnits;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.Object getReadCapacityAutoScaling() {
                return this.readCapacityAutoScaling;
            }

            @Override
            public final java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getReadCapacityAutoScaling() != null) {
                    data.set("readCapacityAutoScaling", om.valueToTree(this.getReadCapacityAutoScaling()));
                }
                if (this.getReadCapacityUnits() != null) {
                    data.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ReplicaSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaSpecificationProperty.Jsii$Proxy that = (ReplicaSpecificationProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                if (this.readCapacityAutoScaling != null ? !this.readCapacityAutoScaling.equals(that.readCapacityAutoScaling) : that.readCapacityAutoScaling != null) return false;
                return this.readCapacityUnits != null ? this.readCapacityUnits.equals(that.readCapacityUnits) : that.readCapacityUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.readCapacityAutoScaling != null ? this.readCapacityAutoScaling.hashCode() : 0);
                result = 31 * result + (this.readCapacityUnits != null ? this.readCapacityUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy.
     * <p>
     * With this policy, Amazon Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the target value that you specify. You define the target value as a percentage between 20 and 90.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ScalingPolicyProperty scalingPolicyProperty = ScalingPolicyProperty.builder()
     *         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                 .targetValue(123)
     *                 // the properties below are optional
     *                 .disableScaleIn(false)
     *                 .scaleInCooldown(123)
     *                 .scaleOutCooldown(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-scalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-scalingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The auto scaling policy that scales a table based on the ratio of consumed to provisioned capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-scalingpolicy.html#cfn-cassandra-table-scalingpolicy-targettrackingscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-scalingpolicy.html#cfn-cassandra-table-scalingpolicy-targettrackingscalingpolicyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingPolicyProperty> {
            java.lang.Object targetTrackingScalingPolicyConfiguration;

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetTrackingScalingPolicyConfiguration}
             * @param targetTrackingScalingPolicyConfiguration The auto scaling policy that scales a table based on the ratio of consumed to provisioned capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.IResolvable targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetTrackingScalingPolicyConfiguration}
             * @param targetTrackingScalingPolicyConfiguration The auto scaling policy that scales a table based on the ratio of consumed to provisioned capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.services.cassandra.CfnTable.TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingPolicyProperty {
            private final java.lang.Object targetTrackingScalingPolicyConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetTrackingScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "targetTrackingScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
            }

            @Override
            public final java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
                return this.targetTrackingScalingPolicyConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetTrackingScalingPolicyConfiguration() != null) {
                    data.set("targetTrackingScalingPolicyConfiguration", om.valueToTree(this.getTargetTrackingScalingPolicyConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingPolicyProperty.Jsii$Proxy that = (ScalingPolicyProperty.Jsii$Proxy) o;

                return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.equals(that.targetTrackingScalingPolicyConfiguration) : that.targetTrackingScalingPolicyConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy for a provisioned table.
     * <p>
     * This policy scales a table based on the ratio of consumed to provisioned capacity. The auto scaling target is a percentage of the provisioned capacity of the table.
     * <p>
     * <ul>
     * <li><code>targetTrackingScalingPolicyConfiguration</code> : To define the target tracking policy, you must define the target value.</li>
     * <li><code>targetValue</code> : The target utilization rate of the table. Amazon Keyspaces auto scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define <code>targetValue</code> as a percentage. A <code>double</code> between 20 and 90. (Required)</li>
     * <li><code>disableScaleIn</code> : A <code>boolean</code> that specifies if <code>scale-in</code> is disabled or enabled for the table. This parameter is disabled by default. To turn on <code>scale-in</code> , set the <code>boolean</code> value to <code>FALSE</code> . This means that capacity for a table can be automatically scaled down on your behalf. (Optional)</li>
     * <li><code>scaleInCooldown</code> : A cooldown period in seconds between scaling activities that lets the table stabilize before another scale in activity starts. If no value is provided, the default is 0. (Optional)</li>
     * <li><code>scaleOutCooldown</code> : A cooldown period in seconds between scaling activities that lets the table stabilize before another scale out activity starts. If no value is provided, the default is 0. (Optional)</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfigurationProperty = TargetTrackingScalingPolicyConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .disableScaleIn(false)
     *         .scaleInCooldown(123)
     *         .scaleOutCooldown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.TargetTrackingScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the target value for the target tracking auto scaling policy.
         * <p>
         * Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then back down when it falls below the target. This ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define <code>targetValue</code> as a percentage. An <code>integer</code> between 20 and 90.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * Specifies if <code>scale-in</code> is enabled.
         * <p>
         * When auto scaling automatically decreases capacity for a table, the table <em>scales in</em> . When scaling policies are set, they can't scale in the table lower than its minimum capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-disablescalein">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-disablescalein</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * Specifies a <code>scale-in</code> cool down period.
         * <p>
         * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling activity starts.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-scaleincooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-scaleincooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * Specifies a scale out cool down period.
         * <p>
         * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling activity starts.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-scaleoutcooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-targettrackingscalingpolicyconfiguration.html#cfn-cassandra-table-targettrackingscalingpolicyconfiguration-scaleoutcooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object disableScaleIn;
            java.lang.Number scaleInCooldown;
            java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getTargetValue}
             * @param targetValue Specifies the target value for the target tracking auto scaling policy. This parameter is required.
             *                    Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then back down when it falls below the target. This ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define <code>targetValue</code> as a percentage. An <code>integer</code> between 20 and 90.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Specifies if <code>scale-in</code> is enabled.
             *                       When auto scaling automatically decreases capacity for a table, the table <em>scales in</em> . When scaling policies are set, they can't scale in the table lower than its minimum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Specifies if <code>scale-in</code> is enabled.
             *                       When auto scaling automatically decreases capacity for a table, the table <em>scales in</em> . When scaling policies are set, they can't scale in the table lower than its minimum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleInCooldown}
             * @param scaleInCooldown Specifies a <code>scale-in</code> cool down period.
             *                        A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling activity starts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleOutCooldown}
             * @param scaleOutCooldown Specifies a scale out cool down period.
             *                         A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling activity starts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.disableScaleIn = builder.disableScaleIn;
                this.scaleInCooldown = builder.scaleInCooldown;
                this.scaleOutCooldown = builder.scaleOutCooldown;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public final java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.TargetTrackingScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy that = (TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cassandra.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cassandra.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cassandra.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cassandra.CfnTableProps.Builder();
        }

        /**
         * The name of the keyspace to create the table in.
         * <p>
         * The keyspace must already exist.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-keyspacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-keyspacename</a>
         * @param keyspaceName The name of the keyspace to create the table in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(final java.lang.String keyspaceName) {
            this.props.keyspaceName(keyspaceName);
            return this;
        }

        /**
         * One or more columns that uniquely identify every row in the table.
         * <p>
         * Every table must have a partition key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns</a>
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(final software.amazon.awscdk.IResolvable partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }
        /**
         * One or more columns that uniquely identify every row in the table.
         * <p>
         * Every table must have a partition key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns</a>
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(final java.util.List<? extends java.lang.Object> partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        /**
         * The optional auto scaling capacity settings for a table in provisioned capacity mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-autoscalingspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-autoscalingspecifications</a>
         * @param autoScalingSpecifications The optional auto scaling capacity settings for a table in provisioned capacity mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingSpecifications(final software.amazon.awscdk.IResolvable autoScalingSpecifications) {
            this.props.autoScalingSpecifications(autoScalingSpecifications);
            return this;
        }
        /**
         * The optional auto scaling capacity settings for a table in provisioned capacity mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-autoscalingspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-autoscalingspecifications</a>
         * @param autoScalingSpecifications The optional auto scaling capacity settings for a table in provisioned capacity mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingSpecifications(final software.amazon.awscdk.services.cassandra.CfnTable.AutoScalingSpecificationProperty autoScalingSpecifications) {
            this.props.autoScalingSpecifications(autoScalingSpecifications);
            return this;
        }

        /**
         * The billing mode for the table, which determines how you'll be charged for reads and writes:.
         * <p>
         * <ul>
         * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, then the table will use on-demand mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode</a>
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.IResolvable billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }
        /**
         * The billing mode for the table, which determines how you'll be charged for reads and writes:.
         * <p>
         * <ul>
         * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, then the table will use on-demand mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode</a>
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.services.cassandra.CfnTable.BillingModeProperty billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * Enables client-side timestamps for the table.
         * <p>
         * By default, the setting is disabled. You can enable client-side timestamps with the following option:
         * <p>
         * <ul>
         * <li><code>status: "enabled"</code></li>
         * </ul>
         * <p>
         * After client-side timestamps are enabled for a table, you can't disable this setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clientsidetimestampsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clientsidetimestampsenabled</a>
         * @param clientSideTimestampsEnabled Enables client-side timestamps for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(final java.lang.Boolean clientSideTimestampsEnabled) {
            this.props.clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }
        /**
         * Enables client-side timestamps for the table.
         * <p>
         * By default, the setting is disabled. You can enable client-side timestamps with the following option:
         * <p>
         * <ul>
         * <li><code>status: "enabled"</code></li>
         * </ul>
         * <p>
         * After client-side timestamps are enabled for a table, you can't disable this setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clientsidetimestampsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clientsidetimestampsenabled</a>
         * @param clientSideTimestampsEnabled Enables client-side timestamps for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(final software.amazon.awscdk.IResolvable clientSideTimestampsEnabled) {
            this.props.clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }

        /**
         * One or more columns that determine how the table data is sorted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns</a>
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(final software.amazon.awscdk.IResolvable clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }
        /**
         * One or more columns that determine how the table data is sorted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns</a>
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(final java.util.List<? extends java.lang.Object> clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        /**
         * The default Time To Live (TTL) value for all rows in a table in seconds.
         * <p>
         * The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-defaulttimetolive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-defaulttimetolive</a>
         * @param defaultTimeToLive The default Time To Live (TTL) value for all rows in a table in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTimeToLive(final java.lang.Number defaultTimeToLive) {
            this.props.defaultTimeToLive(defaultTimeToLive);
            return this;
        }

        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces .</li>
         * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-encryptionspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-encryptionspecification</a>
         * @param encryptionSpecification The encryption at rest options for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(final software.amazon.awscdk.IResolvable encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }
        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces .</li>
         * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-encryptionspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-encryptionspecification</a>
         * @param encryptionSpecification The encryption at rest options for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(final software.amazon.awscdk.services.cassandra.CfnTable.EncryptionSpecificationProperty encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }

        /**
         * Specifies if point-in-time recovery is enabled or disabled for the table.
         * <p>
         * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-pointintimerecoveryenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-pointintimerecoveryenabled</a>
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(final java.lang.Boolean pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }
        /**
         * Specifies if point-in-time recovery is enabled or disabled for the table.
         * <p>
         * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-pointintimerecoveryenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-pointintimerecoveryenabled</a>
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(final software.amazon.awscdk.IResolvable pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        /**
         * One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns.
         * <p>
         * You can add regular columns to existing tables by adding them to the template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns</a>
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(final software.amazon.awscdk.IResolvable regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }
        /**
         * One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns.
         * <p>
         * You can add regular columns to existing tables by adding them to the template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns</a>
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are <em>not</em> defined as partition key columns or clustering key columns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(final java.util.List<? extends java.lang.Object> regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        /**
         * The AWS Region specific settings of a multi-Region table.
         * <p>
         * For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.
         * <p>
         * <ul>
         * <li><code>region</code> : The Region where these settings are applied. (Required)</li>
         * <li><code>readCapacityUnits</code> : The provisioned read capacity units. (Optional)</li>
         * <li><code>readCapacityAutoScaling</code> : The read capacity auto scaling settings for the table. (Optional)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-replicaspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-replicaspecifications</a>
         * @param replicaSpecifications The AWS Region specific settings of a multi-Region table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaSpecifications(final software.amazon.awscdk.IResolvable replicaSpecifications) {
            this.props.replicaSpecifications(replicaSpecifications);
            return this;
        }
        /**
         * The AWS Region specific settings of a multi-Region table.
         * <p>
         * For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.
         * <p>
         * <ul>
         * <li><code>region</code> : The Region where these settings are applied. (Required)</li>
         * <li><code>readCapacityUnits</code> : The provisioned read capacity units. (Optional)</li>
         * <li><code>readCapacityAutoScaling</code> : The read capacity auto scaling settings for the table. (Optional)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-replicaspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-replicaspecifications</a>
         * @param replicaSpecifications The AWS Region specific settings of a multi-Region table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaSpecifications(final java.util.List<? extends java.lang.Object> replicaSpecifications) {
            this.props.replicaSpecifications(replicaSpecifications);
            return this;
        }

        /**
         * The name of the table to be created.
         * <p>
         * The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacing this resource. You can perform updates that require no interruption or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
         * <p>
         * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tablename</a>
         * @param tableName The name of the table to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cassandra.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cassandra.CfnTable build() {
            return new software.amazon.awscdk.services.cassandra.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
