package software.amazon.awscdk.services.cloudfront;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * CloudFrontWebDistribution distribution = CloudFrontWebDistribution.Builder.create(this, "AnAmazingWebsiteProbably")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder().s3BucketSource(s3BucketSource).build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .viewerCertificate(ViewerCertificate.fromIamCertificate("certificateId", ViewerCertificateOptions.builder()
 *                 .aliases(List.of("example.com"))
 *                 .securityPolicy(SecurityPolicyProtocol.SSL_V3) // default
 *                 .sslMethod(SSLMethod.SNI)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.322Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ViewerCertificateOptions")
@software.amazon.jsii.Jsii.Proxy(ViewerCertificateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ViewerCertificateOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Domain names on the certificate (both main domain name and Subject Alternative names).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
        return null;
    }

    /**
     * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     * <p>
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     * <p>
     * Default: - SSLv3 if sslMethod VIP, TLSv1 if sslMethod SNI
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getSecurityPolicy() {
        return null;
    }

    /**
     * How CloudFront should serve HTTPS requests.
     * <p>
     * See the notes on SSLMethod if you wish to use other SSL termination types.
     * <p>
     * Default: SSLMethod.SNI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ViewerCertificate.html">https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ViewerCertificate.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SSLMethod getSslMethod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ViewerCertificateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ViewerCertificateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ViewerCertificateOptions> {
        java.util.List<java.lang.String> aliases;
        software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy;
        software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod;

        /**
         * Sets the value of {@link ViewerCertificateOptions#getAliases}
         * @param aliases Domain names on the certificate (both main domain name and Subject Alternative names).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliases(java.util.List<java.lang.String> aliases) {
            this.aliases = aliases;
            return this;
        }

        /**
         * Sets the value of {@link ViewerCertificateOptions#getSecurityPolicy}
         * @param securityPolicy The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
         *                       CloudFront serves your objects only to browsers or devices that support at
         *                       least the SSL version that you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ViewerCertificateOptions#getSslMethod}
         * @param sslMethod How CloudFront should serve HTTPS requests.
         *                  See the notes on SSLMethod if you wish to use other SSL termination types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslMethod(software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod) {
            this.sslMethod = sslMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ViewerCertificateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ViewerCertificateOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ViewerCertificateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ViewerCertificateOptions {
        private final java.util.List<java.lang.String> aliases;
        private final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy;
        private final software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol.class));
            this.sslMethod = software.amazon.jsii.Kernel.get(this, "sslMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.SSLMethod.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliases = builder.aliases;
            this.securityPolicy = builder.securityPolicy;
            this.sslMethod = builder.sslMethod;
        }

        @Override
        public final java.util.List<java.lang.String> getAliases() {
            return this.aliases;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.SSLMethod getSslMethod() {
            return this.sslMethod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAliases() != null) {
                data.set("aliases", om.valueToTree(this.getAliases()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }
            if (this.getSslMethod() != null) {
                data.set("sslMethod", om.valueToTree(this.getSslMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ViewerCertificateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ViewerCertificateOptions.Jsii$Proxy that = (ViewerCertificateOptions.Jsii$Proxy) o;

            if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
            if (this.securityPolicy != null ? !this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy != null) return false;
            return this.sslMethod != null ? this.sslMethod.equals(that.sslMethod) : that.sslMethod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aliases != null ? this.aliases.hashCode() : 0;
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            result = 31 * result + (this.sslMethod != null ? this.sslMethod.hashCode() : 0);
            return result;
        }
    }
}
