package software.amazon.awscdk.services.cloudtrail;

/**
 * Cloud trail allows you to log events that happen in your AWS account For example:.
 * <p>
 * import { CloudTrail } from 'aws-cdk-lib/aws-cloudtrail'
 * <p>
 * const cloudTrail = new CloudTrail(this, 'MyTrail');
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudtrail.*;
 * IAlias myKeyAlias = Alias.fromAliasName(this, "myKey", "alias/aws/s3");
 * Trail trail = Trail.Builder.create(this, "myCloudTrail")
 *         .sendToCloudWatchLogs(true)
 *         .encryptionKey(myKeyAlias)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.408Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.Trail")
public class Trail extends software.amazon.awscdk.Resource {

    protected Trail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Trail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Trail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.TrailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Trail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Create an event rule for when an event is recorded by any Trail in the account.
     * <p>
     * Note that the event doesn't necessarily have to come from this Trail, it can
     * be captured from any one.
     * <p>
     * Be sure to filter the event further down using an event pattern.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudtrail.Trail.class, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Create an event rule for when an event is recorded by any Trail in the account.
     * <p>
     * Note that the event doesn't necessarily have to come from this Trail, it can
     * be captured from any one.
     * <p>
     * Be sure to filter the event further down using an event pattern.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudtrail.Trail.class, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds an Event Selector for filtering events that match either S3 or Lambda function operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param dataResourceType This parameter is required.
     * @param dataResourceValues the list of data resource ARNs to include in logging (maximum 250 entries). This parameter is required.
     * @param options the options to configure logging of management and data events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventSelector(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudtrail.DataResourceType dataResourceType, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> dataResourceValues, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions options) {
        software.amazon.jsii.Kernel.call(this, "addEventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dataResourceType, "dataResourceType is required"), java.util.Objects.requireNonNull(dataResourceValues, "dataResourceValues is required"), options });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds an Event Selector for filtering events that match either S3 or Lambda function operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param dataResourceType This parameter is required.
     * @param dataResourceValues the list of data resource ARNs to include in logging (maximum 250 entries). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventSelector(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudtrail.DataResourceType dataResourceType, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> dataResourceValues) {
        software.amazon.jsii.Kernel.call(this, "addEventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dataResourceType, "dataResourceType is required"), java.util.Objects.requireNonNull(dataResourceValues, "dataResourceValues is required") });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds a Lambda Data Event Selector for filtering events that match Lambda function operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param handlers the list of lambda function handlers whose data events should be logged (maximum 250 entries). This parameter is required.
     * @param options the options to configure logging of management and data events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLambdaEventSelector(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.lambda.IFunction> handlers, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions options) {
        software.amazon.jsii.Kernel.call(this, "addLambdaEventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(handlers, "handlers is required"), options });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds a Lambda Data Event Selector for filtering events that match Lambda function operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param handlers the list of lambda function handlers whose data events should be logged (maximum 250 entries). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLambdaEventSelector(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.lambda.IFunction> handlers) {
        software.amazon.jsii.Kernel.call(this, "addLambdaEventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(handlers, "handlers is required") });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds an S3 Data Event Selector for filtering events that match S3 operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param s3Selector the list of S3 bucket with optional prefix to include in logging (maximum 250 entries). This parameter is required.
     * @param options the options to configure logging of management and data events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addS3EventSelector(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudtrail.S3EventSelector> s3Selector, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions options) {
        software.amazon.jsii.Kernel.call(this, "addS3EventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(s3Selector, "s3Selector is required"), options });
    }

    /**
     * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     * <p>
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     * <p>
     * This method adds an S3 Data Event Selector for filtering events that match S3 operations.
     * <p>
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     * <p>
     * @param s3Selector the list of S3 bucket with optional prefix to include in logging (maximum 250 entries). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addS3EventSelector(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudtrail.S3EventSelector> s3Selector) {
        software.amazon.jsii.Kernel.call(this, "addS3EventSelector", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(s3Selector, "s3Selector is required") });
    }

    /**
     * Log all Lambda data events for all lambda functions the account.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html</a>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAllLambdaDataEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions options) {
        software.amazon.jsii.Kernel.call(this, "logAllLambdaDataEvents", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * Log all Lambda data events for all lambda functions the account.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAllLambdaDataEvents() {
        software.amazon.jsii.Kernel.call(this, "logAllLambdaDataEvents", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Log all S3 data events for all objects for all buckets in the account.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html</a>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAllS3DataEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions options) {
        software.amazon.jsii.Kernel.call(this, "logAllS3DataEvents", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * Log all S3 data events for all objects for all buckets in the account.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void logAllS3DataEvents() {
        software.amazon.jsii.Kernel.call(this, "logAllS3DataEvents", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * ARN of the CloudTrail trail i.e. arn:aws:cloudtrail:us-east-2:123456789012:trail/myCloudTrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTrailArn() {
        return software.amazon.jsii.Kernel.get(this, "trailArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARN of the Amazon SNS topic that's associated with the CloudTrail trail, i.e. arn:aws:sns:us-east-2:123456789012:mySNSTopic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTrailSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "trailSnsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudWatch log group to which CloudTrail events are sent.
     * <p>
     * <code>undefined</code> if <code>sendToCloudWatchLogs</code> property is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.Trail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.Trail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudtrail.TrailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Amazon S3 bucket.
         * <p>
         * Default: - if not supplied a bucket will be created with all the correct permisions
         * <p>
         * @return {@code this}
         * @param bucket The Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props().bucket(bucket);
            return this;
        }

        /**
         * Log Group to which CloudTrail to push logs to.
         * <p>
         * Ignored if sendToCloudWatchLogs is set to false.
         * <p>
         * Default: - a new log group is created and used.
         * <p>
         * @return {@code this}
         * @param cloudWatchLogGroup Log Group to which CloudTrail to push logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroup(final software.amazon.awscdk.services.logs.ILogGroup cloudWatchLogGroup) {
            this.props().cloudWatchLogGroup(cloudWatchLogGroup);
            return this;
        }

        /**
         * How long to retain logs in CloudWatchLogs.
         * <p>
         * Ignored if sendToCloudWatchLogs is false or if cloudWatchLogGroup is set.
         * <p>
         * Default: logs.RetentionDays.ONE_YEAR
         * <p>
         * @return {@code this}
         * @param cloudWatchLogsRetention How long to retain logs in CloudWatchLogs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetention(final software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention) {
            this.props().cloudWatchLogsRetention(cloudWatchLogsRetention);
            return this;
        }

        /**
         * To determine whether a log file was modified, deleted, or unchanged after CloudTrail delivered it, you can use CloudTrail log file integrity validation.
         * <p>
         * This feature is built using industry standard algorithms: SHA-256 for hashing and SHA-256 with RSA for digital signing.
         * This makes it computationally infeasible to modify, delete or forge CloudTrail log files without detection.
         * You can use the AWS CLI to validate the files in the location where CloudTrail delivered them.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableFileValidation To determine whether a log file was modified, deleted, or unchanged after CloudTrail delivered it, you can use CloudTrail log file integrity validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFileValidation(final java.lang.Boolean enableFileValidation) {
            this.props().enableFileValidation(enableFileValidation);
            return this;
        }

        /**
         * The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs.
         * <p>
         * Default: - No encryption.
         * <p>
         * @return {@code this}
         * @param encryptionKey The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * For most services, events are recorded in the region where the action occurred.
         * <p>
         * For global services such as AWS Identity and Access Management (IAM), AWS STS, Amazon CloudFront, and Route 53,
         * events are delivered to any trail that includes global services, and are logged as occurring in US East (N. Virginia) Region.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param includeGlobalServiceEvents For most services, events are recorded in the region where the action occurred. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(final java.lang.Boolean includeGlobalServiceEvents) {
            this.props().includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }

        /**
         * A JSON string that contains the insight types you want to log on a trail.
         * <p>
         * Default: - No Value.
         * <p>
         * @return {@code this}
         * @param insightTypes A JSON string that contains the insight types you want to log on a trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightTypes(final java.util.List<? extends software.amazon.awscdk.services.cloudtrail.InsightType> insightTypes) {
            this.props().insightTypes(insightTypes);
            return this;
        }

        /**
         * Whether or not this trail delivers log files from multiple regions to a single S3 bucket for a single account.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param isMultiRegionTrail Whether or not this trail delivers log files from multiple regions to a single S3 bucket for a single account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(final java.lang.Boolean isMultiRegionTrail) {
            this.props().isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }

        /**
         * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations, or only for the current AWS account.
         * <p>
         * If this is set to true then the current account <em>must</em> be the management account. If it is not, then CloudFormation will throw an error.
         * <p>
         * If this is set to true and the current account is a management account for an organization in AWS Organizations, the trail will be created in all AWS accounts that belong to the organization.
         * If this is set to false, the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations, or only for the current AWS account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(final java.lang.Boolean isOrganizationTrail) {
            this.props().isOrganizationTrail(isOrganizationTrail);
            return this;
        }

        /**
         * When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
         * <p>
         * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
         * <p>
         * This method sets the management configuration for this trail.
         * <p>
         * Management events provide insight into management operations that are performed on resources in your AWS account.
         * These are also known as control plane operations.
         * Management events can also include non-API events that occur in your account.
         * For example, when a user logs in to your account, CloudTrail logs the ConsoleLogin event.
         * <p>
         * Default: ReadWriteType.ALL
         * <p>
         * @return {@code this}
         * @param managementEvents When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managementEvents(final software.amazon.awscdk.services.cloudtrail.ReadWriteType managementEvents) {
            this.props().managementEvents(managementEvents);
            return this;
        }

        /**
         * The orgId.
         * <p>
         * Required when <code>isOrganizationTrail</code> is set to true to attach the necessary permissions.
         * <p>
         * Default: - No orgId
         * <p>
         * @return {@code this}
         * @param orgId The orgId. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orgId(final java.lang.String orgId) {
            this.props().orgId(orgId);
            return this;
        }

        /**
         * An Amazon S3 object key prefix that precedes the name of all log files.
         * <p>
         * Default: - No prefix.
         * <p>
         * @return {@code this}
         * @param s3KeyPrefix An Amazon S3 object key prefix that precedes the name of all log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(final java.lang.String s3KeyPrefix) {
            this.props().s3KeyPrefix(s3KeyPrefix);
            return this;
        }

        /**
         * If CloudTrail pushes logs to CloudWatch Logs in addition to S3.
         * <p>
         * Disabled for cost out of the box.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param sendToCloudWatchLogs If CloudTrail pushes logs to CloudWatch Logs in addition to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendToCloudWatchLogs(final java.lang.Boolean sendToCloudWatchLogs) {
            this.props().sendToCloudWatchLogs(sendToCloudWatchLogs);
            return this;
        }

        /**
         * SNS topic that is notified when new log files are published.
         * <p>
         * Default: - No notifications.
         * <p>
         * @return {@code this}
         * @param snsTopic SNS topic that is notified when new log files are published. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopic(final software.amazon.awscdk.services.sns.ITopic snsTopic) {
            this.props().snsTopic(snsTopic);
            return this;
        }

        /**
         * The name of the trail.
         * <p>
         * We recommend customers do not set an explicit name.
         * <p>
         * Default: - AWS CloudFormation generated name.
         * <p>
         * @return {@code this}
         * @param trailName The name of the trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trailName(final java.lang.String trailName) {
            this.props().trailName(trailName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.Trail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.Trail build() {
            return new software.amazon.awscdk.services.cloudtrail.Trail(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudtrail.TrailProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudtrail.TrailProps.Builder();
            }
            return this.props;
        }
    }
}
