package software.amazon.awscdk.services.cloudwatch;

/**
 * Comparison operator for evaluating alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * HostedZone myHostedZone;
 * Certificate certificate = Certificate.Builder.create(this, "Certificate")
 *         .domainName("hello.example.com")
 *         .validation(CertificateValidation.fromDns(myHostedZone))
 *         .build();
 * certificate.metricDaysToExpiry().createAlarm(this, "Alarm", CreateAlarmOptions.builder()
 *         .comparisonOperator(ComparisonOperator.LESS_THAN_THRESHOLD)
 *         .evaluationPeriods(1)
 *         .threshold(45)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.472Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.ComparisonOperator")
public enum ComparisonOperator {
    /**
     * Specified statistic is greater than or equal to the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
    /**
     * Specified statistic is strictly greater than the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GREATER_THAN_THRESHOLD,
    /**
     * Specified statistic is strictly less than the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LESS_THAN_THRESHOLD,
    /**
     * Specified statistic is less than or equal to the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LESS_THAN_OR_EQUAL_TO_THRESHOLD,
    /**
     * Specified statistic is lower than or greater than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD,
    /**
     * Specified statistic is greater than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GREATER_THAN_UPPER_THRESHOLD,
    /**
     * Specified statistic is lower than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LESS_THAN_LOWER_THRESHOLD,
}
